<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.77).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
---><cfsilent>
	
<cfparam name="ModelGlue_PARENT_BEAN_FACTORY" default="" />
<cfparam name="ModelGlue_APP_KEY" default="_modelglue" />
<cfparam name="ModelGlue_CONFIG_PATH" default="" />
<cfparam name="ModelGlue_LOCAL_COLDSPRING_PATH" default="./config/ColdSpring.xml" />
<cfparam name="ModelGlue_CORE_COLDSPRING_PATH" default="/ModelGlue/gesture/configuration/ModelGlueConfiguration.xml" />
<cfparam name="ModelGlue_PARENT_BEAN_FACTORY" default="" />
<cfparam name="ModelGlue_VERSION_INDICATOR" default="GESTURE" />
<cfparam name="request._modelglue.bootstrap" default="#structNew()#" />
<cfparam name="request._modelglue.bootstrap.blockEvent" default="0" />

<cfset request._modelglue.bootstrap.initializationRequest = false />
<cfset request._modelglue.bootstrap.appKey = ModelGlue_APP_KEY />

<cfif not structKeyExists(application, ModelGlue_APP_KEY) 
			or (
					structKeyExists(url, application[ModelGlue_APP_KEY].configuration.reloadKey)
					and url[application[ModelGlue_APP_KEY].configuration.reloadKey] eq application[ModelGlue_APP_KEY].configuration.reloadPassword
			)
			or (
					application[ModelGlue_APP_KEY].configuration.reload
			)>
	<cflock name="#expandPath(".")#/.modelglue.loading" type="exclusive" timeout="60">
		<cfif not structKeyExists(application, ModelGlue_APP_KEY)
					or (
							structKeyExists(url, application[ModelGlue_APP_KEY].configuration.reloadKey)
							and url[application[ModelGlue_APP_KEY].configuration.reloadKey] eq application[ModelGlue_APP_KEY].configuration.reloadPassword
					)
					or (
							application[ModelGlue_APP_KEY].configuration.reload
					)>
			<cfset request._modelglue.bootstrap.initializationRequest = true />

			<cfset boot = createObject("component", "ModelGlue.gesture.loading.ColdSpringBootstrapper") />

			<cfset boot.applicationKey = ModelGlue_APP_KEY />
			<cfset boot.coldspringPath = ModelGlue_LOCAL_COLDSPRING_PATH />
			<cfset boot.coreColdspringPath = ModelGlue_CORE_COLDSPRING_PATH />
			<cfset boot.modelglueVersionIndicator = ModelGlue_VERSION_INDICATOR />
			<cfset boot.primaryModulePath = ModelGlue_CONFIG_PATH />
			<cfset boot.parentBeanFactory = ModelGlue_PARENT_BEAN_FACTORY />

			<cfset mg = boot.storeModelGlue() />
		<cfelse>
			<cfset mg = application[ModelGlue_APP_KEY] />
		</cfif>
	</cflock>
<cfelse>
	<cfset mg = application[ModelGlue_APP_KEY] />
</cfif>


<cfif not request._modelglue.bootstrap.blockEvent>
	<cfset ec = mg.handleRequest() />
</cfif>

</cfsilent><cfif not request._modelglue.bootstrap.blockEvent><cfoutput>#ec.getLastRendereredView()#</cfoutput>

<cfif mg.configuration.debug neq "false" and mg.configuration.debug neq "none"> 
<cfoutput>
	#mg.renderContextLog(ec)#
</cfoutput>
</cfif>
</cfif>
