<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.77).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent output="false"
						 hint="I am an Adapter implementation providing a wrapper around a BeanUtils instance.">
						 
<cffunction name="init" output="false">
	<cfargument name="beanUtils" required="true" default="#createObject("component", "com.firemoss.beanutils.BeanUtils").init()#" hint="BeanUtils instance to wrap." />
	
	<cfset variables._bu = arguments.beanUtils />
	
	<cfreturn this />
</cffunction>

<cffunction name="populate" output="false">
	<cfargument name="target" type="any" hint="Either an instance of a CFC or the name of a CFC (e.g., ""com.mydomain.mymodel.MyBean"") to populate." />
	<cfargument name="source" type="any" hint="A structure to use as source for population." />
	
	<!--- Create instance if simple target --->
	<cfif not isObject(arguments.target)>
		<cfset arguments.target = createObject("component", arguments.target) />
		<cfif structKeyExists(arguments.target, "init")>
			<cfinvoke component="#arguments.target#" method="init" />
		</cfif>
	</cfif>
	
	<!--- Populate --->
	<cfset variables._bu.inject(arguments.source, arguments.target) />
	
	<cfreturn arguments.target />
</cffunction>

</cfcomponent>