<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.89).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent output="false" hint="Exposes Model-Glue application to remote clients.">

<cfset variables.locator = createObject("component", "ModelGlue.Util.ModelGlueFrameworkLocator") />

<cffunction name="getModelGlue" output="false">
	<cfset var mg = "" />
	
	<!--- Bootstrap MG by invoking the main template but blocking event execution. --->
	<cfset request._modelglue.bootstrap.blockEvent = 1 />
	
	<cfmodule template="#template#" />
	
	<cfset mg = variables.locator.findInScope(application, request._modelglue.bootstrap.appKey) />
	
	<cfif not arrayLen(mg)>
		<cfthrow message="Can't locate Model-Glue instance named #request._modelglue.bootstrap.appKey# in application scope!" />
	</cfif>
	
	<cfreturn mg[1] />
</cffunction>

<cffunction name="executeEvent" output="false" access="remote" returntype="struct">
	<cfargument name="eventName" type="string" required="true" />
	<cfargument name="values" type="struct" required="true" default="#structNew()#" >
	<cfargument name="returnValues" type="string" required="false" default="" />
		
	<cfset var i = "" />
	<cfset var event = getModelGlue().executeEvent(argumentCollection=arguments) />
	<cfset var result = structNew() />
	
	<cfloop list="#arguments.returnValues#" index="i">
		<cfset result[i] = event.getValue(i) />
	</cfloop>
	
	<cfreturn result />
</cffunction>

</cfcomponent>