/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.service
{
	import mx.rpc.AsyncToken;
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.events.FaultEvent;
	
	public class AsynchronousOperationHelper implements IResponder
	{
		public var resultFunction:Function;
		public var faultFunction:Function;

		private var token:AsyncToken;
		private var responder:IResponder;
		private var handleResultManually:Boolean;
			
		public function AsynchronousOperationHelper(token:AsyncToken, result:Function=null, fault:Function=null, handleResultManually:Boolean=false) {
			this.token = token;
			this.responder = responder;
			this.resultFunction = result;
			this.faultFunction = fault;
			this.handleResultManually = handleResultManually;
			
			this.token.helper = this;
			this.token.resultFunction = result;
			this.token.faultFunction = fault;
									
			token.addResponder(this);
		}
		
		public function handleResult(resultEvent:ResultEvent):void {
			var resultFunction:Function = resultEvent.token.resultFunction;

			if (resultFunction != null) {
				if (!this.handleResultManually) {
					resultFunction.apply(null, [resultEvent.result]);
				} else {
					resultFunction.apply(null, [resultEvent]);
				}
			}
		}
		
		public function handleFault(faultEvent:FaultEvent):void {
			var faultFunction:Function = faultEvent.token.faultFunction;

			if (faultFunction == null) {
				throw(faultEvent.fault);
			} else {
				if (!this.handleResultManually) {
					faultFunction.apply(null, [faultEvent.fault]);
				} else {
					faultFunction.apply(null, [faultEvent]);
				}
			}
		}

		public function result(data:Object):void {
			ResultEvent(data).token.helper.handleResult(data);
		}
		
		public function fault(info:Object):void {
			FaultEvent(info).token.helper.handleFault(info);
		}
		
		
		
	}
}