<cfsetting enablecfoutputonly=true showdebugoutput=false>
<!---
	Name         : rss.cfm
	Author       : Raymond Camden 
	Created      : July 5, 2004
	Last Updated : March 2, 2007
	History      : Support for UUID (rkc 1/27/05)
				   You can't have 2 or more of the same link, so I add r=X to make it unique. Thanks to Tom Thomas for finding this bug (rkc 8/3/05)
				   Title used in RSS wasn't dynamic (rkc 3/2/07)
	Purpose		 : Displays RSS for a Conference
--->

<cfif not isDefined("url.conferenceid") or not len(url.conferenceid)>
	<cflocation url="index.cfm" addToken="false">
</cfif>

<!--- get parent conference --->
<cftry>
	<cfset request.conference = application.galleon.conference.getConference(url.conferenceid)>
	<cfcatch>
		<cflocation url="index.cfm" addToken="false">
	</cfcatch>
</cftry>

<!--- get my latest posts --->
<cfset data = application.galleon.conference.getLatestPosts(conferenceid=url.conferenceid)>

<cfcontent type="text/xml"><cfoutput><?xml version="1.0" encoding="iso-8859-1"?>

<rdf:RDF 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns##"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns="http://purl.org/rss/1.0/"
>

	<channel rdf:about="#application.galleon.settings.rootURL#">
	<title>#application.galleon.settings.title# : Conference : #request.conference.name#</title>
	<description>Conference : #request.conference.name# : #request.conference.description#</description>
	<link>#application.galleon.settings.rootURL#</link>
	
	<items>
		<rdf:Seq>
			<cfloop query="data">
			<rdf:li rdf:resource="#application.galleon.settings.rootURL#messages.cfm?#xmlFormat("threadid=#threadid#")##xmlFormat("&r=#currentRow#")#" />
			</cfloop>
		</rdf:Seq>
	</items>
	
	</channel>

	<cfloop query="data">
		<cfset dateStr = dateFormat(posted,"yyyy-mm-dd")>
		<cfset z = getTimeZoneInfo()>
		<cfset dateStr = dateStr & "T" & timeFormat(posted,"HH:mm:ss") & "-" & numberFormat(z.utcHourOffset,"00") & ":00">
	
		<item rdf:about="#application.galleon.settings.rootURL#messages.cfm?#xmlFormat("threadid=#threadid#")##xmlFormat("&r=#currentRow#")#">
		<title>#xmlFormat(title)#</title>
		<description>#xmlFormat(body)#</description>
		<link>#application.galleon.settings.rootURL#messages.cfm?#xmlFormat("threadid=#threadid#")##xmlFormat("&r=#currentRow#")#</link>
		<dc:date>#dateStr#</dc:date>
		<dc:subject>#thread#</dc:subject>
		</item>
	</cfloop>
	
</rdf:RDF>
</cfoutput>

<cfsetting enablecfoutputonly=false>
