<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.89).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent output="false" extends="ModelGlue.gesture.eventrequest.EventRequestPhase"
						 hint="Abstract of an execution phase that loads modules."
>
	
<cffunction name="init" output="false">
	<cfargument name="moduleLoaderFactory" require="true" hint="I am the factory through which module loaders may be attained." />
	<cfargument name="modules" type="array" required="true" hint="I am the list of XML modules to load as part of this phase." />
	
	<cfset variables._moduleLoader = arguments.moduleLoaderFactory.create("XML") />
	<cfset variables._modules = arguments.modules />	
</cffunction>

<cffunction name="loadModules" access="private" output="false" hint="Loads modules associated with this phase if we're in an initializing request.">
	<cfargument name="modelglue" />
	
	<cfset var i = "" />
	
	<cfif request._modelglue.bootstrap.initializationRequest>
		<cfloop from="1" to="#arrayLen(variables._modules)#" index="i">
			<cfset variables._moduleLoader.load(modelglue, variables._modules[i]) />
		</cfloop>
	</cfif>
</cffunction>

</cfcomponent>