/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.service
{
	import mx.rpc.IResponder;

	public class ResponderDelegate implements IResponder
	{
		private var target:Object;
		private var resultFunction:Function;
		private var faultFunction:Function;
		
		public function ResponderDelegate(target:Object, result:Function, fault:Function) {
			this.target = target;
			this.resultFunction = result;
			this.faultFunction = fault;		
		}
		
		public function result(data:Object):void {
			this.resultFunction.apply(this.target, [data]);
		}
		
		public function fault(info:Object):void {
			this.faultFunction.apply(this.target, [info]);
		}
		
	}
}