/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.flex.examples.todolists.model {

	[Bindable]
	public class ModelLocator {
		private static var modelLocator : ModelLocator;
		
		public var todos:TodoCollection;
				
		public static function getInstance() : ModelLocator {
			if (!modelLocator) modelLocator = new ModelLocator();
			return modelLocator;
		}
		
		public function ModelLocator() {	
			if ( modelLocator != null ) {
				throw new Error( "Only one ModelLocator instance should be instantiated" );	
			}
    }
      	
	}
}
