/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.examples.contactmanager.control.event
{
	import com.firemoss.modelglue.event.ModelGlueEvent;
	import com.firemoss.modelglue.examples.contactmanager.model.ContactTO;

	public class ContactEvent extends ModelGlueEvent
	{
		private var _contact:ContactTO
		
		public function ContactEvent(name:String, contact:ContactTO) {
			super(name);
			this.contact = contact;
		}
		
		public function set contact(value:ContactTO):void {
			this._contact = value;
			this.setValue("contact", value);
		}
		
		public function get contact():ContactTO {
			return this._contact
		}
		
	}
}