<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.89).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent output="false" extends="ModelGlue.gesture.controller.Controller">

<cffunction name="loadInitialXMLModule" output="false" hint="I get the bootstrapper from the request scope and loads the initial module.">
	<cfargument name="event" />
	
	<cfset var mg = "" />
	<cfset var cfg = "" />
	<cfset var loader = "" />

	<cfif arguments.event.getValue("modelglueReloaded")>	
		<cfset arguments.event.trace("Configuration", "Loading Initial XML Module") />
		<cfset mg = getModelGlue() />
		<cfset cfg = mg.getBean("modelglue.ModelGlueConfiguration") />
		<cfset loader = mg.getInternalBean("modelglue.ModuleLoaderFactory").create("XML") />
		
		<cfset loader.load(mg, cfg.getPrimaryModule()) />
	</cfif>
</cffunction>

</cfcomponent>