/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.loader
{
	import com.firemoss.modelglue.tags.ModelGlue;
	import com.firemoss.modelglue.Framework;
	import com.firemoss.modelglue.tags.Controller;
	import flash.utils.getDefinitionByName;
	import com.firemoss.modelglue.tags.MessageListener;
	import com.firemoss.modelglue.eventhandler.MessageBroadcast;
	import com.firemoss.modelglue.eventhandler.EventHandler;
	import com.firemoss.modelglue.tags.event.Handler;
	import com.firemoss.modelglue.tags.event.Message;
	import com.firemoss.modelglue.tags.event.Argument;
	import com.firemoss.modelglue.tags.event.Result;
	
	public class TagBasedLoader
	{

		private var rootTag:ModelGlue;
		private var framework:Framework;
		
		public function TagBasedLoader(rootTag:ModelGlue, framework:Framework) {
			this.rootTag = rootTag;
			this.framework = framework;
		}
		
		public function load():void {
			loadControllers();
			loadEventHandlers();
		}
		
		private function loadControllers():void {
			var controllers:Array = this.rootTag.controllers;
			var controller:Controller;
			var i:int;
						
			for each (controller in controllers) {
				loadController(controller as Controller);
			}
		}
		
		private function loadController(controller:Controller):void {
			var i:int;
			var messageListener:MessageListener;
			var messageBroadcast:MessageBroadcast;
			
			this.framework.addController(controller);

			for each (messageListener in controller.messageListeners) {
				messageBroadcast = MessageBroadcast.forMessageNamed(messageListener.message);
				
				if (messageListener.method != null) {
					messageBroadcast.addListener(controller, messageListener.method);
				} else {
					messageBroadcast.addListener(controller, controller[messageListener.functionName]);
				}
			}
		}
		
		private function loadEventHandlers():void {
			var eventHandlers:Array = this.rootTag.eventHandlers;
			var handler:EventHandler;
			var i:int;
						
			for (i=0;i<eventHandlers.length;i++) {
				loadEventHandler(eventHandlers[i] as Handler);
			}
		}
		
		private function loadEventHandler(eh:Handler):void {
			var handler:EventHandler = new EventHandler();
			var messageBroadcast:MessageBroadcast;
			var message:Message;
			var argument:Argument;
			var result:Result;
			var i:int;
			var j:int;
			
			handler.name = eh.name;
			
			for (i=0;i<eh.broadcasts.length;i++) {
				message = eh.broadcasts[i] as Message;
				
				messageBroadcast = new MessageBroadcast(message.name);
				
				for (j=0;j<message.arguments.length;j++) {
					argument = message.arguments[j] as Argument;
					messageBroadcast.addArgument(argument.name, argument.value);
				}
				
				handler.addMessageBroadcast(messageBroadcast);
			}
			
			for (i=0;i<eh.results.length;i++) {
				result = eh.results[i] as Result;
				
				if (result.name != null) {
					handler.addExplicitResult(result.name, result);
				} else {
					if (result.eventHandler is String) {
						handler.addImplicitResult(result.eventHandler as String);					
					} else {
						handler.addImplicitResult(result.eventHandler.name);					
					}
				}
			}
			
			this.framework.addEventHandler(handler);
		}
	}
}