SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT;
SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS;
SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION;
SET NAMES utf8;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE=NO_AUTO_VALUE_ON_ZERO */;


CREATE DATABASE /*!32312 IF NOT EXISTS*/ `dbaggregator`;
USE `dbaggregator`;
CREATE TABLE `category` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `category` (`id`,`name`,`description`) VALUES 
 (1,'ColdFusionMX','it\'s cool'),
 (3,'Geek Stuff','');
CREATE TABLE `category_channels` (
  `fk_category_id` int(10) unsigned NOT NULL default '0',
  `fk_channel_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`fk_category_id`,`fk_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `category_channels` (`fk_category_id`,`fk_channel_id`) VALUES 
 (1,2),
 (3,3),
 (3,4);
CREATE TABLE `channel` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `url` text NOT NULL,
  `title` text NOT NULL,
  `description` text,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `channel` (`id`,`url`,`title`,`description`) VALUES 
 (2,'http://www.d-ross.org/xml/rss.xml','d-ross.org','saddsadsadsa sad a'),
 (3,'http://www.engadget.com/rss.xml','Engaget',''),
 (4,'http://www.docnotes.net/index.xml','Jacob Reider MD','');
CREATE TABLE `entry` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `fk_channel_id` int(10) unsigned NOT NULL default '0',
  `url` text NOT NULL,
  `title` text,
  `body` text NOT NULL,
  `authored_on` datetime default NULL,
  `authored_by` varchar(200) default NULL,
  `guid` varchar(85) NOT NULL default '',
  `retrieved_on` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (119,3,'http://www.engadget.com/entry/1234000787030926/','HollerBot, the sub-$500 DIY robot','<a href=\"http://neuroatomik.com/hollerbot/overview.php\"><img alt=\"HollerBot\"\nsrc=\"http://www.weblogsinc.com/common/images/6291976986574165.JPG?0.27774382030319966\" align=\"right\" border=\"0\"\nheight=\"313\" hspace=\"4\" vspace=\"0\" width=\"250\" /></a> \n\n<p>Zach Smith was tired of waiting for an affordable robot that did what he wanted it to do, so he&#8217;s building his\nown.&nbsp; And like any good geek, he&#8217;s building it entirely out of off-the-shelf consumer hardware and free software,\nall for less than $500.&nbsp; He also hopes to make it controllable via the Internet and able to communicate with the\nreal world, although we&#8217;re not really sure exactly what else this thing is supposed to be able to do besides run around\ntormenting people. Fortunately, that&#8217;s good enough for us.<br />\n\n<br />\n\n [Via <a href=\"http://www.boingboing.net/2005/02/08/sub500_robot_made_fr.html\">BoingBoing</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000787030926/','2005-02-09 09:51:47'),
 (120,3,'http://www.engadget.com/entry/1234000020030924/','ProxiDate, meet singles over Bluetooth','<a href=\"http://www.proxidating.com/index.php?code_pays=US\"><img alt=\"ProxiDate\"\nsrc=\"http://www.weblogsinc.com/common/images/8928350835970126.JPG?0.25703713461732003\" align=\"right\" border=\"1\"\nheight=\"131\" hspace=\"4\" vspace=\"16\" width=\"110\" /></a> \n\n<p>You&#8217;d have to seriously believe in love against all odds and possibilities to think your future significant other\nhas a cellphone with Bluetooth, knows how to operate said phone and Bluetooth, has ProxiDating installed, <em>and</em>\nhappens to be within range of you at that moment. True, we&#8217;re sure stranger things have happened than two people\npicking one another up with <a href=\"http://www.engadget.com/search/?q=bluetooth\">Bluetooth</a>, but we might go out on\na limb and tell you to save yourself the heartache, since you may wind up feeling much lonelier checking ProxiDate\nevery 3 minutes on the subway than when you started. May we suggest you just get on myspace or friendster?<br />\n\n<br />\n\n [Via <a href=\"http://textually.org\"><span style=\"text-decoration: underline;\">textually.org</span></a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000020030924/','2005-02-09 09:51:47');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (121,3,'http://www.engadget.com/entry/1234000540030890/','Yes, it\'s another exploding cellphone story','<img alt=\"exploding cellphone\" src=\"http://www.weblogsinc.com/common/images/2994556244611879.jpg?0.11963411263513268\"\nalign=\"right\" border=\"1\" height=\"156\" hspace=\"4\" vspace=\"16\" width=\"180\" /> \n\n<p>And now, the latest from the <a href=\"http://www.engadget.com/entry/1234000330021404/\">exploding cellphone</a>\nfront: Kris Munford, a 911 dispatcher for the Ogden, Utah, police and fire department, smelled something funny coming\nfrom her jacket (and we&#8217;re going to skip the obvious and crude jokes here, okay?). Before she could do anything, her\ncellphone had burned through the jacket and landed on the floor, where it exploded, sending plastic shrapnel across the\nroom. As usual, the culprit appears to have been the phone&#8217;s battery. Munford was shaken but uninjured, and local TV\nstation KSL-TV offered some helpful advice for anyone with a potentially explosive phone: &#8220;If it gets too cold outside,\njust pick up your cellphone. It may be one of those that puts out enough heat to start a fire.&#8221; Heh, heh. Love that\nnewsroom humor.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000540030890/','2005-02-09 09:51:47'),
 (122,3,'http://www.engadget.com/entry/1234000630030918/','HP fires Carly Fiorina','<a href=\"http://money.cnn.com/2005/02/09/technology/hp_fiorina/index.htm\"><img alt=\"Carly Fiorina HP\"\nsrc=\"http://www.weblogsinc.com/common/images/5733952306328252.jpg?0.5844452444857717\" align=\"right\" border=\"1\"\nheight=\"156\" hspace=\"4\" vspace=\"16\" width=\"150\" /></a>\n\n<p>Carly is out! Not many details about what exactly sparked this to happen today (or well, yesterday), but there&#8217;s\nbeen a boardroom coup at HP, and CEO and Chairman Carly Fiorina has been ousted, effective <em>immediately</em>. Could\nmean some very big changes for HP&#8217;s direction, including even possibly that\n<a href=\"http://www.engadget.com/entry/4597373272761351/\">breakup of the company some people have been hinting at</a>\n(though we have no confirmation right now as to why she was fired). We&#8217;ll keep you posted.<br />\n\n<br />\n\n[Thanks, Ben]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000630030918/','2005-02-09 09:51:47');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (123,3,'http://www.engadget.com/entry/1234000980030864/','More details on T-Mobile\'s MDA IV Pocket PC Phone','<img alt=\"MDA IV\" src=\"http://www.weblogsinc.com/common/images/1768878332255289.jpg?0.4218696231873911\" align=\"right\"\nborder=\"1\" height=\"197\" hspace=\"4\" vspace=\"16\" width=\"230\" /> \n\n<p>None of this was confirmed during last week&#8217;s semi-official, but MoDaCo seems fairly sure that\n<a href=\"http://www.engadget.com/entry/1234000090030074/\">T-Mobile&#8217;s MDA IV</a> 3G Pocket PC Phone (you know, the one\nwith a VGA resolution swiveling LCD screen, WiFi, Bluetooth, a 520MHz processor, and a QWERTY keyboard) will run\nWindows Mobile 2005, come with RIM&#8217;s BlackBerry Connect email technology, and be able to automatically switch between\nWiFi and 3G/GPRS. Probably won&#8217;t be out until the 3rd quarter, and even then, it&#8217;ll only be available in Europe.<br />\n\n<br />\n\n [Via <a href=\"http://www.pocketpcthoughts.com\">Pocket PC Thoughts</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000980030864/','2005-02-09 09:51:48'),
 (124,3,'http://www.engadget.com/entry/1234000663030868/','April 29th for the PlayStation Portable in Europe?','<a href=\"http://www.joystiq.com/entry/1234000557030848/\"><img alt=\"PSP\"\nsrc=\"http://www.weblogsinc.com/common/images/5696149836182451.jpg?0.28167891491665165\" align=\"right\" border=\"0\"\nheight=\"200\" hspace=\"4\" vspace=\"16\" width=\"225\" /></a> \n\n<p>Do we have a European release date for the <a href=\"http://www.engadget.com/entry/1234000510024287/\">PlayStation\nPortable</a>? Sony already admitted they were going to <a href=\"http://www.engadget.com/entry/1234000480030512/\">miss\ntheir target of launching the new console in Europe by the end of March</a>, and while they haven&#8217;t said anything\nofficial yet, Amazon.co.uk is listing the PSP as coming out on April 29th with a retail price of &pound;179.99 (there&#8217;s a\ndisclaimer that this date is subject to change). That works out to about $335 dollars, or $85 more than they&#8217;re going\nto be charging for the <a href=\"http://www.engadget.com/entry/1234000197030240/\">PSP Value Pack</a> here in the\nStates.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000663030868/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (125,3,'http://www.engadget.com/entry/1234000830030679/','Pentax Optio X reviewed','<a href=\"http://www.anandtech.com/digitalcameras/showdoc.aspx?i=2340&amp;p=12\"><img alt=\"Pentax Optio X\"\nsrc=\"http://www.weblogsinc.com/common/images/2115679577945324.JPG?0.06611866872915806\" border=\"0\" height=\"218\"\nhspace=\"4\" vspace=\"16\" width=\"425\" /></a><br />\n\n \n\n<p>AnandTech has a review of Pentax&#8217;s new twistable <a href=\"http://www.engadget.com/entry/5608373382761251/\">Optio\nX</a> digital camera.&nbsp; The specs seem to hit all the right notes, 5 megapixel with a 3x optical zoom, but as you\ncan expect with ultra-compact cameras, there are some trade offs.&nbsp; Resolution is below average, and it has slow\nshutter lag and lackluster battery life.&nbsp; But if style&#8217;s your primary concern, the Optio X will run you about\n$300.<br />\n\n<br />\n\n [Via\n<a href=\"http://www.photographyblog.com/index.php/weblog/comments/pentax_optio_x_review_at_anandtech/\">Photography\nBlog</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000830030679/','2005-02-09 09:51:48'),
 (126,3,'http://www.engadget.com/entry/1234000983030814/','Is dust overheating that desktop?','<a href=\"http://www.sudhian.com/showdocs.cfm?aid=648\"><img alt=\"Dusty PC\"\nsrc=\"http://www.weblogsinc.com/common/images/8784671601391092.JPG?0.4174467662418194\" align=\"right\" border=\"1\"\nheight=\"202\" hspace=\"4\" vspace=\"16\" width=\"275\" /></a> \n\n<p>It turns out excessive dust in your PC can cause more harm that even we thought.&nbsp; Sudhian.com found that\ncleaning dust out of a PC cut the CPU temperature down by over 14 degress with the case closed, from 65 degrees before\ndusting to 50.5 after blasting it with compressed air.&nbsp; The system was still functioning well at the higher\ntemperature, but likely would have run into problems sooner or later. So if you haven&#8217;t cracked your case open in a\ncouple of months, you might want to do so before it ends up looking like this fine specimen here.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000983030814/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (127,3,'http://www.engadget.com/entry/1234000823030675/','iZon headset includes Bluetooth, MP3 player, radio','<p><img alt=\"izon\" src=\"http://www.weblogsinc.com/common/images/2646421442120521.jpg?0.7254768228730795\" align=\"right\"\nborder=\"1\" height=\"180\" hspace=\"4\" vspace=\"16\" width=\"138\" />iZon, the company that brought you that\n<a href=\"http://www.engadget.com/entry/1234000350026719/\">portable AM/FM radio</a> designed to look like an iPod mini,\nhas another new product out, which they advertise as a Bluetooth MP3 headset. According to the website of the\nheadphone&#8217;s distributor (where you can also check out their rather uninspired knockoff of the iPod&#8217;s ads), it&#8217;s a\nBluetooth headset with built-in mic that&#8217;ll work with Bluetooth phones, and is also an MP3 player and FM radio. If it\nis actually all of the above, it sounds like it&#8217;s worth checking out, but we&#8217;ll have to see for ourselves, given our\nlast experience with iZon&#8217;s products.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000823030675/','2005-02-09 09:51:48'),
 (128,3,'http://www.engadget.com/entry/1234000667030805/','Arizona State opens flexible-display center','<img alt=\"thin flexible display asu army\"\nsrc=\"http://www.weblogsinc.com/common/images/6696037613757804.jpg?0.032814793765113204\" align=\"right\" border=\"1\"\nheight=\"123\" hspace=\"4\" vspace=\"12\" width=\"251\" /> \n\n<p>Using $43.7 million in previously announced grants from the Army Research Lab, Arizona State University has opened a\n250,000 square-foot flexible display research center. Their first prototype, a 4-inch, semi-flexible display, is\nexpected to be out later this year. The center hopes to produce full-color flexible displays suitable for battlefield\nuse as well as commercial applications, including displays that can be rolled up or folded. Of course, the Army/ASU\nproject isn&#8217;t the only flexible-display initiative. Major manufacturers from Asia and Europe and North America\n<a href=\"http://www.engadget.com/search/?q=flexible+display&amp;submit=Search+%BB\">are also working</a> on the\ntechnology, and palmOne was <a href=\"http://www.engadget.com/entry/1234000050030792/\">just awarded</a> a patent for a\nflexible dual-sided display for use in PDAs. However, the Holy Grail of flexible displays &#8212; a low-power, high-res,\nwireless &#8220;newspaper&#8221; that you can roll up or fold and throw in your pocket &#8212; still remains a long way off.</p>\n\n\n<p>[Thanks, Ben]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000667030805/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (129,3,'http://www.engadget.com/entry/1234000667030752/','LG begins selling thin-CRT TV','<img alt=\"Philips Slim CRT\" src=\"http://www.weblogsinc.com/common/images/6829473272658137.jpg?0.20349158639804\"\nalign=\"right\" border=\"0\" height=\"239\" hspace=\"4\" vspace=\"16\" width=\"200\" /> \n\n<p>LG.Philips has begun selling their <a href=\"http://www.engadget.com/entry/1234000180020920/\">previously\nannounced</a> slim-CRT TV, a 32-inch model with a roughly 14-inch tube. Currently available only in Korea, the TV goes\nfor about $1,400, a hefty premium over even a&nbsp; high-end &#8220;flat tube&#8221; TV, but still much cheaper than a comparable\nplasma display. More &#8212; and thinner &#8212; models are expected later this year from both LG and Samsung. We&#8217;ll have to wait\nand see if U.S. prices end up being lower than those in Korea, given that you can already get a 30-inch LCD for about\n$1,500.<br />\n\n<br />\n\n [Via <a href=\"http://news.designtechnica.com/\">Designtechnica</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000667030752/','2005-02-09 09:51:48'),
 (130,3,'http://www.engadget.com/entry/1234000763030762/','FCC\'s CAN-SPAM list actually made of wholesome goodness','<img alt=\"spam\" src=\"http://www.weblogsinc.com/common/images/2476262272761362.jpg?0.8808321241680713\" align=\"right\"\nborder=\"1\" height=\"134\" hspace=\"4\" vspace=\"12\" width=\"180\" /> \n\n<p>According to the AP, the FCC had announced as part of the\n<a href=\"http://www.fcc.gov/cgb/policy/canspam.html\">CAN-SPAM Act</a> they would be compiling a list of domains that\nsend email to cellphone users.&nbsp; Now the conclusion we initially drew from this was, &#8220;Sweet, a list of reported\nspammers so that the FCC might, you know, protect us from crap.&#8221;&nbsp; Turns out the FCC list is actually a compilation\nof cellphone-related domains that it is illegal for telemarketers to send email to (without permission, of\ncourse).&nbsp; This is a 180 from\n<a href=\"http://story.news.yahoo.com/news?tmpl=story2&amp;u=/ap/20050208/ap_on_hi_te/cell_phones_spam\">earlier\nreports</a> on the list, but also probably a lot more practical since spammers already know how to switch domains once\none has been blacklisted.&nbsp;</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000763030762/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (131,3,'http://www.engadget.com/entry/1234000810030759/','Toshiba Satellite P35-S629 17-inch gaming notebook','<p><a href=\"http://www.mobilemag.com/content/100/334/C3703/\"><img alt=\"Toshiba P35 notebook\"\nsrc=\"http://www.weblogsinc.com/common/images/3621741285227152.jpg?0.89366637881521\" align=\"right\" border=\"0\"\nheight=\"200\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a>Toshiba just updated their line of widescreen 17-inch Satellite\nP35 gaming laptop. The P35-S629 sports a Mobile Pentium 4 3.3GHz processor, 512MB RAM (upgradeable to 2GB), a 100GB\nhard drive, a built-in DVD recorder drive, and either an ATI Mobility Radeon 9000 or 9700 video card. Comes standard\nwith SRS TruSurround XT technology and Harman Kardon speakers and is available now directly from Toshiba for $1800.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000810030759/','2005-02-09 09:51:48'),
 (132,3,'http://www.engadget.com/entry/1234000020030825/','CDMA BlackBerry 7250 for Verizon','<p><a href=\"http://www.geekzone.co.nz/content.asp?ContentId=4030\"><img alt=\"BlackBerry 7250\"\nsrc=\"http://www.weblogsinc.com/common/images/7684793146957782.JPG?0.2616694813118289\" align=\"right\" border=\"0\"\nheight=\"181\" hspace=\"4\" vspace=\"16\" width=\"150\" /></a>Verizon is going to start carrying another new CDMA BlackBerry\nlater this month, the 7250. This one contains pretty much the same feature set as the\n<a href=\"http://www.engadget.com/entry/6326667344488545/\">BlackBerry 7750</a> we covered a few months ago (like 32MB of\nflash memory and 4MB of SRAM), but the 7250 has a smaller screen, weighs a bit less, and adds Bluetooth to the mix.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000020030825/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (133,3,'http://www.engadget.com/entry/1234000243030638/','Chemist claims to have discovered soap-free cleaning','<a href=\"http://www.telegraph.co.uk/news/main.jhtml;sessionid=YFD5WZTIVIGETQFIQMGCM5OAVCBQUJVC?xml=/news/2005/02/06/nwater06.xml&amp;sSheet=/news/2005/02/06/ixhome.html&amp;secureRefresh=true&amp;_requestid=67408\">\n<img alt=\"Smart Tag Washing Machine\"\nsrc=\"http://www.weblogsinc.com/common/images/7943941283984717.jpg?0.06316233489181267\" align=\"right\" border=\"0\"\nheight=\"152\" hspace=\"4\" vspace=\"16\" width=\"180\" /></a> \n\n<p>Chemistry professor Richard Pashley says he&#8217;s found a way to clean clothes without using soap.&nbsp; The key to his\ndiscovery is a process called &#8220;de-gassing&#8221;, which removes air particles from the water.&nbsp; Once de-gassed, the water\ncan apparently remove even the toughest stains, without using an ounce of detergent. Right now, the water can only be\nde-gassed by freezing it in liquid nitrogen (not exactly practical for soccer moms or college dorm residents), but\nPashley plans to develop semipermeable membranes, similiar to those used on oil rigs, that will de-gass water as it\npasses through.<br />\n\n<br />\n\n [Via <a href=\"http://www.redferret.net\">TRFJ</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000243030638/','2005-02-09 09:51:48'),
 (134,3,'http://www.engadget.com/entry/1234000903030823/','Robo-DJs make the world go around','<a href=\"http://www.scratchrobot.com/\"><img height=\"173\" alt=\"robo turntables\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/6437879455611867.JPG?0.8814675241819899\" width=\"230\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>Call it the Auto Decks, the Robo Technics, the Mech Turntablist, the Real Wheels of Steel, or the RoboTT, but if you\nhaven&#8217;t already figured it out, robots can be programmed to do anything humans can, only better&#8212;even music. MIDI is so\nold school, but robots that use MIDI to play instruments? That&#8217;s the hook up right there. And don&#8217;t even get us started\non robot turntables that will parse an email and use its text as scratch-entropy, and then email you back the very same\noutput scratches. Our only real fear is that between\nrobo-<a href=\"http://www.engadget.com/entry/7312188118707308/\">drums</a>,\n<a href=\"http://www.engadget.com/entry/1234000860022224/\">guitar</a>, and turntables, we&#8217;re only one Fred\nDurst-automaton away from mecha-Limp Bizkit.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000903030823/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (135,3,'http://www.engadget.com/entry/1234000013030820/','Dell\'s 30GB Digital Jukebox','<a href=\"http://click.linksynergy.com/fs-bin/click?id=4NWncA3Pu/c&amp;offerid=84645.382363706&amp;type=10&amp;subid=\"><img alt=\"Dell 30GB Digital Jukebox\"\n     src=\"http://www.weblogsinc.com/common/images/8154052283984616.JPG?0.10822126973502133\" align=\"right\" border=\"0\"\n     height=\"207\" hspace=\"4\" vspace=\"16\" width=\"150\" /></a> \n\n<p>Dell quietly rolled out a new 30GB version of their Digital Jukebox MP3 player. If you didn&#8217;t like what they were\ndoing before this isn&#8217;t going to turn you around, since it&#8217;s essentially just their 20GB player with a higher-capacity\ndrive, but this new 30GB model does retail for $299 and have a 1.92-inch LCD screen, 12 hours of battery life, and\nsupport for WMA and WAV as well as MP3.<br />\n\n<br />\n\n [Via <a href=\"http://www.dapreview.net\">DAPreview</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000013030820/','2005-02-09 09:51:48'),
 (136,3,'http://www.engadget.com/entry/1234000100030115/','TiVo Deathwatch','<img alt=\"sad TiVo logo\" src=\"http://www.weblogsinc.com/common/images/6563571713523346.JPG?0.3798135517606417\"\nalign=\"right\" border=\"0\" hspace=\"4\" vspace=\"16\" /> \n\n<p>Let&#8217;s get one thing straight: we love TiVo. We&#8217;ve been rooting for them for them since we got our first box (an\noriginal 14 hour Series 1 box that we still use to this day) and it&#8217;s not that we don&#8217;t want them to stick around, but\nwe think it&#8217;s time to face facts and admit that this company is in some serious trouble. Nah, their demise is not a\nforegone conclusion, but given events of the past few months (and as much as it tears us up inside to do this), we&#8217;re\nlaunching a TiVo deathwatch.<br />\n\n<br />\n\n Here are the facts: They&#8217;ve had two senior executives leave in the past month. DirecTV, which drives most of their\nsubscriber base, is more or less just letting the clock run out on the rest of their deal. TiVo&#8217;s stock is trading near\nits 52-week low (it&#8217;s around $3.75 a share today, a year ago it was trading north of ten bucks), and they continue to\nlose money quarter after quarter. Except for their acquisition of Strangeberry last year and some vague plans about\nlaunching a video-on-demand service with Netflix, they&#8217;ve given no indication of how they&#8217;re going to turn things\naround in the face of stiff competition from all sides.</p>\n\n\n<p>Sorry TiVo, but we&#8217;re declaring this deathwatch until further notice. We hope you&#8217;ll seriously turn things\naround&#8212;<a href=\"http://www.engadget.com/entry/3611628962873617/\">you know</a> what you\n<a href=\"http://www.engadget.com/entry/2239247581402225/\">need to do</a>. We&#8217;ll be updating this post periodically to\nreflect new developments until TiVo either declares bankruptcy, gets acquired, or (hopefully) reports a profitable\nquarter.</p>\n\n\n<ul>\n  <li><a href=\"http://www.engadget.com/entry/6563571713634447/\">September 30, 2004</a> - TiVo announces plans to team\n  up with Netflix on a video-on-demand service.</li>\n\n  <li><a href=\"http://www.engadget.com/entry/1234000880021272/\">November 22, 2004</a> - TiVo announces results for the\n  quarter ending October 31st. They lose &#8220;only&#8221; 33 cents a share, three times what they were losing a year\n  earlier.</li>\n\n  <li><a href=\"http://www.engadget.com/entry/1234000670026435/\">January 6, 2005</a> - DirecTV, TiVo&#8217;s primary source of\n  (new) subscribers with 2 of their 3 million customers, announces that it will introduce its own integrated digital\n  video recorder. Their contractual agreement ends in 2007, and is not expected to be renewed.</li>\n\n  <li><a href=\"http://www.engadget.com/entry/1234000683027751/\">January 12, 2005</a> - TiVo CEO and co-founder Mike\n  Ramsay steps aside as CEO. He will remain on as chairman.</li>\n\n  <li><a href=\"http://www.engadget.com/entry/1234000897029939/\">February 1, 2005</a> - TiVo president Marty Yudkovitz\n  resigns.</li>\n\n  <li>February 2, 2005 - TiVo&#8217;s stock slumps to a 52-week low.</li>\n</ul>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000100030115/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (137,3,'http://www.engadget.com/entry/1234000397030810/','Sony Ericsson says last year was about cameraphones, this year is about music','<a href=\"http://www.sonyericsson.com/spg.jsp?cc=global&amp;lc=en&amp;ver=4001&amp;template=pc1_1_1&amp;zone=pc&amp;lm=pc1&amp;prid=2813\">\n<img height=\"115\" alt=\"Sony Ericsson logo\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/2646532542131732.jpg?0.8159233399290797\" width=\"180\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>Remember what we said about <a href=\"http://www.engadget.com/entry/1234000103025327/\">2005 being the year of the MP3\nphone</a>? Yeah, well Sony Ericsson has just issued a press release announcing that after focusing on cameraphones last\nyear, this year they&#8217;re going to be turning their attention to music. They don&#8217;t get too specific&#8212;they&#8217;ll get down and\ndirty at the 3GSM World Congress next week&#8212;but they are promising consumers &#8220;a new experience with the handsets.&#8221; If\nthey know what&#8217;s good for them, they&#8217;ll offer up a handset with dedicated music player control buttons, plenty of\nstorage, good battery life, and native support for MP3 (and as many other formats as possible). The Sony-ness of Sony\nEricsson makes us nervous, but we&#8217;ll give &#8216;em the benefit of the doubt.<br />\n\n<br />\n\n[Via <a href=\"http://www.wirelessmoment.com/\">Reiter&#8217;s Camera Phone Report</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000397030810/','2005-02-09 09:51:48'),
 (138,3,'http://www.engadget.com/entry/1234000773030173/','Siemens wants mobile post-it notes','<p><a href=\"http://www.pcworld.com/news/article/0,aid,119598,00.asp\"><img alt=\"text message\"\nsrc=\"http://www.weblogsinc.com/common/images/7425434777608533.jpg?0.8399277638861771\" align=\"right\" border=\"1\"\nheight=\"150\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a>Every six months or so somebody proposes a new system where\npeople can leave messages in cyberspace that are tagged to specific places or co-ordinates. It always sounds enticing\nat first, like you could walk past a restaurant and see all the messages left by people who have eaten there before,\nletting you know whether it&#8217;s worth eating there or not. Two words for you: Third Voice. This was a dot com-era browser\n&#8220;enhancement&#8221; that let you view messages that other people had left when you visited a web page. The idea was to open\nthings up to &#8220;interactivity&#8221; and let people share their thoughts and comments about sites, but you can guess what\nhappened&#8212;like any unmoderated bulletin board on the Internet, the system was overrun with spam and flame wars. What\nSiemens is proposing is a system of &#8220;electronic post-its&#8221; for cellphone users, basically a way for someone to leave an\nSMS text message that is tagged to a specific place and is only transmitted when someone walks through that location.\nSiemens claims this won&#8217;t be a problem because there &#8220;will be ways to accept and reject messages,&#8221; but if the system\nisn&#8217;t closed or restricted in some way it&#8217;s just going to be a brand new way to annoy us.</p>\n<br />\n\n\n',NULL,'','http://www.engadget.com/entry/1234000773030173/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (139,3,'http://www.engadget.com/entry/1234000563030744/','HOW-TO: Turn your Mac mini into a low-cost recording studio','<p><img alt=\"Mac mini\" src=\"http://www.weblogsinc.com/common/images/6718362169426705.jpg?0.11490780309150272\"\nalign=\"right\" border=\"0\" height=\"125\" hspace=\"4\" vspace=\"4\" width=\"200\" />So we know that everybody, their sister and\ntheir cousin, too are working on how to use the Mac mini in a home theater setup (we are\n<a href=\"http://features.engadget.com/entry/1234000057028826/\">not immune</a>!). But better yet - one thing you can\njust never teach your TiVo is how to be a music production station. Gone are the days of needing hundreds of thousands\nof dollars to set up a studio to produce your own tracks; a decent digital audio workstation can now be set up for\ncomparatively ridiculously low cost.<br />\n\n<br />\n\n Today we&#8217;ll talk about yet another of the many tasks you could devote your Mac mini to: the home recording studio.\nWould-be bedroom producers gather &#8216;round and we&#8217;ll talk about some of the essentials you&#8217;ll need, plus how to get\nstarted recording and mixing tracks.</p>\n\n\n<br />\n\n \n\n<p><img alt=\"Mac mini home studio\"\nsrc=\"http://www.weblogsinc.com/common/images/1523176874241518.JPG?0.27456325771065426\" border=\"1\" height=\"315\"\nhspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n Keep in mind that, much like the <a href=\"http://features.engadget.com/entry/1234000057028826/\">Mac mini media center\nhow-to</a>, there is more than one way to skin a mini. You don&#8217;t have to duplicate our setup. You can pick and choose\namong some of the components we cover here, or search for others that fit your particular needs. What gear you\nultimately decide on depends on a number of factors, not the least of which is how much you can afford to spend: what\nstyle of music you primarily make, how many instrumentalists you need to record (if any), the size of your room, and so\nforth. This article is here to help get you started!<br />\n\n<br />\n\n <strong>The essentials: your basic gear list</strong></p>\n\n\n<ul>\n  <li>Audio recording software</li>\n\n  <li>Audio interface</li>\n\n  <li>Microphone(s)</li>\n\n  <li>Instruments</li>\n\n  <li>Cables</li>\n\n  <li>Monitoring device</li>\n\n  <li style=\"list-style-type: none; list-style-image: none; list-style-position: outside;\"><br />\n</li>\n</ul>\n<strong>The essentials explained</strong> <br />\n\n <br />\n\n <em>1. Audio recording software</em><br />\n\n \n\n<p>We&#8217;re going to go with the obvious and free choice, here:\n<a href=\"http://www.apple.com/ilife/garageband/\">GarageBand</a>, which comes with the iLife &#8216;05 suite on the mini.\nVersion 2 supports multi-tracking up to eight tracks, which should be enough to get you started recording. We&#8217;ll talk\nlater about other options in this department, for when you&#8217;re ready for the next level.<br />\n\n<br />\n\n <em>2. The audio interface</em><br />\n\n This is the very heart of your home studio. It is the piece of kit you should spend the most time thinking about and\nresearching, and for small setups is most likely what you&#8217;ll shell out the most dough for. Your options here run the\ngamut from el-cheapo to DAWs so bling we&#8217;d have to post them on <a href=\"http://www.luxist.com\">Luxist</a> before we\ncould even link to them.<br />\n\n<br />\n\n The most basic route here would be a simple line-in interface like the $40\n<a href=\"http://www.griffintechnology.com/products/imic/\">iMic</a> from Griffin. If you will only ever need to record\none audio source at a time - one person speaking for a Podcast, or converting your old records to MP3s, e.g. - this\ncould very well be all you need. It plugs into a USB port on your mini and acts as a breakout cable allowing you to\nplug-in a mic (1/8&#8221; jack provided) or a line-in (RCA jacks provided). It has a line out as well, so if you have an\nall-in-one headphone/mic headset, you can use it to record speech or vocals and listen back. If you really just want to\nplay around with GarageBand, and you&#8217;re looking for dirt cheap, this is it.<br />\n\n <img alt=\"Altivec Lansing headset with Griffin iMic\"\nsrc=\"http://www.weblogsinc.com/common/images/4618485415104705.JPG?0.5965992999112512\" align=\"top\" border=\"1\"\nheight=\"188\" hspace=\"4\" vspace=\"4\" width=\"250\" /><br />\n\n The quality won&#8217;t be all that and a bucket of chicken, but it won&#8217;t be absolutely terrible, either. It&#8217;ll be enough to\nhave fun with.<br />\n\n<br />\n\n Or, if you&#8217;re a DJ and just want to record the output from your turntables, this solution is not a bad option for a\nlow-cost practice studio. You already have a mixer, so you can mix in a vocal track or other line-in source like a CD\nplayer or MP3 player, as well. Just take the output from your mixer:<br />\n\n <img alt=\"Back of DJ mixer\" src=\"http://www.weblogsinc.com/common/images/7550113790156434.JPG?0.1196807810452275\"\nalign=\"top\" border=\"1\" height=\"226\" hspace=\"4\" vspace=\"4\" width=\"300\" /><br />\n\n<br />\n\n And direct it to the iMic using an RCA-RCA cable:<br />\n\n <img alt=\"Turntables to Griffin iMic\"\nsrc=\"http://www.weblogsinc.com/common/images/2645318217685165.JPG?0.06918021010937125\" align=\"top\" border=\"1\"\nheight=\"153\" hspace=\"4\" vspace=\"4\" width=\"300\" /><br />\n\n<br />\n\n ...and you have a $40 DAW. You can record a mix into a GarageBand stereo track and export it straight into iTunes in a\ntime-saving jiffy.<br />\n\n<br />\n\n If you&#8217;re going to be doing any audio production that involves recording analog instruments (guitar, bass, etc.), or\nthat requires multiple tracks, though, you need to look at a multi-channel USB or Firewire audio interface. There are\nmany, many options here and again, what you get will be determined by what your needs are and what style of music\nyou&#8217;re making. If you need to track a full band, look at a Firewire interface such as the\n<a href=\"http://www.motu.com/products/motuaudio/828/body.html/en\">MOTU 828</a> or the\n<a href=\"http://www.presonus.com/firepod.html\">Presonus Firepod</a>. If you only need a handful of ins and outs, look\nat something with a smaller footprint like the <a href=\"http://www.presonus.com/firebox.html\">Presonus Firebox</a>,\n<a href=\"http://www.m-audio.com/products/en_us/FireWire410-main.html\">M-Audio Firewire 410</a>, or the\n<a href=\"http://www.edirol.com/products/info/fa66.html\">Edirol FA-66</a>.<br />\n\n<br />\n\n We have the <a href=\"http://www.m-audio.com/products/en_us/MAudioOzone-main.html\">M-Audio Ozone</a> USB audio\ninterface in our studio, because it combines two audio inputs (one microphone, one line in; or, a single stereo line\nin) with a MIDI keyboard and 8 programmable MIDI knobs in one unit at a decent price (you should be able to find one\nfor $250 or less). You may not need a MIDI controller in your setup; if you&#8217;re only recording live instrumentalists and\nvocalists, you likely won&#8217;t. But if you make electronic music or if you want to trigger software instruments in your\nrecording software at any point, you&#8217;re going to want a MIDI keyboard of some sort. You can get a separate audio\ninterface and MIDI keyboard; especially if you&#8217;re a Rick Wakeman-type, you&#8217;ll feel limited by the two octave Ozone (you\nhave access to the full note range via octave up/down keys, but we know, Rick, it&#8217;s just not the same.). But it&#8217;s the\nperfect all-in-one device for us, and travel-size to boot.<br />\n\n <img alt=\"M-Audio Ozone\" src=\"http://www.weblogsinc.com/common/images/1646543765464176.JPG?0.0030055937526025645\"\nalign=\"top\" border=\"1\" height=\"195\" hspace=\"4\" vspace=\"4\" width=\"300\" /><br />\n\n<br />\n\n <em>3. Microphone</em><br />\n\n If you&#8217;re doing serious multi-tracking, you&#8217;ll need a selection of mics suited to the ranges of the instruments you&#8217;re\nrecording. If you just want a decent and versatile mic or several that can serve general purpose duty, we recommend the\nold industry standby <a href=\"http://mixonline.com/TEC20/tec20-shure-sm57/\">Shure SM57</a>. It will do admirably for\nvocals as well as various instruments, and you can pick one up for less than $100.<br />\n\n <img alt=\"Shure SM57\" src=\"http://www.weblogsinc.com/common/images/5608372272658148.JPG?0.07119877634006488\"\nalign=\"top\" border=\"1\" height=\"244\" hspace=\"4\" vspace=\"4\" width=\"200\" /><br />\n\n<br />\n\n<br />\n\n <em>4. Cables</em><br />\n\n Your microphone will connect to your audio interface via an XLR cable:<br />\n\n <img alt=\"XLR cable\" src=\"http://www.weblogsinc.com/common/images/4587261160537927.JPG?0.05054006134796596\"\nalign=\"top\" border=\"1\" height=\"188\" hspace=\"4\" vspace=\"4\" width=\"250\" />&nbsp;<br />\n\n<br />\n\n Instruments plug into a 1/4&#8221; line in jack via a regular instrument cable:<br />\n\n <img alt=\"Instrument cable\" src=\"http://www.weblogsinc.com/common/images/2237124146845557.JPG?0.07474070162891422\"\nalign=\"top\" border=\"1\" height=\"188\" hspace=\"4\" vspace=\"4\" width=\"250\" />&nbsp;<br />\n\n<br />\n\n If you have a separate audio interface and MIDI keyboard or other MIDI controller, you will wed the twain together via\nye olde MIDI cable:<br />\n\n <img alt=\"MIDI cable\" src=\"http://www.weblogsinc.com/common/images/2241571936969014.JPG?0.1768426456709825\"\nalign=\"top\" border=\"1\" height=\"188\" hspace=\"4\" vspace=\"4\" width=\"250\" /><br />\n\n<br />\n\n <em>5. Monitoring device</em><br />\n\n You will need something with which to listen to your next big hit. If you have a set of PC speakers lying around, this\nis the cheapest route. You can also connect your mini to your stereo via either the internal audio out or your audio\ninterface&#8217;s audio out. The pros and semi-pros use <a href=\"http://www.homerecording.com/monitors.html\">near field\nmonitors</a>. Regardless of what external sound system you choose, it is a good idea to have a decent pair of studio\nheadphones in your arsenal. We recommend the <a href=\"http://www.audioreview.com/PRD_118049_2750crx.aspx\">Sony\nMDR-7506</a>s, which can be had for less than $100.<br />\n\n <img alt=\"Sony MDR-7506 headphones\"\nsrc=\"http://www.weblogsinc.com/common/images/5844275640773728.JPG?0.6471768781477013\" align=\"top\" border=\"1\"\nheight=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><br />\n\n<br />\n\n <em>6. Instruments</em><br />\n\n Many choices here in both analog and digital realms. If you&#8217;re already an instrumentalist, you&#8217;ll probably start\nrecording yourself playing guitar, etc. If you&#8217;re not an instrumentalist, hunker down and get to know your new\ninstrument: the MIDI keyboard. Remember that your number one goal in music-making is always fun, and whether or not it\never gets you on tour with Peter Gabriel is purely incidental. Don&#8217;t be afraid to make mistakes.<br />\n\n<br />\n\n If you&#8217;re itching to get into the hottest thing in digital recording, loop-based music production, then you have a\nwhole world of software instruments and sample loops open before you. Garageband comes with a number of standard preset\ninstruments as well as loops for you to start exploring, plus you can make your own loops for use in your\nprojects.<br />\n\n<br />\n\n Sooner or later if you upgrade to an audio sequencer such as the most righteous\n<a href=\"http://www.ableton.com/\">Ableton Live</a>, you can use all manner of third-party loops found free or as\nbuyware. If you&#8217;re the tweaker type, you can also take advantage of some other excellent freeware sound generation\nsoftware on the Mac to create some unique soundscapes you&#8217;re guaranteed won&#8217;t turn up on the next BT record:\n<a href=\"http://www.u-he.com/zoyd/\">Rumblence: zoyd</a> and\n<a href=\"http://www.csounds.com/whatis/index.html\">Csound</a>, to name a couple.<br />\n\n<br />\n\n You may also at some point get interested in outboard gear such as external drum machines or synthesizers that contain\na number of editable sounds you can trigger with your MIDI keyboard. All in good time, my friends. For now, let&#8217;s just\nfire up GarageBand and lay some tracks, shall we?</p>\n<br />\n\n <strong>System set-up</strong> <br />\n\n <br />\n\n \n\n<p>You&#8217;ll have to install drivers for your audio interface, if you haven&#8217;t already. Next, connect your cables to your\naudio interface, then connect your interface to your computer. If your interface is USB, hot-swapping applies so you\ncan just plug it in when the machine is already on. For Firewire interfaces, it&#8217;s usually best for everyone involved to\nshut down the machine, connect the Firewire cable, power on, and party on. We&#8217;re hooking in one instrument and one mic,\nand our headphones to the headphone out jack:<br />\n\n <img alt=\"Ozone back\" src=\"http://www.weblogsinc.com/common/images/8266385538540374.JPG?0.8728821637044427\"\nalign=\"top\" border=\"1\" height=\"263\" hspace=\"4\" vspace=\"4\" width=\"350\" /><br />\n\n<br />\n\n The other cables go into the Mac mini as they usually do, with the addition of the USB cable for the M-Audio\nOzone:<br />\n\n <img alt=\"Mac mini back\" src=\"http://www.weblogsinc.com/common/images/3733164641785841.JPG?0.0711112247251452\"\nalign=\"top\" border=\"1\" height=\"263\" hspace=\"4\" vspace=\"4\" width=\"350\" /><br />\n\n<br />\n\n Next, fire up our new friend, Garageband. You&#8217;ll be prompted for a name and location for your project file. Once the\napp is open, we&#8217;ll first need to set the audio preferences to use your interface for handling audio in/out duties, so\ngo to the File menu and select Preferences. Select the Audio/MIDI tab, and select your interface as both the audio in\nand out source, unless you&#8217;re using your stereo or other speakers to play back sound from your Mac. If you&#8217;re listening\nthrough headphones, there is a surely a headphone out jack on your interface in which case you&#8217;ll want it to be\nselected for audio out duties.<br />\n\n<br />\n\n <img alt=\"Garageband preferences\"\nsrc=\"http://www.weblogsinc.com/common/images/5225667244488655.JPG?0.13754160844859087\" align=\"top\" border=\"1\"\nheight=\"273\" hspace=\"4\" vspace=\"4\" width=\"350\" /><br />\n\n<br />\n\n We&#8217;re ready to unleash some aural mayhem, so let&#8217;s create a new track. Press apple-option-n to start a new track (or\nuse the New Track command from the Track menu) and you&#8217;ll see we have a choice between real and software instruments.\nLet&#8217;s start with a simple vocal track, a real instrument:<br />\n\n<br />\n\n <img alt=\"Garageband new track\" src=\"http://www.weblogsinc.com/common/images/7932728748437138.JPG?0.09624244965922713\"\nalign=\"top\" border=\"1\" height=\"302\" hspace=\"4\" vspace=\"4\" width=\"350\" />&nbsp;<br />\n\n<br />\n\n If you turn monitoring on, you&#8217;ll be able to hear yourself played back through your headphones or speakers as you\nrecord. There will be a slight delay between what you&#8217;re saying/singing and what comes back to you, though, so if that\nbothers you, leave monitoring off.<br />\n\n<br />\n\n The pane on the right are the possible effects you can add to your track. Many of the settings of these effects are\ntweakable, so you can take the default settings and modify them to create new sounds. We&#8217;ll choose the Deeper Vocals\nplug-in to record our first voice track and click the Create button, which generates a new track in the timeline\nbrowser:<br />\n\n<br />\n\n <img alt=\"deeper vox\" src=\"http://www.weblogsinc.com/common/images/2758766008820633.JPG?0.5437223586709421\"\nalign=\"top\" border=\"1\" height=\"99\" hspace=\"4\" vspace=\"4\" width=\"317\" /><br />\n\n<br />\n\n Before we start recording, let&#8217;s check our levels. Keep an eye on the level meters at the far right of the control\nstrip:<br />\n\n<br />\n\n <img alt=\"audio level meters\" src=\"http://www.weblogsinc.com/common/images/3115567355611989.JPG?0.4820694079493556\"\nalign=\"top\" border=\"1\" height=\"68\" hspace=\"4\" vspace=\"4\" width=\"173\" /><br />\n\n<br />\n\n Start adjusting the gain control for the mic channel on your audio interface. There should be a gain (volume) section\nthat will set the recording levels for all of your channels:<br />\n\n<br />\n\n <img alt=\"M-Audio Ozone gain control\"\nsrc=\"http://www.weblogsinc.com/common/images/3004556244500767.JPG?0.37471561175988677\" align=\"top\" border=\"1\"\nheight=\"244\" hspace=\"4\" vspace=\"4\" width=\"325\" /><br />\n\n<br />\n\n You want the signal to be as far into the green as possible without spilling over into the red and clipping, which can\ncause nasty pops, cracks and other digital artifacts into your pristine audio. You want the signal to be strong, but\nnot too hot. Once you&#8217;ve got a good level, you can hit the red record button on the transport control to start\nrecording your vocals:<br />\n\n<br />\n\n <img alt=\"Garageband transport control\"\nsrc=\"http://www.weblogsinc.com/common/images/6292077107686388.JPG?0.8472149678593517\" align=\"top\" border=\"1\"\nheight=\"68\" hspace=\"4\" vspace=\"4\" width=\"237\" />&nbsp;<br />\n\n<br />\n\n After you&#8217;ve recorded your audio, your track will show the waveform of the audio you just generated:<br />\n\n<br />\n\n <img alt=\"recorded track\" src=\"http://www.weblogsinc.com/common/images/2871101566609644.JPG?0.089213573965369\"\nalign=\"top\" border=\"1\" height=\"60\" hspace=\"4\" vspace=\"4\" width=\"420\" />&nbsp;<br />\n\n<br />\n\n If you&#8217;ve chosen the Deeper Vocals effect, you&#8217;ll notice that Darth Vader has got nothing on you in this track. Have\nfun playing around with the different effects to see what kind of sounds you can come up with:</p>\n<br />\n\n \n\n<ul>\n  <li><a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/vox_deep.mp3\">too deep for comfort</a></li>\n\n  <li><a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/vox_helium.mp3\">stop huffing that whipped cream,\n  kid</a></li>\n\n  <li><a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/vox_gollum.mp3\">gollum</a></li>\n</ul>\n<br />\n\n \n\n<p>Of course, with a microphone you&#8217;re not limited to just your voice. You can record any ambient sound and add effects\nto it to alter its character into something that might be useful in a track. For example, we made some\n<a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/generated_sound.mp3\">industrial noise</a> by recording a\nspoon hitting a bowl with heavy effects. Use your imagination and experiment.<br />\n\n<br />\n\n Let&#8217;s create another new track, but this time we will select a software instrument such as a piano or synth. This\ntime, instead of recording from an external sound generator such as your voice, we are going to use the MIDI keyboard\nto play a software-based instrument. Once you&#8217;ve added the new track to your project, start tinkling on the keys and\nyou should hear the sound output from the instrument. Recording from here is just as simple as hitting ye olde record\nbutton again and ripping up those keys.<br />\n\n<br />\n\n Garageband has some decent stock sounds out of the box, and as always you can further tweak them by adding and\nmanipulating effects. In general, the sounds that attempt to be representations of real instruments like\n<a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/soft_flute.mp3\">woodwinds</a> and brass will not sound as\ngood as the more <a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/soft_synth.mp3\">synth and electronic\nsounds</a> that we want to sound a bit artificial anyway. You won&#8217;t be producing your next symphony out of Garageband,\nbut you may very well use it as a composition tool to sketch ideas.<br />\n\n<br />\n\n Recording your external instruments into Garageband works exactly the same way as recording vocals, from above: start\na new track, choose what type of instrument you are bringing in, set your levels and go to town. Add effects at will,\ntweak to your heart&#8217;s content, and experiment away. You can record two tracks of the same instrument for melody and\nharmony, or you can record multiple tracks simultaneously if your audio interface has more than one audio input. We&#8217;ll\nleave all of that up to you to play with, and we&#8217;ll move on to the fun of loop-based music production.<br />\n\n<br />\n\n Hit apple-L (or Control &gt; Show Loop Browser) to open the loop browser, which appears at the bottom of the\nwindow:<br />\n\n<br />\n\n <img alt=\"loop browser\" src=\"http://www.weblogsinc.com/common/images/6324433777708633.JPG?0.12677052557946722\"\nalign=\"top\" border=\"1\" height=\"260\" hspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n<br />\n\n From here you can choose from a number of Apple Loops included with Garageband. Just browse around until you find one\nyou like, and then drag it into a spot on the timeline:<br />\n\n<br />\n\n <img alt=\"mini studio 465457\" src=\"http://www.weblogsinc.com/common/images/7706026470413347.JPG?0.8913387291965412\"\nalign=\"top\" border=\"1\" height=\"259\" hspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n<br />\n\n If you&#8217;ve dragged it into an existing track, the audio loop will be placed at the spot in the timeline where you\ndropped it. If you dropped it into an empty space in the timeline, a new track will be created and the audio placed\nthere. You&#8217;ll see the waveform displayed:<br />\n\n<br />\n\n <img alt=\"mini studio\" src=\"http://www.weblogsinc.com/common/images/2015670689167657.JPG?0.4749761895264709\"\nalign=\"top\" border=\"1\" height=\"104\" hspace=\"4\" vspace=\"4\" width=\"340\" /><br />\n\n<br />\n\n We want this percussion loop to keep looping, not just play through once and stop. So move your mouse to the upper\nright hand corner of the waveform and it will turn into a circle-ish &#8220;extend&#8221; icon; if you click and drag to the right,\nyou will increase the length of the loop:<br />\n\n<br />\n\n <img alt=\"mini studio 2\" src=\"http://www.weblogsinc.com/common/images/1915792823623325.JPG?0.39163672017871576\"\nalign=\"top\" border=\"1\" height=\"54\" hspace=\"4\" vspace=\"4\" width=\"340\" /><br />\n\n<br />\n\n Now, find some other clips that go with your first clip and layer a few instrument tracks on top of each other:<br />\n\n<br />\n\n <img alt=\"mini studio 3\" src=\"http://www.weblogsinc.com/common/images/5181976986575276.JPG?0.4192111459763034\"\nalign=\"top\" border=\"1\" height=\"147\" hspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n<br />\n\n Now you can start to mix your tracks, which essentially means getting all of the sounds to blend together in a way\nthat sounds fairly natural. You&#8217;ll want to adjust the volume of certain tracks relative to others. To do this, click on\nthe triangle in the track info pane to expand the volume control:<br />\n\n<br />\n\n <img alt=\"mini studio 4\" src=\"http://www.weblogsinc.com/common/images/3341460724746660.JPG?0.0008373999920233688\"\nalign=\"top\" border=\"1\" height=\"71\" hspace=\"4\" vspace=\"4\" width=\"318\" /><br />\n\n<br />\n\n You&#8217;ll see a linear representation of the track volume displayed beneath the track waveform. To adjust the volume you\ncreate edit points by clicking on the volume line at the points where you wish to make volume changes:<br />\n\n<br />\n\n <img alt=\"mini studio 5\" src=\"http://www.weblogsinc.com/common/images/3341459613624458.JPG?0.5298099225785455\"\nalign=\"top\" border=\"1\" height=\"59\" hspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n<br />\n\n Once you&#8217;ve made your edit markers, you can click and drag them to raise or lower the volume of the track and create\neffects like fade ins:<br />\n\n<br />\n\n <img alt=\"mini studio 6\" src=\"http://www.weblogsinc.com/common/images/0658878232255299.JPG?0.6309033452930093\"\nalign=\"top\" border=\"1\" height=\"81\" hspace=\"4\" vspace=\"4\" width=\"400\" /><br />\n\n<br />\n\n If you want to make changes to the overall volume of the whole project itself, not just a single track, you&#8217;ll have to\nshow the &#8220;master track&#8221; which controls all the other tracks&#8217; volume levels. Hit apple-B (or Track &gt; Show Master\nTrack) to display the master track at the bottom of the window. If you edit volume data on this track, it will be\nreflected across all of the tracks. Thus, if you want to fade out at the end of your track, you would edit the master\ntrack. Here&#8217;s the final view of our quick mini-project after some other mix tweaks such as adjusting the track panning,\nwhich refers to where the sound is located in the stereo field, i.e. how far to the left or right does the sound source\nsound as if it were coming from.<br />\n\n<br />\n\n <img alt=\"mini studio 7\" src=\"http://www.weblogsinc.com/common/images/3509506738548252.JPG?0.5284959771403205\"\nalign=\"top\" border=\"1\" height=\"197\" hspace=\"4\" vspace=\"4\" width=\"420\" /><br />\n\n<br />\n\n Here&#8217;s the <a href=\"http://media.weblogsinc.com/common/videos/Mac/studio/sample_loop_track_mixfx.mp3\">result</a> of\nour all of about 10 minutes of tinkering, testament to how dead easy this program is to use and just a little sampling\nof the kinds of things you can do with Garageband. Good luck, and happy music making! Post some links to your tracks!\n:)</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000563030744/','2005-02-09 09:51:48'),
 (140,3,'http://www.engadget.com/entry/1234000473030802/','View that cancer with glowing nanoparticles','<a href=\"http://www.betterhumans.com/News/news.aspx?articleID=2005-02-07-7\"><img alt=\"Tumor nanoparticles\"\nsrc=\"http://www.weblogsinc.com/common/images/2994567456733212.JPG?0.3570671771306625\" align=\"right\" border=\"1\"\nheight=\"150\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a> \n\n<p>We can only imagine the medical benefits of easily scoping out that troubled cancer-ridden zone, so we&#8217;re sure more\nthan a few oncologists are doing victory dances at the U Penn&#8217;s and U Minnesota&#8217;s invention of an imaging system that\nuses fluorescent fluorophores inserted into a cell-like nanoparticle delivery system, which can be used to easily image\ntissue subcutaneously (see right). Which means doctors can more easily see what&#8217;s going on with the cancer in question,\nwhich means chemotherapy could be administered more effectively, which means lives can be saved (and we get the added\nbenefit of giving off near-infrared light when exposed to it). Let&#8217;s just hope the nanoparticles don&#8217;t also give you\ncancer.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000473030802/','2005-02-09 09:51:48');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (141,3,'http://www.engadget.com/entry/1234000680030800/','The Brazilian WheelSurf','<a href=\"http://www.wheelsurf.com.br/model.html\"><img height=\"200\" alt=\"WheelSurf\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/5337902790267546.JPG?0.8065112622105546\" width=\"187\" align=\"right\"\nvspace=\"16\" border=\"1\" /></a> \n\n<p>It&#8217;s kind of like the <a href=\"http://www.engadget.com/entry/2138247481302225/\">Scabber</a> or the\n<a href=\"http://www.engadget.com/entry/4722841284116041/\">BushPig</a> (remember those? We know, they were oh, so long\nago), except instead of sticking your foot in, you stick your body in. Yes, it looks fun, yes, we&#8217;d try cruising around\nthe block in one, and finally, yes, it was only a matter of time before the monocycle got tricked out and made into a\nviable, commercially distributed vehicle. But that doesn&#8217;t mean we&#8217;re going to encourage extreme one-wheeled vehicling\naround town, at least not unless it&#8217;s a Bombardier Embrio. Ah, what the hell.<br />\n\n<br />\n\n[Via <a href=\"http://www.gadgetryblog.com/gadgetryblog/2005/02/wheelsurf_a_rep.html\">GadgetryBlog</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000680030800/','2005-02-09 09:51:48'),
 (142,3,'http://www.engadget.com/entry/1234000800030786/','The USB humidifier--part deux','<a href=\"http://akiba.sorobangeeks.net/news_9169.html\"><img alt=\"USB humidifier 2.0\"\nsrc=\"http://www.weblogsinc.com/common/images/8312187097575165.JPG?0.020964257718618762\" align=\"right\" border=\"1\"\nheight=\"200\" hspace=\"4\" vspace=\"16\" width=\"156\" /></a> \n\n<p>What, do you think that with our boundless obsession for\n<a href=\"http://www.engadget.com/search/?q=usb%20power\">USB-powered Japanese novelties</a> we would actually go to the\ntrouble of having a translator contact the manufacturer of the\n<a href=\"http://www.engadget.com/entry/1234000340021613/\">USB air humidifier</a> asking for another revision? And so\nwhat if we did? The difference? Glad you asked; the new version produces more steam, and more steam (apparently) means\nmore negative ions, which is better for in-room air quality. We&#8217;ll take 300 please.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000800030786/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (143,3,'http://www.engadget.com/entry/1234000697030795/','Rumblings by movers and shakers in the flat-panel TV biz','<a href=\"http://www.nytimes.com/2005/02/08/technology/08flat.html?ex=1265605200&amp;en=5c88f53dc0ed1ea2&amp;ei=5088&amp;partner=rssnyt\">\n<img alt=\"Panasonic 65-inch plasma TV\"\nsrc=\"http://www.weblogsinc.com/common/images/9816814256067771.jpg?0.3664956740642116\" align=\"right\" border=\"1\"\nheight=\"140\" hspace=\"4\" vspace=\"16\" width=\"230\" /></a> \n\n<p>In the past few days there has been precisely one buyout and one partnership between four major flat-panel players\ncompeting in a market where there&#8217;s been a lot of motion as of late due to huge worldwide demand, rapidly decreasing\nmargins, and product shortages. <a href=\"http://www.engadget.com/search/?q=Fujitsu\">Fujitsu</a>, one of the biggest\nflat-panel manufacturers around, announced the sale of their LCD display division to\n<a href=\"http://www.engadget.com/search/?q=Sharp\">Sharp</a>, while\n<a href=\"http://www.engadget.com/search/?q=Hitachi\">Hitachi</a> and Matsushita (who you know as\n<a href=\"http://www.engadget.com/search/?q=Panasonic\">Panasonic</a>) would join together in sharing technology and\nfacilities in the plasma market. The overseas business angle may not seem too intense for us Stateside, but with\nFujitsu dropping out it&#8217;s clear that the flat-panel business is getting crazy competitive, and the winners are going to\nbe the companies who can streamline like crazy, cut costs, increase quality, and crank out those units like nobody&#8217;s\nbiz.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000697030795/','2005-02-09 09:51:49'),
 (144,3,'http://www.engadget.com/entry/1234000507030793/','TiVo releases annual Super Bowl viewer stats','<a href=\"http://www.tivo.com/0.9.0.sb.asp\"></a><a href=\"http://www.tivo.com/0.9.0.sb.asp\"><img height=\"206\"\nalt=\"TiVo Super Bowl graph\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/0916803034735447.JPG?0.7736750398281285\" width=\"425\" align=\"top\"\nvspace=\"4\" border=\"0\" /></a><br />\n\n\n<p>Remember last year when <a href=\"http://www.engadget.com/search/?q=tivo\">TiVo</a> really made it well known how they\nwere collecting aggregate usage statistics, and that Janet Jackson&#8217;s &#8220;costume malfunction&#8221; was the most\ninstant-replayed moment in TiVo history? Well, this year&#8217;s TiVo\n<a href=\"http://www.engadget.com/search/?q=super+bowl&amp;submit=Go\">Super Bowl</a> stats are out, and you&#8217;ll be\ninterested to know that the three most watched and replayed moments were the GoDaddy.com commercial (no surprise there,\nyou pervs), MVP-voting instructions, and that interception in the 4th quarter. The low point (pre-game excepted) seemed\nto be after Paul McCartney finished Hey Jude (seriously, nothing can top Hey Jude, so we understand why everyone moved\non).</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000507030793/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (145,3,'http://www.engadget.com/entry/1234000163030799/','Panasonic\'s latest digicams: The Lumix DMC-FZ5, DMC-FZ4, DMC-LZ2, DMC-LZ1, and DMC-LS1','<p>Not to be out done by the likes of\n<a href=\"http://digitalcameras.engadget.com/entry/1234000650030747/\">FujiFilm</a>, Panasonic also announced a bunch of\nnew cameras today:<br />\n\n<br />\n\n<img alt=\"Panasonic Lumix DMC-FZ5\"\nsrc=\"http://www.weblogsinc.com/common/images/8131594382658026.JPG?0.33322239262607123\" align=\"top\" border=\"1\"\nheight=\"137\" hspace=\"4\" vspace=\"4\" width=\"425\" /><br />\n\nThe five megapixel DMC-FZ5 and four megapixel DMC-FZ4 &#8212; These are the latest additions to their line of prosumer FZ\ncameras. Each sports a 12x optical zoom lens (made by Leica, no less), though only the FZ5 (which is pictured above)\ngets its LCD bumped up to 1.8-inches.<br />\n\n<br />\n\n<strong><a href=\"http://www.dpreview.com/news/0502/05020807panasonicfz4fz5.asp\">Read - DMC-FZ5 and DMC-FZ4</a><br />\n\n<br />\n\n<br />\n</strong><img alt=\"Panasonic Lumix DMC-LZ2\"\nsrc=\"http://www.weblogsinc.com/common/images/7437767333476423.JPG?0.34510964573489855\" align=\"top\" border=\"1\"\nheight=\"141\" hspace=\"4\" vspace=\"4\" width=\"425\" /><br />\n\nThe five megapixel DMC-LZ2 (pictured above) and four megapixel DMC-LZ1 &#8212; Two new compact cameras, each of which has a\n6x optical zoom lens, a 2-inch LCD screen, and Panasonic&#8217;s Mega O.I.S. optical image stabilizer technology. They&#8217;re\nalso making a lot of noise about how rare it is to have a 6x optical zoom lens on a camera of this size, which is sorta\ntrue. Runs on two AA batteries.<br />\n\n<br />\n\n<strong><a href=\"http://www.dpreview.com/news/0502/05020806panasoniclz1lz2.asp\">Read - DMC-LZ1 and DMC-LZ2</a></strong><br />\n\n<br />\n\n<br />\n\n<img alt=\"Panasonic DMC-LS1\" src=\"http://www.weblogsinc.com/common/images/3464716493647815.JPG?0.9463575979627886\"\nalign=\"top\" border=\"1\" height=\"330\" hspace=\"4\" vspace=\"4\" width=\"425\" /><br />\n\nThe four megapixel DMC-LS1 &#8212; An entry-level digital camera that has a 3x optical zoom lens, a 2-inch LCD, and\nPanasonic&#8217;s Mega O.I.S. optical image stabilizer technology. Runs on two AA batteries.<br />\n\n<br />\n\n<strong><a href=\"http://www.dpreview.com/news/0502/05020805panasonicls1.asp\">Read - DMC-LS1</a></strong></p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000163030799/','2005-02-09 09:51:49'),
 (146,3,'http://www.engadget.com/entry/1234000050030792/','palmOne patents handheld with flexible dual-sided display','<a href=\"http://palmaddict.typepad.com/palmaddicts/2005/02/possible_new_pa.html\"><img height=\"244\"\nalt=\"palmOne foldable dual-sided display\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/4463683158281236.JPG?0.9857868957317818\" width=\"210\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>They originally filed for this over four years (when they were still called Palm), but palmOne was just granted a\npatent for a &#8220;compact personal digital assistant (PDA) and cellular telephone&#8221; with a flexible dual-sided display that\nfolds up when you want to use it as a phone and unfurls in all its glory when you need a little more screen real estate\nfor working. So does that mean there&#8217;s a Treo with one of these in our future? Not necessarily; companies file patents\nall the time for products that, for one reason or another, they never end up pursuing (though are always happy to sue\nover). And given palmOne&#8217;s rather, uh, sluggish pace of innovation lately, even if they are working on something like\nthis it&#8217;d probably still be a few more years before it&#8217;d ever see the light of day.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000050030792/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (147,3,'http://www.engadget.com/entry/1234000630030787/','Burger King goes retro with Activision games','<img height=\"143\" alt=\"Kaboom\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/5956419196452720.JPG?0.7598777236503107\" width=\"175\" align=\"right\"\nvspace=\"16\" border=\"1\" /> \n\n<p>Burger King is kicking it retro-style, giving away four different old school Activision games with their kids&#8217;\nmeals. We&#8217;re of course, totally jealous. When we were of kids&#8217; meal eating age we&#8217;d spend our whole allowance on\nsomething like this &#8212; and not even a real Activision game &#8212; no, we had to satisfy ourselves with a cheap\nknock-off.&nbsp; Anyway, if you want to vicariously re-live your youth with better toys (or, you know, get some for\nyour kids, who, let&#8217;s be honest, probably won&#8217;t appreciate these as much as you will), you can head down to Burger King\nand snap up a free handheld version of Kaboom!, Grand Prix, Barnstorming, or Tennis with every kids&#8217; meal.<br />\n\n<br />\n\n[Via <a href=\"http://www.joystiq.com/\"><span style=\"TEXT-DECORATION: underline\">Joystiq</span></a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000630030787/','2005-02-09 09:51:49'),
 (148,3,'http://www.engadget.com/entry/1234000680030782/','$99 puts a 1.5GB MP3 player in your pocket','<a href=\"http://www.amazon.com/exec/obidos/tg/detail/-/B0002UB0E8/104-8486116-1079911\"><img alt=\"PD-1000 Perception Digital MP3 player\"\n     src=\"http://www.weblogsinc.com/common/images/3240358592413346.jpg?0.3978963599611073\" align=\"right\" border=\"1\"\n     height=\"151\" hspace=\"4\" vspace=\"16\" width=\"130\" /></a> \n\n<p>The price-shrinking, margin-dropping, power-duo of Amazon/TigerDirect and commodity Chinese MP3 players have dredged\nup a deal for you <a href=\"http://www.engadget.com/search/?q=shuffle&amp;submit=Go\">iPod shuffle</a>\ndisenfranchised&#8212;the&#8217;re asking a Benny for the <a href=\"http://www.engadget.com/entry/7324322665476309/\">Perception\nDigital PD-1000</a>, a USB 2.0 mass-storage capable 1.5GB 1-inch drive player, with 13.5-hours playback. Sure, the 3.9\nx 1.7&nbsp; x 0.76-inch device may be twice as big as its Apple counterpart, but if you squint real hard it kind of\nlooks like&hellip; ah, forget it. You already know why you want it (or why you don&#8217;t).<br />\n\n<br />\n\n [Via <a href=\"http://www.dapreview.net/comment.php?comment.news.1036\">DAPreview</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000680030782/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (149,3,'http://www.engadget.com/entry/1234000243030781/','Xbox 2/Xbox 360 won\'t use either Blu-ray or HD DVD?','<a href=\"http://www.theinquirer.net/?article=21121\"><img alt=\"Xbox 360 logo\"\nsrc=\"http://www.weblogsinc.com/common/images/8312965764231629.jpg?0.08733949360122273\" align=\"right\" border=\"1\"\nheight=\"142\" hspace=\"4\" vspace=\"16\" width=\"225\" /></a>\n\n<p>People (you know who you are) have been gossiping for a while now that something like this was in the cards, but now\nthe Inq reports that there is a very good chance that Microsoft isn&#8217;t going to dance with either\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=blu-ray\">Blu-ray</a> or\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=hd+dvd\">HD DVD</a> and instead is going to put a\nregular DVD drive in the Xbox 2/<a href=\"http://www.engadget.com/entry/1234000760030410/\">Xbox 360</a> in order to keep\ncosts down (and get the console out on time). You can certainly make the argument that hardly any games would take full\nadvantage of the 25 or 50GB of space you&#8217;d get on a Blu-ray disc, but not shipping with a next-gen drive is only going\nto make it that much easier for Sony to erase the next Xbox&#8217;s headstart when they launch the PlayStation 3 (which will\n100% guaranteed have a Blu-ray drive) next year. <a href=\"http://www.engadget.com/entry/1234000760030410/\"></a></p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000243030781/','2005-02-09 09:51:49'),
 (150,3,'http://www.engadget.com/entry/1234000857030777/','Samsung\'s MT40 Media Center PC','<a href=\"http://akiba.sorobangeeks.net/news_9174.html\"><img alt=\"Samsunt MT40 Media Center PC\"\nsrc=\"http://www.weblogsinc.com/common/images/7280753541817275.JPG?0.5302688517713899\" align=\"top\" border=\"0\"\nheight=\"153\" hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n\n<p>It&#8217;s cruel enough that Samsung doesn&#8217;t sell their PCs here in the States (it was a total tease spotting their\n<a href=\"http://www.engadget.com/entry/3463693268303348/\">17-inch M40 and 15-inch X30</a> laptops at The Samsung\nExperience showroom a few months ago&#8212;when we whined about it, the salesperson told us to buy a PowerBook), but now\nthey&#8217;ve just introduced a slick new component-style Media Center PC that almost certainly won&#8217;t be coming out here\neither. Though actually when we peeped the specs on the MT40 we did manage to feel a little better. It does run the new\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=Windows+XP+Media+Center+Edition+2005\">Windows XP\nMedia Center Edition 2005</a> operating system, but otherwise its Pentium 4 530 processor, 512MB of RAM, and 160GB hard\ndrive are nothing special.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000857030777/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (151,3,'http://www.engadget.com/entry/1234000677030763/','Jablotron\'s GDP-02 unportable cellphone for the elderly','<p>\n  <img height=\"199\" alt=\"Jablotron GDP-02\" hspace=\"4\"\n  src=\"http://www.weblogsinc.com/common/images/4697251958325684.JPG?0.43607646118978793\" width=\"240\" align=\"right\"\n  vspace=\"16\" border=\"1\" />A Czech company named Jablotron announced their new cellphone on Monday.&nbsp; If it doesn&#8217;t\n  look like any other GSM handset you&#8217;ve ever seen, that&#8217;s because the GDP-02 &#8220;Grand&#8221; is really a desktop phone.&nbsp;\n  Designed for elderly users who have difficulty with smaller phones, the phone features an illuminated display and a\n  QWERTY keypad to allow users to send and receive text messages in addition to making calls. The catch is that since\n  it&#8217;s a desktop phone it&#8217;s more or less the opposite of portable, though for a lot of old people not being able to\n  bring their cellie to the mall might not be a problem. \n\n  <p>[Via <a href=\"http://www.textually.org/\">textually.org</a>]</p>\n\n</p>\n<br />\n\n\n',NULL,'','http://www.engadget.com/entry/1234000677030763/','2005-02-09 09:51:49'),
 (152,3,'http://www.engadget.com/entry/1234000573030738/','The PodBrix','<p style=\"text-align: center\">\n  <a href=\"http://podbrix.com/\"><img alt=\"PodBrix\"\n  src=\"http://www.weblogsinc.com/common/images/1646532654353955.JPG?0.904767397729881\" align=\"top\" border=\"0\"\n  height=\"321\" hspace=\"4\" vspace=\"4\" width=\"409\" /></a>\n</p>\n\n\n<p>This may officially mark the tipping point: an artist in Maryland has created the &#8220;1K Brix&#8221; PodBrix Minifig, a line\nof &#8220;limited-edition&#8221; modified Lego figures designed to look like they&#8217;re from one of those iPod silhouette ads.<br />\n\n<br />\n\n[Thanks, kwik]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000573030738/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (153,3,'http://www.engadget.com/entry/1234000793030739/','Cell processor announced, and now we play the waiting game','<a href=\"http://olympics.reuters.com/audi/newsArticle.jhtml?type=technologyNews&amp;storyID=7560310\"><img alt=\"Cell processor smaller\"\n     src=\"http://www.weblogsinc.com/common/images/6167529196441518.JPG?0.11006231649377984\" align=\"right\" border=\"1\"\n     height=\"228\" hspace=\"4\" vspace=\"16\" width=\"203\" /></a> \n\n<p>So with the <a href=\"http://www.engadget.com/entry/1234000287028644/\">Cell processor</a>\n<a href=\"http://www.engadget.com/entry/1234000763030645/\">announced today</a>, we thought we&#8217;d hit up a quick\npost-mortem of the details divulged at the ISSCC, but they really didn&#8217;t divulge much that hadn&#8217;t already been\n<a href=\"http://www.engadget.com/search/?q=cell%20processor\">rumored, speculated, or leaked</a> (so what else is new,\nright?).&nbsp; Yes, they&#8217;re calling it a &#8220;supercomputer&#8221; (never heard <em>that</em> pitch before), yes they&#8217;re saying\nit&#8217;ll be ten times faster than what&#8217;s currently out, and yes, the part is running at more than 4GHz. What we didn&#8217;t\nknow is that bus will be built around\n<a href=\"http://home.businesswire.com/portal/site/google/index.jsp?ndmViewId=news_view&amp;newsId=20050207005391&amp;newsLang=en\">\nRambus&#8217;s FlexIO</a> technology with XDR memory, which will supposedly scale between 3.2 GHz to 8.0 GHz&#8212;pretty big\nnumbers, but how much of this will turn out to be true and hype (and what it all means for real world performance) is\nyet to be seen. Stay tuned, as we can expect some interesting developments on the Cell in the coming months, no\ndoubt.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000793030739/','2005-02-09 09:51:49'),
 (154,3,'http://www.engadget.com/entry/1234000047030598/','Hasbro to produce updated Furby','<img alt=\"furby\" src=\"http://www.weblogsinc.com/common/images/9265051172762473.jpg?0.07125376989930476\" align=\"right\"\nborder=\"0\" height=\"201\" hspace=\"4\" vspace=\"16\" width=\"150\" /> \n\n<p>You can have your Aibos and Robosapiens. For a lot of people, there will always be just one interactive toy. That&#8217;s\nright, we&#8217;re talking Furby here. We still have fond memories of the crushing lines at FAO Schwarz, the little bugger&#8217;s\nannoying, high-pitched laugh, and those bugged-out eyes. Okay, maybe we&#8217;re not so fond &#8212; especially about the long\nlines when the toy debuted. Nevertheless, we&#8217;re curious to see what Hasbro comes up with when they release Furby II\nlater this year. After all, there&#8217;s a lot more competition now when it comes to interactive toys, and cute and fuzzy\njust ain&#8217;t gonna cut it anymore. According to CNN/Money, the new model will feature more lifelike emotions, be able to\nsimulate breathing (creepy!), and will have what&#8217;s described as amazing &#8220;beak flexibility&#8221; (presumably that doesn&#8217;t\nmean it&#8217;ll be able to bite your finger off if you get it pissed off). And, yes, it&#8217;ll still speak Furbish, though it&#8217;ll\nsupposedly be easier to get the fuzzball to learn English if you don&#8217;t have the patience to listen to endless\nrepetitions of &#8220;Kah toh-loo noh-lah wah!&#8221;</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000047030598/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (155,3,'http://www.engadget.com/entry/1234000907030737/','Controlling your Mac mini from your Newton','<a href=\"http://vaguelyaware.com/upload/newtonVNC.jpg\"><img alt=\"Newton to Mac mini VNC\"\nsrc=\"http://www.weblogsinc.com/common/images/3081100454475300.JPG?0.1692481861971652\" align=\"top\" border=\"1\"\nheight=\"283\" hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n \n\n<p>When we joked a few weeks ago in the part about VNC in our tutorial on\n<a href=\"http://www.engadget.com/entry/1234000057028826/\">turning your Mac mini into a media center</a> that we&#8217;d give\n&#8220;300 bonus points to anybody who sends us a shot of their Newton controlling their Mac mini,&#8221; we never thought we&#8217;d\nactually have to pay up. Alright, Kyle Fiducia, will you take a third-party bad check?<br />\n\n &nbsp;</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000907030737/','2005-02-09 09:51:49'),
 (156,3,'http://www.engadget.com/entry/1234000683030581/','xcute DV1 three megapixel cameraphone less toy-like on second take','<p><img alt=\"xcute DV1\" src=\"http://www.weblogsinc.com/common/images/5325656122366322.jpg?0.706290669811558\"\nalign=\"right\" border=\"1\" hspace=\"4\" vspace=\"12\" />We covered this phone back when it was the\n<a href=\"http://www.engadget.com/entry/1234000160027154/\">X-cute V8</a>, but now Taiwan&#8217;s Yan Chuan Communication have\nchanged their name to xcute Mobile of Taiwan and renamed their little flip-phone the xcute DV1. Pretty much the first\nGSM/GPRS handset with a 3 megapixel camera built-in, this tri-band (900/1800/1900) handset has clearly been designed\naround the camera. And while it falls clearly into the category of &#8216;short and stubby&#8217;, the DV1 does include a 640x240\nmain display kicking out 16.7m colors, and a 96x64 OLED sub-display.&nbsp; The camera also shoots 640x480 video at\n30fps, and stores all of this still and video content on either 20MB of internal storage or the miniSD card of your\nfancy. The only major drawback is the lack of Bluetooth.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000683030581/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (157,3,'http://www.engadget.com/entry/1234000290030751/','Siemens\' M34 USB adapter for Skype reviewed','<img alt=\"siemens skype dongle\" src=\"http://www.weblogsinc.com/common/images/7818259725970136.jpg?0.6155298087713033\"\nalign=\"right\" border=\"0\" height=\"101\" hspace=\"4\" vspace=\"16\" width=\"216\" /> \n\n<p>There are now <a href=\"http://www.engadget.com/search/?q=skype+phone+usb&amp;submit=Go\">a handful</a> of specialized\nphones and devices that let you make Skype calls using telephones. While our preference is to use something like the\n<a href=\"http://www.engadget.com/entry/1234000800027600/\">Actiontec Internet Phone Wizard</a>, which lets you make\nSkype calls using any telephone in your home, most of the action is concentrated on specialized phones or adaptors that\ntypically connect to your computer via USB and to your home phone system via an RJ11 in a base station, allowing you to\nmake calls using both Skype and your landline. One of the first of these to hit the market was the\n<a href=\"http://www.engadget.com/entry/7280854652028487/\">Siemens Gigaset M34 USB adaptor</a>, which lets certain\nSiemens phones work with Skype. Digital Lifestyles tried one out, and came away impressed, both by the Siemens S440\nhandset they tried out (which, of course, still works without Skype), and by the M34, which, in addition to Skype,\nallows you to IM with your phone, and even control your PC to some extent (so that, for example, you can use your phone\nas an iTunes remote). Of course, all of this doesn&#8217;t come cheap; the M34 will set you back about $129, and the cheapest\ncompatible handset is $65. But if you&#8217;re facing hefty landline bills, it could end up paying for itself pretty\nquickly.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000290030751/','2005-02-09 09:51:49'),
 (158,3,'http://www.engadget.com/entry/1234000467030734/','Xdrive lets you stream music to your Treo','<a href=\"http://www.prnewswire.com/cgi-bin/stories.pl?ACCT=109&amp;STORY=/www/story/02-07-2005/0002983986&amp;EDATE=\"><img alt=\"Treo 650 small\"\n     src=\"http://www.weblogsinc.com/common/images/4337881689166545.jpg?0.7842731069827377\" align=\"right\" border=\"0\"\n     height=\"203\" hspace=\"4\" vspace=\"16\" width=\"100\" /></a>\n\n<p>Dubbing it a &#8220;virtual iPod&#8221; is pretty freaking disingenuous, but Xdrive has announced a new service which&#8217;ll let you\nstream MP3 files stored in your online locker (they offer 5GB for $9.95 a month) to your\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=treo\">Treo</a> and other wirelessly-connected\nPalm handhelds. Nothing that you couldn&#8217;t do already in plenty of other ways (at least not for online storage, you can\npretty easily stream music from your own PC to a cellphone), and it does require you to install an audio player on your\nPalm that supports streaming MP3, then download an Xdrive playlist to your computer and then upload it to your\nhandheld.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000467030734/','2005-02-09 09:51:49');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (159,2,'http://www.d-ross.org/index.cfm?objectid=87BEF6EF-EE9A-3C31-3369F2C8DBA9BDE8','code theft? or just laziness?','\n	\n	So... surfing around today I stumbled across something interesting. A project up on tigris called cfcxmi. As some of you may know, about a year ago I played around a bit with a tool to conv...',NULL,'','87BEF6EF-EE9A-3C31-3369F2C8DBA9BDE8','2005-02-09 09:51:57'),
 (160,2,'http://www.d-ross.org/index.cfm?objectid=771DF862-C875-2ABB-A3EFB67C341C08A3','Still looking for feedback re: CF IoC container','\n	\n	Well, I haven\'t heard much from those that originaly offered to take a look, so if anyone else is interested, drop me a comment and I\'ll send you the code (or give you CVS access, your choice).\n\nI\'m particularily interested in feedback from mach-ii user...',NULL,'','771DF862-C875-2ABB-A3EFB67C341C08A3','2005-02-09 09:51:57'),
 (161,2,'http://www.d-ross.org/index.cfm?objectid=49AE2EAE-9362-9132-BBA91D627B8DF6E0','How much should a DAO know?','\n	\n	This is basically just a repost of a comment I posted on Joe Rinehart\'s post on cohesion/DAOs:\n<DIV class=b...',NULL,'','49AE2EAE-9362-9132-BBA91D627B8DF6E0','2005-02-09 09:51:57'),
 (162,2,'http://www.d-ross.org/index.cfm?objectid=9C65ECEC-508B-E116-6F8A9F878188D7CA','Busy ColdFusion Developers\' Guide to HSSF Features','\n	\n	JMR broke our comments, they\'re fixed now (he gets 200+ spams a day, I get 1 a month). Anyways, I mentioned that I would translate the ...',NULL,'','9C65ECEC-508B-E116-6F8A9F878188D7CA','2005-02-09 09:51:58');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (163,2,'http://www.d-ross.org/index.cfm?objectid=2473B999-A380-2CA6-181EBFA1BEAE1893','FCKEditor 2.0 RC2','\n	\n	is now my RTE for comments. I was on a 1.x version but I wanted to upgrade so I could have gecko support. \nI have to say that FCK and TinyMCE are probably the 2 nicest free RTEs out there, with FCK having more features and TinyMCE being more li...',NULL,'','2473B999-A380-2CA6-181EBFA1BEAE1893','2005-02-09 09:51:58'),
 (164,2,'http://www.d-ross.org/index.cfm?objectid=1A687650-9F5E-01FD-E2554CF5AAAC97EF','coldfusion *inside* java','\n	\n	Most people know by now that CF offers very tight java integration... it\'s rather rare that I have to write a wrapper class in java that is callable by CF (usually only java classes with lots of overloaded methods pose difficulty).\nTo make a lo...',NULL,'','1A687650-9F5E-01FD-E2554CF5AAAC97EF','2005-02-09 09:51:58'),
 (165,2,'http://www.d-ross.org/index.cfm?objectid=1604C3FE-A064-4689-26E270B6472CE5B0','Coldfusion and Inversion of Control','\n	\n	I\'ve been working with a large open-source java application lately that uses several interesting technologies, namely Hibernate (object-relational mapper), Java Server Faces (ui framework/toolkit), and Spring. The app doesn\'t use all of Spring\'s functi...',NULL,'','1604C3FE-A064-4689-26E270B6472CE5B0','2005-02-09 09:51:58'),
 (166,2,'http://www.d-ross.org/index.cfm?objectid=15F9D578-F588-541B-74A4F6EC6FD10187','back up (kinda)','\n	\n	long story short... disk array on the (old) server went bad. I\'m living temporarily on a different box until some new hardware comes in (should be &lt; 2 weeks).\nI just *barely* was able to recover, as I lost data in both my live tran...',NULL,'','15F9D578-F588-541B-74A4F6EC6FD10187','2005-02-09 09:51:58');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (167,2,'http://www.d-ross.org/index.cfm?objectid=3C6ED6A0-508B-E116-6FED638040F58B83','Reading bitmaps out of a database','\n	\n	After having a very frustrating time extracting images out of a database (specifically bitmaps), I figured I\'d document it to save someone else the time.\nThis is something that I thought would take five minutes and turned into an hour, due to s...',NULL,'','3C6ED6A0-508B-E116-6FED638040F58B83','2005-02-09 09:51:58'),
 (168,2,'http://www.d-ross.org/index.cfm?objectid=9C65EEF0-508B-E116-6F30CA79F5BFDE07','more LDAP : Active Directory nested groups','\n	\n	Long story short, a client wants to be able to use the nested groups in their Active Directory (AD from now on) in integrating with my favorite CMS, Farcry. Nested groups are a feature available ...',NULL,'','9C65EEF0-508B-E116-6F30CA79F5BFDE07','2005-02-09 09:51:58'),
 (169,2,'http://www.d-ross.org/index.cfm?objectid=0CEFA43A-508B-E116-6F845F2E21831773','I am so proud...','\n	\n	I feel like my complaining on various blogs may have actually contributed to this. Central was dead in the water with the original licensing res...',NULL,'','0CEFA43A-508B-E116-6F845F2E21831773','2005-02-09 09:51:58'),
 (170,2,'http://www.d-ross.org/index.cfm?objectid=0942656D-508B-E116-6FDCCBABB1DAB286','Flash video + german enginneering =','\n	\n	some damn cool sounds coming through your speakers. More and more I see impressive uses of flash video. I haven\'t played around with it much myself, but plan to in the near future.\n...',NULL,'','0942656D-508B-E116-6FDCCBABB1DAB286','2005-02-09 09:51:58');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (171,2,'http://www.d-ross.org/index.cfm?objectid=07805165-508B-E116-6FC813D1EF6D764E','dbXml 2.0','\n	\n	Thanks to Chris for pointing this out in an older post. dbXml, a project that branched into the Apache Xindice project, has been re-released a...',NULL,'','07805165-508B-E116-6FC813D1EF6D764E','2005-02-09 09:51:58'),
 (172,2,'http://www.d-ross.org/index.cfm?objectid=9B613730-508B-E116-6F6AA9A01593BE0D','You know what I love about Farcry...','\n	\n	It took maybe 3 hours total (I\'ve now added emailing and a RTE) to incorporate a \"comments\" interface to the out-of-the-box \"news\" content type.\nThen today I realized that it would be cool to have comments on just plain old html pages like ...',NULL,'','9B613730-508B-E116-6F6AA9A01593BE0D','2005-02-09 09:51:58'),
 (173,2,'http://www.d-ross.org/index.cfm?objectid=6E4FCF97-508B-E116-6FEB7A23A3D0E56C','My Next Project','\n	\n	I\'ve always been interested in home automation, however I never had a home to try it out on. Now that I do, I want to use a web server on my home network to control various tasks. The first target is the result of a friday night (if you consider 4...',NULL,'','6E4FCF97-508B-E116-6FEB7A23A3D0E56C','2005-02-09 09:51:58'),
 (174,2,'http://www.d-ross.org/index.cfm?objectid=2F7E61E3-508B-E116-6FEEA8A4472AAA73','3 new methods for CFMX Xindice wrapper','\n	\n	Rich Ziade asked \"How difficult is it to wrap some additional methods like deleting documents from a particular collection or copying/moving docs from one collection to another?\", in my ...',NULL,'','2F7E61E3-508B-E116-6FEEA8A4472AAA73','2005-02-09 09:51:58');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (175,2,'http://www.d-ross.org/index.cfm?objectid=D7692636-508B-E116-6F0BC2777ED5EC8D','Xindice, CFMX, JRun','\n	\n	Xindice is an free open source implementation of a pure XML database. Xindice provides a mechanism to store, query, and update collections of XML documents. Knowing whether you n...',NULL,'','D7692636-508B-E116-6F0BC2777ED5EC8D','2005-02-09 09:51:58'),
 (176,2,'http://www.d-ross.org/index.cfm?objectid=9C65ED79-508B-E116-6F81AF8F75FB40AD','Asynchronous searching w/ JLDAP','\n	\n	\"CL\" recently asked if I could show an example of searching a directory using JLDAP to return member attributes. It\'s pretty straightforward, although getting the results out of the ...',NULL,'','9C65ED79-508B-E116-6F81AF8F75FB40AD','2005-02-09 09:51:58'),
 (177,2,'http://www.d-ross.org/index.cfm?objectid=B89B1D8A-508B-E116-6F9268DD4530C81D','This blog has moved','\n	\n	So, I have my moved my blog over to Farcry CMS, and a new domain. Hopefully everyone\'s browser, newsreader is following the redirects from ...',NULL,'','B89B1D8A-508B-E116-6F9268DD4530C81D','2005-02-09 09:51:58'),
 (178,2,'http://www.d-ross.org/index.cfm?objectid=9C65ECCD-508B-E116-6FDBA112B5AC5072','Type validation when passing java objects to CFFUNCTION','\n	\n	I\'ve come across many situations where I would like to pass an instance of a java class to a cffunction. In order for CF to let the argument through, you must specify type=\"any\" or leave the type attribute out. It\'s unfortunate that CF cannot...',NULL,'','9C65ECCD-508B-E116-6FDBA112B5AC5072','2005-02-09 09:51:58');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (179,2,'http://www.d-ross.org/index.cfm?objectid=9C65ED5A-508B-E116-6F4F7F38C6AE167C','Generating Excel spreadsheets from CFMX','\n	\n	On Ben Forta\'s blog, many have been asking for \"Blackstone\" (next version of CFMX) to be able to export data to .xls format. Over the past few years, there ...',NULL,'','9C65ED5A-508B-E116-6F4F7F38C6AE167C','2005-02-09 09:51:58'),
 (180,2,'http://www.d-ross.org/index.cfm?objectid=9C65EF0F-508B-E116-6F851C474448E08B','Changing (novell) passwords over LDAP w/ CFMX','\n	\n	If you are in an environment that uses Novell Directory services, you may have enabled some of your web apps to perform authentication against the novell user accounts, typically using the CFLDAP tag. This works great, and it\'s a great way to incorpora...',NULL,'','9C65EF0F-508B-E116-6F851C474448E08B','2005-02-09 09:51:59'),
 (181,2,'http://www.d-ross.org/index.cfm?objectid=9C65EF4E-508B-E116-6F26B12CF7424994','CFC Modeling','\n	\n	I posted about this on the mach-ii forums... anyways\nI did some work on generating CFCs fro...',NULL,'','9C65EF4E-508B-E116-6F26B12CF7424994','2005-02-09 09:51:59'),
 (182,2,'http://www.d-ross.org/index.cfm?objectid=9C65EF7D-508B-E116-6F16DE9D75F02CDF','Framework load testing comparison','\n	\n	\nI set up this blog this morning because it\'s something I\'ve been meaning to \ndo... and since I wanted a place to post the results of some load tests I did \ncomparing a few cold fusion development frameworks. This stems from Ike\'s \nexecution times comp...',NULL,'','9C65EF7D-508B-E116-6F16DE9D75F02CDF','2005-02-09 09:51:59');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (183,2,'http://www.d-ross.org/index.cfm?objectid=F7D09312-A7F9-DF09-3E8E59AC861E3651','\"coldspring\" on cfopen.org w/ pre-alpha release','\n	\n	I started a project on cfopen.org called \"coldspring\" to organize the work I\'ve done thus-far with the previously mentioned spring-like CFC container. This morning I added a very pre-alpha release:\n...',NULL,'','F7D09312-A7F9-DF09-3E8E59AC861E3651','2005-02-10 20:56:40'),
 (184,3,'http://www.engadget.com/entry/1234000753031158/','The latest dirt on the HP hw6500','<a href=\"http://www.gpspassion.com/forumsen/topic.asp?TOPIC_ID=23432\"><img height=\"189\" alt=\"HP hw6500\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/2633176863128486.JPG?0.09428209470363258\" width=\"430\" align=\"top\"\nvspace=\"4\" border=\"1\" /></a><br />\n\n\n<p>When you get tipped or dig up early info on an unreleased product, there&#8217;s always a certain amount of speculation\nand interpretation you have to do. In the case of HP&#8217;s forthcoming\n<a href=\"http://www.engadget.com/entry/1234000197030255/\">hw6500 iPAQ Mobile Messenger</a>, of its supposed\n<a href=\"http://gps.engadget.com/\">GPS</a> functionality there was some question as to whether it was capable with an\nextra device via its SDIO slot or Bluetooth, or whether it actually has integrated GPS. We banked on integrated, and\nthough no one&#8217;s right about anything until the device actually hits the streets, it would appear that someone who got\ntheir grubby mitts on one was able to confirm the <a href=\"http://www.engadget.com/entry/1234000913030286/\">integrated\nGPS thing</a>&#8212;and that the port on the back was for attaching an external GPS antenna. Totally down with that, though\nwe are getting mighty afraid of this thing&#8217;s pricetag.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000753031158/','2005-02-10 22:30:10'),
 (185,3,'http://www.engadget.com/entry/1234000167030871/','The Clicker -- Why are there 18 standards for HDTV?','<em><img alt=\"LG Plasma TV\" src=\"http://www.weblogsinc.com/common/images/2128125257167771.jpg?0.59095333600996\"\nalign=\"right\" border=\"0\" height=\"188\" hspace=\"4\" vspace=\"16\" width=\"250\" />Remember how a few weeks ago we said we were\nlooking for new feature columnists? Well, we&#8217;re happy to introduce The Clicker, a new weekly column from Stephen\nSpeicher about something we all can relate to: television.</em> <br />\n\n <br />\n\n \n\n<p>Hello and welcome to &#8220;The Clicker,&#8221; Engadget&#8217;s weekly wandering into the granddaddy of all gadgets &ndash; the\ntelevision.<br />\n\n<br />\n\n Have a seat on the couch. Kick back, relax. Just remember the rules: keep your shoes off the coffee table and keep\nyour grubby little hands off my remote. Hold on; that sounded a bit hostile. You&#8217;ll have to forgive me. I get a little\npossessive of my remote. Don&#8217;t worry &ndash; I am currently seeing a therapist about this. Well&hellip; this and my fits of blind\nrage upon discovering that CSI has been deleted from the TiVo in order to make room for Emeril Lagasse!</p>\n\n\n\n<p>Besides, I&#8217;m sure that you, as Engadget readers, can understand the Zen-like relationship that a man has with both\nhis remote control and his TiVo. If you&#8217;re anything like me, you&#8217;ve learned to scan through the channels with the best\nof them. You too have developed a Jedi-like ability to quickly skip over Lifetime, Oxygen, and The Hallmark Channel\nwhile spending a little more time on ESPN and the Sci-Fi Channel. Basically, your hand feels naked without the\nremote.</p>\n\n\n<p><br />\n\n But I digress.<br />\n\n<br />\n\n Having spent some time in the cable TV world, I&#8217;m often asked questions about television, HDTV, cable, etc. &#8216;The\nClicker&#8217; is my weekly opportunity to answer these questions. If you too have a question, email me at\n<a href=\"mailto:theclicker@theevilempire.com\">theclicker@theevilempire.com</a>.<br />\n\n<br />\n\n This week&#8217;s question comes from Bill Jordon. He asks, &#8220;Why are there 18 different standards for HDTV? Why do some\nstations (like ESPN-HD) use 720p and other stations (like HBOHD) use 1080i?&#8221;<br />\n\n<br />\n\n First, to be technical, there are eighteen different &#8216;ATSC DTV (digital television) formats&#8217; of which only six are\nactually High-Definition. Of the six HDTV formats only two are used frequently, 720p and 1080i. That doesn&#8217;t really\nanswer the question, but it narrows the field down a bit and gives us something to work with.<br />\n\n<br />\n\n The answer comes down to what type of content the broadcaster is looking to optimize. We all know that 1080i has the\nhigher resolution, so why bother offering another format like 720p? While it&#8217;s true that 1080i has a greater number of\npixels (1920 x 1080 vs. 1280 x 720), 720 has two things working to its advantage. First, 720p is a progressive signal.\nSecond, 720p is 60 fps (frames per second). 1080i, on the other hand, is interlaced and 30 fps (60 fields per\nsecond).<br />\n\n<br />\n\n Where does this matter? It matters for fast movement (e.g. sports). Let&#8217;s look at an example using both 720p and\n1080i:<br />\n\n<br />\n\n Suppose that we have a tennis ball moving across the screen for 1 second. A broadcast in 720p is going to show 60\ncomplete images of the tennis ball. Think of it like an old-fashioned flipbook that has 60 pages. Each page will have a\ncomplete image and when you quickly flip through the entire book it will give you movement. This is much like how\ntraditional film works (albeit with 24 fps).<br />\n\n<br />\n\n If we were to do the same experiment with 1080i, it would be quite different. Unlike progressive formats, which show\nthe whole picture, interlaced material relies on the fact that two half-pictures will generally combine to make one\nwhole picture. As such, 1080i will display the even lines for 1/60th of a second followed by the odd lines for 1/60th\nof second. If we return to the flipbook example, we can see that the book will still have 60 pages but each page will\nlook a little like we&#8217;re looking through mini-blinds. Of course, when it&#8217;s sped up it doesn&#8217;t look like this. A\ncombination of the display (afterglow) and the mind combine to complete the picture.<br />\n\n<br />\n\n &#8220;But can&#8217;t you de-interlace a 1080i signal and have the best of both worlds?&#8221; (De-interlacing is the process of\nconverting an interlaced signal into a progressive signal by combining the even lines and the odd lines to form one\nsolid picture) Yes, but even in the best case you are only getting 30 fps (half the frames of 720p). In the worst case,\nthe even lines and the odd lines don&#8217;t quite match up. For instance, assume that the camera is capturing half the\npicture every 1/60th of a second. In that case, it&#8217;s possible that the ball has moved enough in that short amount of\ntime that the odd lines don&#8217;t align with the even lines.<br />\n\n<br />\n\n In either case, 720p has the potential to deliver a smoother, more stable picture when dealing with fast motion.<br />\n\n<br />\n\n It&#8217;s easy to see why ESPN-HD chose 720p as its standard. Likewise, as ABC and ESPN are owned by the same parent\ncompany, one can see why ABC wanted to be inline with its sister network.<br />\n\n<br />\n\n &#8220;So, if 720p delivers a smoother picture, why not just use it?&#8221; The answer is resolution. 1080i has many more pixels\nand often you don&#8217;t need the extra frames. The majority of the content being shown today was first shot on film. Most\nTV dramas and nearly all movies start their lives as film. Since film is 24fps, 1080i&#8217;s 30 fps is more than enough to\ncapture all the frames. The result is that broadcasters who feel that film-based material is their bread and butter\nwill often choose 1080i.<br />\n\n<br />\n\n There are, of course, other arguments for each of the technologies (e.g. bandwidth, remote cameras, matching digital\nTVs, etc.), and, like any good format war, proponents on each side view their side as the only side.<br />\n\n<br />\n\n Until next week, save my seat!</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000167030871/','2005-02-10 22:30:10');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (186,3,'http://www.engadget.com/entry/1234000043031134/','Motorola\'s PEBL V6','<a href=\"http://www.newsmobile.it/notizia/05,02,10,7011590-1.htm\"><img alt=\"Motorola PEBL V6\"\nsrc=\"http://www.weblogsinc.com/common/images/1872334912377535.JPG?0.32649191817070633\" align=\"top\" border=\"1\"\nheight=\"279\" hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n\n<p>Ok, and here&#8217;s the slide featuring Motorola&#8217;s new PEBL V6 handset.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000043031134/','2005-02-10 22:30:10'),
 (187,3,'http://www.engadget.com/entry/1234000060031132/','The Royal Blade, Motorola\'s candybar-style RAZR phone','<img alt=\"Motorola RAZR Royal Blade\"\nsrc=\"http://www.weblogsinc.com/common/images/6314322665476300.JPG?0.38173466003418133\" align=\"top\" border=\"1\"\nheight=\"296\" hspace=\"4\" vspace=\"4\" width=\"425\" /><br />\n\n \n\n<p>The photos are annoyingly watermarked (watermarking your pics is so weak, if you&#8217;re that worried, don&#8217;t put &#8216;em out\nthere!), but some images have turned up (courtesy of a slideshow) of a bunch of next-gen Motorola handsets. Among them,\nthat <a href=\"http://www.engadget.com/entry/1234000797028392/\">new candybar-style RAZR</a> we&#8217;ve been hearing about\n(which is called the &#8220;Royal Blade&#8221;); the PEBL V6, a new clamshell handset; the A1010, a new 3G smartphone; and the\nE1060, a 3G multimedia 1.3 megapixel cameraphone.<br />\n\n<br />\n\n [Thanks, Rudi]</p>\n\n\n<img alt=\"Motorola A1010\" src=\"http://www.weblogsinc.com/common/images/1411853531785053.JPG?0.5231250163120323\"\nalign=\"top\" border=\"1\" height=\"318\" hspace=\"4\" vspace=\"4\" width=\"425\" /><br />\n\n<br />\n\n<br />\n\n \n\n<p><img alt=\"Motorola E1060\" src=\"http://www.weblogsinc.com/common/images/8558981566721877.JPG?0.7644189081532015\"\nalign=\"top\" border=\"1\" height=\"307\" hspace=\"4\" vspace=\"4\" width=\"425\" /></p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000060031132/','2005-02-10 22:30:10'),
 (188,3,'http://www.engadget.com/entry/1234000470031114/','Tablet PC bug gobbles resources; Microsoft says to reboot','<img alt=\"tabletpc\" src=\"http://www.weblogsinc.com/common/images/8391854652018387.jpg?0.35925257128227883\"\nalign=\"right\" border=\"1\" height=\"110\" hspace=\"4\" vspace=\"16\" width=\"92\" /> \n\n<p>Given the <a href=\"http://www.engadget.com/entry/5449225145623224/\">huge success</a> of Microsoft&#8217;s Tablet PC\nEdition of Windows XP, we somehow expect that not a lot of you will care about this, but we&#8217;ll share the news anyhow: A\nbug in the OS causes the Tablet Input Panel (the process that handles pen input) to steadily increase its use of system\nresources until there&#8217;s nothing left for other apps. Until a fix is available, Microsoft&#8217;s helpful advice is to reboot\ndaily. We can offer some even better solutions, but we think you have a good idea of what those are.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000470031114/','2005-02-10 22:30:10');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (189,3,'http://www.engadget.com/entry/1234000700031117/','Vonage settles suit against CallVantage','<p><a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=vonage\"><img alt=\"vonage\"\nsrc=\"http://www.weblogsinc.com/common/images/4070977119820632.jpg?0.5238816509982372\" align=\"right\" border=\"0\"\nheight=\"200\" hspace=\"4\" vspace=\"16\" width=\"200\" />Vonage</a> has settled its trademark infringement suit against\nAT&amp;T. They alleged that the name of AT&amp;T&#8217;s broadband Voice over IP service,\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=callvantage\">CallVantage</a>, was a little close\nfor comfort and that it could potentially confuse customers (it&#8217;s hard to believe that AT&amp;T didn&#8217;t have Vonage in\nmind when they were creating the service). They won&#8217;t disclose whether any money changed hands, but AT&amp;T has agreed\nto always refer to CallVantage as &#8220;AT&amp;T CallVantage&#8221; (obviously changing the name to &#8220;The CallVantage UK&#8221;, &#8216;The\nLondon CallVantage&#8221;, or &#8220;The CallVantage 5&#8221; wasn&#8217;t going to work out).</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000700031117/','2005-02-10 22:30:11'),
 (190,3,'http://www.engadget.com/entry/1234000407031112/','How does a 600GB Toshiba DVR, the RD-Z1 sound to you?','<p style=\"text-align: center\">\n  <a href=\"http://www.toshiba.co.jp/about/press/2005_02/pr_j0903.htm\"><img alt=\"Toshiba RD-Z1\"\n  src=\"http://www.weblogsinc.com/common/images/2746533654353955.JPG?0.16647954751389293\" align=\"top\" border=\"0\"\n  height=\"210\" hspace=\"4\" vspace=\"4\" width=\"380\" /></a>\n</p>\n<br />\n\n\n<p>What, a few hundred gigs of DVR space wasn&#8217;t enough? Oh yeah, you&#8217;re\n<a href=\"http://www.engadget.com/entry/1234000040029144/\">DVRing hi-def</a>, sorry, peep Toshiba&#8217;s monster 600GB RD-Z1,\na straight HDMI DVR with dual satellite tuners, integrated Ethernet, and an 8x DVD-R/5x DVD-RAM burner. Good god, the\nJapanese don&#8217;t mess around&#8212;too bad it&#8217;s about as likely to hit these shores as\n<a href=\"http://www.engadget.com/search/?q=tivo&amp;submit=Go\">TiVo</a> would be to release something that could even\n<a href=\"http://www.engadget.com/entry/1234000100030115/\">begin to compete</a>.<br />\n\n<br />\n\n[Via <a href=\"http://akiba.sorobangeeks.net/news_9181.html\">Akihabara News</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000407031112/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (191,3,'http://www.engadget.com/entry/1234000417031103/','Firebox VoIP Cyberphone','<a href=\"http://www.voipcyberphone.com/\"><img alt=\"Firebox VoIP Cyberphone\"\nsrc=\"http://www.weblogsinc.com/common/images/8816025379381225.JPG?0.8709196776391267\" align=\"right\" border=\"0\"\nheight=\"163\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a> \n\n<p>If <a href=\"http://www.engadget.com/search/?q=skype&amp;submit=Go\">Skype</a> continues to grow at the rate is has\nbeen (yes, more Skype news today), you can expect phones like these to be as common as webcams in a few years.&nbsp;\nThe latest is the Firebox VoIP Cyberphone, a USB handset that lets you make Skype calls without the need of a desktop\ninterface or goofy headset.&nbsp; Our only hesitation about these is that there&#8217;s bound to be wireless Skype phones\ncoming along in a few months, and probably not at much of a premium.&nbsp; But if you can&#8217;t wait, the VoIP Cyberphone\nis available now direct from Firebox for &pound;29.95.<br />\n\n<br />\n\n [Via <a href=\"http://www.redferret.net\">TRFJ</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000417031103/','2005-02-10 22:30:11'),
 (192,3,'http://www.engadget.com/entry/1234000077031110/','Geek chic just chic with PDA Lip Gloss','<a href=\"http://www.firacosmetics.com/shop/catpage.cfm?id=121#\"><img alt=\"PDA Lip Gloss\"\nsrc=\"http://www.weblogsinc.com/common/images/6944052294116939.JPG?0.4324880057320942\" align=\"right\" border=\"0\"\nheight=\"189\" hspace=\"4\" vspace=\"16\" width=\"144\" /></a>\n\n<p>One for <s>the lady</s> all the ladies out there in our audience: is it true that pretending to be busy and techie\nenough to carry a <a href=\"http://handhelds.engadget.com/\">PDA</a> (a\n<a href=\"http://www.engadget.com/search/?q=palm\">Palm</a> V, in this case) is cooler than actually owning such a\ndevice? If so, then apparently the Fira PDA Lip Gloss makeup/cosmetics compact is the best of both worlds. Hey, can&#8217;t\nsay we blame you&#8212;back in the day we never used our Palms either (until they put &#8216;em in our\n<a href=\"http://www.engadget.com/search/?q=treo&amp;submit=Go\">cellphones</a>, anyway), so may as well use that\nvaluable purse-real estate on something practical, right?<br />\n\n<br />\n\n[Via <a href=\"http://www.popgadget.net/2005/02/organize-your-lips.html\">Popgadget</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000077031110/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (193,3,'http://www.engadget.com/entry/1234000367031107/','Oakley and Motorola get into bed on the Razorwire','<img height=\"162\" alt=\"oakley blades\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/7673569580389881.jpg?0.5927439606894409\" width=\"180\" align=\"right\"\nvspace=\"16\" border=\"1\" /> \n\n<p>So Oakley&#8217;s already <a href=\"http://www.engadget.com/entry/1234000540027430/\">let loose</a> the initial surprise\nover their getting together with <a href=\"http://www.engadget.com/search/?q=motorola\">Motorola</a>&#8212;which seemed a\nnatural fit, what with Moto&#8217;s jointly-developed extreme-sports products with\n<a href=\"http://www.engadget.com/search/?q=motorola+burton&amp;submit=Go\">Burton</a>. The story at Oakley&#8217;s latest\nsales meeting goes a little something like this: Oakley&#8217;s Thump was such a hit they&#8217;re getting in bed with Moto because\nthey believe they can &#8220;redefine electronics&#8221;; we can expect not only the release of new versions of their Thump, this\ntime with Bluetooth, but also another device we previously hinted at, which will be called Razorwire. We can expect\nthis to be a &#8220;premium&#8221; Thump-like glasses-device (no mention of MP3 playback capabilities, but we&#8217;re assuming they&#8217;ll\nbe absent) developed with Motorola, which will be Blutooth 2.0-enabled, and will feature a multifunction button for\ndialing by voice and receiving calls from a host phone. We can expect the Razorwire in mid-2005, and we won&#8217;t be\nkeeping our hopes up that it&#8217;ll be something we&#8217;ll actually want to wear and use.</p>\n\n\n<p>[Thanks, Philip]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000367031107/','2005-02-10 22:30:11'),
 (194,3,'http://www.engadget.com/entry/1234000460031099/','JVC\'s new LCoS-based D-ILA flat-panel TVs','<a href=\"http://www.victor.co.jp/press/2005/d-ila-campaign.html\"><img alt=\"JVC LCOS\"\nsrc=\"http://www.weblogsinc.com/common/images/3349246468278882.JPG?0.9895520819976893\" align=\"right\" border=\"1\"\nheight=\"168\" hspace=\"4\" vspace=\"16\" width=\"230\" /></a> \n\n<p>Still waiting to see whether they&#8217;ll roll these out over here, but JVC is making for their new line of\n<a href=\"http://www.engadget.com/search/?q=lcos&amp;submit=Search+%BB\">LCoS</a>-based (Liquid Crystal on Silicon) D-ILA\nTVs (which also happen to be\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=hdmi\">HDMI</a>-capable). Neither LCoS nor HDMI\nare huge yet here in North America, but in Japan it sounds like HDMI is really taking off, and despite\n<a href=\"http://www.engadget.com/entry/1234000043025058/\">numerous problems</a> with LCOS technology, JVC seems to be\nforging ahead with it and, from all we can tell, have been pretty successful with it.&nbsp;<br />\n\n<br />\n\n [Via <a href=\"http://akiba.sorobangeeks.net/news_9182.html\">Akihabara News</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000460031099/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (195,3,'http://www.engadget.com/entry/1234000493031098/','Olympus m:robe 500i gets less than warm reception','<p>\n<a href=\"http://news.yahoo.com/news?tmpl=story&amp;u=/ap/20050209/ap_on_hi_te/tech_test_olympus_music_players_1\"><img alt=\"m:robe 500i\"\n     src=\"http://www.weblogsinc.com/common/images/1512964541895153.JPG?0.965644545148208\" align=\"right\" border=\"0\"\n     height=\"127\" hspace=\"4\" vspace=\"16\" width=\"230\" /></a>We&#8217;re none too happy when high quality products that\n     obviously had a lot of work put into them wind up garnering bad reviews and lots of criticism&#8212;believe it or not,\n     we do feel for the people behind the scenes who labor late into the night crafting gadgets of all types&#8212;but in the\n     case of <a href=\"http://www.engadget.com/search/?q=m%3Arobe&amp;submit=Go\">Olympus&#8217;s m:robe 500i</a>, well, what\n     can we say? We played around with it before, we called it out, and now that they&#8217;ve put themselves out there with\n     those <a href=\"http://engadget.com/entry/1234000130030635/\">silly Super Bowl ads</a> of theirs, it&#8217;s no surprise\n     that the AP/Yahoo! takes a shot across their bow by saying more or less\n     <a href=\"http://www.engadget.com/entry/1234000383026722/\">the same thing we did</a>: the 500i is a great\n     proof-of-concept device, but when it comes to usefulness or usability, you&#8217;d better look on, friend.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000493031098/','2005-02-10 22:30:11'),
 (196,3,'http://www.engadget.com/entry/1234000870031101/','Jobs says: Three PC makers are hitting me up for OS X','<a href=\"http://macdailynews.com/index.php/weblog/comments/4950/\"><img alt=\"OS X Panther\"\nsrc=\"http://www.weblogsinc.com/common/images/4979866097797419.jpg?0.48649904105281916\" align=\"right\" border=\"0\"\nheight=\"228\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a> \n\n<p>Bombshell-lovin&#8217; Stevie J. reveals plenty in a recent in-depth interview he did with Fortune mag, but the one that\nreally got our juices flowing was when he drops that &#8220;three of the biggest PC makers&#8221; are trying to convince him to\nlicense OS X for use in their machines, because their customers are &#8220;sick of the security problems that go with Windows\nand tired of waiting for Longhorn.&#8221; We&#8217;d bet that at least one of those companies is Sony, but he doesn&#8217;t tell us what\nwe really want to know: whether he said yes.<br />\n\n<br />\n\n [Via <a href=\"http://www.macrumors.com\">Mac Rumors</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000870031101/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (197,3,'http://www.engadget.com/entry/1234000170031097/','Saab\'s Alcokey brethalyzing car key','<a href=\"http://www.autoweb.com.au/cms/A_101770/newsarticle.html\"><img alt=\"Saab Alcokey\"\nsrc=\"http://www.weblogsinc.com/common/images/7436767232366322.JPG?0.04482930778490535\" align=\"right\" border=\"0\"\nheight=\"127\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a>\n\n<p>The <a href=\"http://www.engadget.com/entry/1127914145745557/\">Alcolock</a>, the\n<a href=\"http://www.engadget.com/entry/7280854642018387/\">Alco-Detector</a>, so many\n<a href=\"http://www.engadget.com/search/?q=breath\">breathalyzers</a> being built into so many devices these days, it&#8217;s\nalmost enough to make us wonder whether or not everyone is always functionally drunk, and we&#8217;re just too sober and\noblivious to know it. Now Saab&#8217;s getting on the wagon (the bandwagon, if you will) with their Alcokey, which will add\n$400 to the pricetag of your car and will not disarm an integrated engine immobilizer unless you can breathe good and\nsober into the device pictured. It&#8217;s being trialed first in Saab&#8217;s home country of Sweden, so maybe they&#8217;re also taking\non opportunity to make a statement about a little too much Absolut sippy sippy going on this bitter Winter. Or maybe\nthey&#8217;re just being progressive, socially conscious Europeans. You know, either way.<br />\n\n<br />\n\n[Via <a href=\"http://www.i4u.com/article2873.html\">I4U</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000170031097/','2005-02-10 22:30:11'),
 (198,3,'http://www.engadget.com/entry/1234000687031096/','Skype to come pre-loaded on i-mate Pocket PC Phones','<p><a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=skype\"><img alt=\"iMate PDA2k EVDO\"\nsrc=\"http://www.weblogsinc.com/common/images/2476151059537927.jpg?0.8465276680884365\" align=\"right\" border=\"0\"\nheight=\"277\" hspace=\"4\" vspace=\"0\" width=\"136\" /></a>Seems like\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=skype\">Skype</a> is everywhere you want to be\nlately, and their latest smooth move is to announce that i-mate will ship their new PDA2K and PDA2 Pocket PC Phones\npre-loaded with Skype&#8217;s Voice over IP software so you can start making free calls right out of the box. Like that new\n<a href=\"http://www.engadget.com/entry/1234000410031028/\">BlackBerry 7270</a>, the idea is that you&#8217;ll make your free\nSkype calls from a WiFi hotspot (both phones come with built-in 802.11b), but there&#8217;s really no reason why you couldn&#8217;t\nfully stick it to the man by installing Skype (or say\n<a href=\"http://www.engadget.com/entry/6437880577833191/\">Vonage&#8217;s softphone</a>) on a 3G-capable Pocket PC Phone (like\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=xv6600\">Verizon&#8217;s XV6600</a>) and make\ncheap/free VoIP calls from anywhere (anywhere you get EV-DO coverage, that is).</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000687031096/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (199,3,'http://www.engadget.com/entry/1234000410031095/','Cingular\'s official with the BlackBerry 7100g','<a href=\"http://www.blackberrycool.com/2005/02/10/00158/\"><img height=\"168\" alt=\"BlackBerry 7100g\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/7548888455598645.JPG?0.4535105074045469\" width=\"88\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>Looks like <a href=\"http://www.engadget.com/search/?q=t-mobile+7100&amp;submit=Go\">T-Mobile</a>&#8217;s apparently finally\nlost their (American) lock on the <a href=\"http://www.engadget.com/search/?q=blackberry&amp;submit=Go\">BlackBerry</a>\n<a href=\"http://www.engadget.com/search/?q=7100\">7100</a>, as Cingular&#8217;s just gotten around to announcing their\n<a href=\"http://www.engadget.com/entry/1234000760025925/\">7100g</a>&#8212;specs should remain consistant (260x240 screen,\nBluetooth, GSM/GPRS, etc.), but can we just say that the 7100g is a much snappier dresser than its T-Mo brother the\n<a href=\"http://www.engadget.com/entry/7817148614747893/\">7100t</a>? Because it is. Sorry, no page up yet on Cingular&#8217;s\nsite for their new phone, but expect it shortly.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000410031095/','2005-02-10 22:30:11'),
 (200,3,'http://www.engadget.com/entry/1234000067031094/','PDD shows off swivel Helix cellphone','<a href=\"http://www.pdd.co.uk/helix/\"><img alt=\"Helix\"\nsrc=\"http://www.weblogsinc.com/common/images/7155163416327152.JPG?0.2689214475157645\" align=\"right\" border=\"1\"\nheight=\"161\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a> \n\n<p>The UK product design firm PDD is set to demonstrate the Helix, a concept cellphone, at 3GSM next week in\nCannes.&nbsp; The screen on the phone swivels completely around, giving you full view of it whether it&#8217;s opened or\nclosed.&nbsp; Judging by the company&#8217;s demo on its website, it also looks like it plays MP3s, but that&#8217;s about all we\nknow about the phone right now.<br />\n\n<br />\n\n [Via <a href=\"http://www.i4u.com/article2876.html\">I4U</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000067031094/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (201,3,'http://www.engadget.com/entry/1234000127031076/','Noxon Audio Player offers WiFi music streaming','<p><img alt=\"noxon audio\" src=\"http://www.weblogsinc.com/common/images/4845308185342629.jpg?0.17462887332833166\"\nalign=\"right\" border=\"0\" height=\"103\" hspace=\"4\" vspace=\"16\" width=\"120\" />The Noxon Audio Player is the latest entrant\nto the increasingly crowded field of WiFi audio adapters. Like the Airport Express,&nbsp;EZ-Stream Wireless Audio\nAdapter and <a href=\"http://wireless.engadget.com/search/?q=streaming+audio&amp;submit=Search+%BB\">other similar\nunits</a>, the Noxon can stream audio from your PC to any stereo or speakers over your home network. The Noxon does\nhave a couple of features that set it apart from some competing devices (though not higher-end ones like the Roku\nSoundbridge). It comes with its own remote, which lets you configure the unit as well as control your audio, and has an\nLCD display which can display song info and other data. It also has built-in software for PC-independent playback of\nInternet radio streams. It&#8217;s got a street price of about $150, putting it in what could be a sweet spot between the\nAirport Express and the $200 <a href=\"http://www.engadget.com/entry/1234000873023229/\">Roku M500</a> (Mac and Linux\nusers should note that Noxon&#8217;s posted specs only list Windows support, but users report that it is compatible with all\nthree operating systems). &nbsp;<br />\n\n<br />\n\n [Via <a href=\"http://www.biosmagazine.co.uk/\">Bios</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000127031076/','2005-02-10 22:30:11'),
 (202,3,'http://www.engadget.com/entry/1234000410031028/','RIM adds WiFi to the BlackBerry 7270, takes out the phone part','<a href=\"http://www.wi-fiplanet.com/news/article.php/3482016\"><img height=\"55\" alt=\"BlackBerry logo\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/6785825370303347.JPG?0.35331248841946095\" width=\"220\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>Reasearch In Motion&#8217;s first BlackBerry with built-in WiFi, the 7270, is going to have everything you&#8217;d expect from a\nBlackBerry. Everything except the phone part, that is. Sooner or later they&#8217;ll have to offer one with both, but in the\nmeantime they&#8217;re pitching the Voice Over IP capabilities of the 7270 and how you can use it to make voice calls from\nhotspots or on those WiFi-saturated corporate campuses we&#8217;re always hearing about.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000410031028/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (203,3,'http://www.engadget.com/entry/1234000983031027/','Get your kid a $40 iMac','<p style=\"text-align: center\">\n  <a href=\"http://www.taylorgifts.com/prodetail.asp?itemNo=23036&amp;ID=NN\"><img alt=\"iMac toy\"\n  src=\"http://www.weblogsinc.com/common/images/6337881677844212.JPG?0.24201698237813574\" align=\"top\" border=\"1\"\n  height=\"300\" hspace=\"4\" vspace=\"4\" width=\"300\" /></a>\n</p>\n\n\n<p>They obviously need to get with the program and update their toy so that it rips off the latest iMac, not any of the\nlast generation garbage, but check out this educational &#8220;wireless child&#8217;s PC&#8221; that sells for a mere forty bucks.<br />\n\n<br />\n\n[Via <a href=\"http://www.bookofjoe.com\">bookofjoe</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000983031027/','2005-02-10 22:30:11'),
 (204,3,'http://www.engadget.com/entry/1234000577030866/','IOGEAR introduces USB 2.0 Docking Station','<a href=\"http://www.iogear.com/main.php?loc=product&amp;Item=GUD201&amp;sec=Requirements#display\"><img alt=\"IOGEAR USB 2.0 docking station\"\n     src=\"http://www.weblogsinc.com/common/images/5181865886575165.JPG?0.0760013292149041\" border=\"0\" height=\"204\"\n     hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n \n\n<p>IOGEAR has just introduced it&#8217;s USB 2.0 Docking Station, a fairly straightforward looking unit for your laptop (but\nthat&#8217;s probably what you want a dock to be).&nbsp; Just connect your laptop via a USB cable and you&#8217;ll instantly add an\nEthernet port, two PS/2 ports, audio-in/out jacks, a serial port and three USB 2.0 ports.&nbsp; And even though it\nlooks like it&#8217;d be a good match with your shiny new PowerBook G4 perfectly, this one isn&#8217;t Mac compatible.&nbsp; But PC\nusers can get it now for $89.95.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000577030866/','2005-02-10 22:30:11'),
 (205,3,'http://www.engadget.com/entry/1234000390031208/','Dell\'s still number 1, but Acer is moving up in the world','<a href=\"http://www.tomshardware.com/hardnews/20050209_132528.html\"><img alt=\"PC shipments\"\nsrc=\"http://www.weblogsinc.com/common/images/4587261161547927.JPG?0.3718144123323299\" align=\"top\" border=\"0\"\nheight=\"248\" hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n\n<p>This might come as a bit of a surprise given how little attention anyone seems to pay to them, but Acer just\nrocketed up the sales charts to become the fifth biggest PC manufacturer worldwide, just edging out Toshiba. Dell&#8217;s\nstill at the top of the list (big surprise), with HP in 2nd, IBM holding steady at third and Fujitsu-Siemens coming in\nat fourth (and since you&#8217;re probably wondering, Apple squeaked in at tenth place).</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000390031208/','2005-02-10 22:30:11');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (206,3,'http://www.engadget.com/entry/1234000737031032/','Carly canned over HP printer division spin off?','<a href=\"http://www.forbes.com/markets/feeds/ap/2005/02/09/ap1816363.html\"><img alt=\"HP printer Photosmart 2710\"\nsrc=\"http://www.weblogsinc.com/common/images/9401742428674831.jpg?0.14915132130405584\" align=\"right\" border=\"0\"\nheight=\"97\" hspace=\"4\" vspace=\"16\" width=\"140\" /></a>\n\n<p>The new team occupying the head office are in denial mode about HP splitting up, but apparently it&#8217;s not just us who\nthink that Carly Fiorina&#8217;s hasty departure from HP yesterday might have had something to do with her reluctance to spin\noff the company&#8217;s printer and imaging business. The AP has the usual round of insta-reactions from Wall Street analysts\nwho think that the time is right for HP to break things up, especially since its the printer and imaging business\nthat&#8217;s making most of the money, while the PC business is still unprofitable.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000737031032/','2005-02-10 22:30:11'),
 (207,3,'http://www.engadget.com/entry/1234000620031212/','Sony Ericsson S710a coming to Cingular on March 9th?','<img height=\"157\" alt=\"s710 lens\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/3745397186452721.jpg?0.3681484159771955\" width=\"275\" align=\"right\"\nvspace=\"16\" border=\"1\" /> \n\n<p>This isn&#8217;t official or anything, but we&#8217;re hearing that Cingular is getting ready to (finally) introduce the\n<a href=\"http://www.engadget.com/entry/1234000700030570/\">Sony Ericsson S710a</a>, their new 1.3 megapixel cameraphone\nwhich we just reviewed on Monday, on March 9th. Tentative retail price: around $325 with a two year service\nagreement.<br />\n\n<br />\n\n[Thanks, Celly]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000620031212/','2005-02-11 08:29:54');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (208,3,'http://www.engadget.com/entry/1234000813030564/','Hong Kong driving, James Bond style','<a href=\"http://www.thenewspaper.com/rlc/news.asp?ID=135\"><img alt=\"Bond Aston Martin DB5\"\nsrc=\"http://www.weblogsinc.com/common/images/7280754652128408.JPG?0.05759732247560101\" align=\"right\" border=\"1\"\nheight=\"148\" hspace=\"4\" vspace=\"16\" width=\"240\" /></a> \n\n<p>Remember James Bond&#8217;s Aston Martin DB5 from Goldfinger and Thunderball? The old school one from the 60s that had the\nrotating license plates? (If not, see right.) Well, we&#8217;d think faux-spy-tech might have evolved into something more\nlike programmable LCD license plates, but some Hong Kong street racers are totally representing the OG Bond with radar\ndetectors and rotating license plates that are triggered by a red button next to the gear shift (what else would it\nbe?). Too bad the HK po-po got fed up and engaged in a sting operation that caught fourteen of modded cars. See? If\nthey&#8217;d only followed Q&#8217;s advice: &#8220;You see the gear lever here? Now, if you take the top off, you will find a little red\nbutton. Whatever you do, don&#8217;t touch it.&#8221;</p>\n\n\n<p>[Thanks, Richard]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000813030564/','2005-02-10 22:30:11'),
 (209,3,'http://www.engadget.com/entry/1234000140030982/','DigitalDeck networked DVR','<p><img alt=\"digital deck\" src=\"http://www.weblogsinc.com/common/images/8254041172762473.JPG?0.05719013648341331\"\nalign=\"right\" border=\"1\" height=\"66\" hspace=\"4\" vspace=\"12\" width=\"200\" />We know 2005 has been called the\n&#8220;<a href=\"http://www.engadget.com/entry/1234000553027148/\">year of high-def networking</a>.&#8221; Maybe it should really be\ncalled the &#8220;year of long-delayed hi-def network-products finally making it to market.&#8221; Like the\n<a href=\"http://www.engadget.com/search/?q=skipjam&amp;submit=Go\">SkipJam iMedia Center</a>, another home-entertainment\nnetworking box that&#8217;s been talked about for a while now looks ready to ship. The DigitalDeck Entertainment Network had\nits first demo at CES &#8212; CES <em>2004</em>, that is. It got great buzz, but eager customers were left holding their\nbreath until late last year, when the company announced that they had signed up Smarthome as a distributor. Now, the\nbox looks good to go. From what we can tell, it&#8217;s basically a PC-based DVR (running on XP Home, rather than Media\nCenter) that ships with a base unit and two remote boxes that can be connected via Ethernet. Given that several\n<a href=\"http://www.engadget.com/entry/8389631206451518/\">other products</a> already offer similar functions, and that\nthe DDEN requires a wired network, we&#8217;re not sure what all the hubbub was about, but we&#8217;ll reserve judgment until we\nsee some actual reviews.<br />\n\n<br />\n\n [Via <a href=\"http://www.designtechnica.com/\">Designtechnica</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000140030982/','2005-02-10 22:30:12');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (210,3,'http://www.engadget.com/entry/1234000203031026/','Switched On -- PDAs, a multiple murder mystery','<em><img alt=\"Dell Axim X50 Pocket PC\"\nsrc=\"http://www.weblogsinc.com/common/images/3103434910154201.jpg?0.24243038292838948\" align=\"right\" border=\"0\"\nheight=\"201\" hspace=\"4\" vspace=\"16\" width=\"115\" />Each week Ross Rubin contributes Switched On, a weekly column about\nthe future of technology, multimedia, and digital entertainment:<br />\n\n<br />\n</em> \n\n<p>The consensus diagnosis of the ailing PDA market is that smartphones have been responsible for the demise. Indeed,\nfuture smartphones and even lower-end feature phones will likely become the dominant mobile platforms with which we\ncheck the contacts and calendars that were the killer apps of the original Palm Pilot. Furthermore, smartphones are\ntheoretically better PIMs than PDAs were because of their wireless connectivity. Smartphone users can take advantage of\nlive remote synchronization or check off a to-do item by, for example, scheduling an appointment in the field or\nfollowing up on something via a phone call.<br />\n\n<br />\n\n But looking at the current crop of high-end smartphones hardly reveals a murderers&#8217; row off handheld punishers. While\nsuch devices continue to improve, handsets such as the <a href=\"http://www.engadget.com/entry/6281966886574165/\">Treo\n650</a>, <a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=p910\">Sony Ericsson P910</a>, and\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=h6315\">HP iPaq h6315</a> are fraught with\ncompromises and high prices even after carrier subsidy when compared to their closest competitors. As a result, their\npenetration is low. Many more moderately-priced phones have basic calendar and contact functions, but carriers do a\nmiserable job of helping consumers synchronize those phones with the computers that manage them today.</p>\n\n\n<br />\n\n \n\n<p>A strong argument is that the PDA is dying of natural causes; there were only so many people with so many\nappointments that they wanted a PDA, at least at the cost of fiddling with a foreign script such as Graffiti. If that&#8217;s\nthe perception, handheld makers haven&#8217;t done enough to expand their market. Sure, anyone can build a low-cost\nmonochrome PDA, but what about one that a busy technophobe mom could use. Simply speaking &#8220;Next Thursday is Jimmy&#8217;s\ndoctor&#8217;s appointment) would at least block out some time with a voice note. It&#8217;s mixing the default &#8220;foreign input&#8221;\nprinciple of <a href=\"http://tabletpcs.engadget.com/\">Tablet PC</a> ink-handling with some basic routing intelligence\nfrom the Newton or Lotus Agenda.<br />\n\n<br />\n\n The PDA paradox is that, ignoring cell phones for a moment, consumers should be more willing to gravitate toward a\nmultifunction portable device than a dedicated one due to the space constraints of mobility. But since the introduction\nof the original PDA, there&#8217;s been a mini-explosion of portable devices free from carrier oversight. But for a hard\ndrive, PalmOne could have developed the iPod or Portable Media Center. Instead, we see companies such as Archos taking\nportable video players and co-opting PIM functionality.<br />\n\n<br />\n\n <a href=\"http://gps.engadget.com\"><img alt=\"tomtom\"\nsrc=\"http://www.weblogsinc.com/common/images/3237024145735446.jpg?0.415056023445719\" align=\"right\" border=\"0\"\nheight=\"130\" hspace=\"4\" vspace=\"16\" width=\"150\" /> GPS</a> software companies such as\n<a href=\"http://www.engadget.com/search/?sourceid=Mozilla-search&amp;q=tomtom\">TomTom</a> and Pharos that have done\nwell on Pocket PCs are breaking out into their own dedicated devices now. And companies ranging from tiny Magpix to\ngiant Kodak are developing portable picture frames that can fit in a wallet or on a pendant for mobile photo display, a\ntask that a PDA can handle easily,<br />\n\n<br />\n\n Perhaps, beyond the PIM features, PDAs have simply suffered from the jack-of-all-trades problem. Take TapWave, for\nexample, which produces the Palm OS-based Zodiac handheld showed initial promise. Its hardware&#8217;s aesthetics could pass\nfor a PSP prototype. Its pure pixel-pushing power, though, while outstanding for a PDA, certainly won&#8217;t compare\nfavorably to a PlayStation Portable that will retail for significantly less, Tapwave is now looking to reposition the\ndevice toward multimedia such as video applications.<br />\n\n<br />\n\n But the PSP itself is quite adept at handling multiple kinds of media. If it succeeds in that role, PalmOne may wind\nup looking like Xerox &ndash; a company that pioneered but ultimately could not capitalize on its innovations.</p>\n<br />\n\n \n<hr size=\"2\" width=\"100%\" />\n<em>Ross Rubin is director of industry analysis at <a href=\"http://www.npdtechworld.com/\">NPD Techworld</a>, a division\nof market research and analysis provider The NPD Group. Views expressed in Switched On, however, are his own. Feedback\nis welcome at <a href=\"mailto:fliptheswitch@gmail.com\">fliptheswitch@gmail.com</a>.</em><br />\n\n\n',NULL,'','http://www.engadget.com/entry/1234000203031026/','2005-02-10 22:30:12'),
 (211,3,'http://www.engadget.com/entry/1234000433030976/','Brondell to take on Toto in techtoilet tackle','<a href=\"http://www.brondell.com/\"><img alt=\"Brondell toilet seat\"\nsrc=\"http://www.weblogsinc.com/common/images/8390753541817275.JPG?0.6967001766671111\" align=\"right\" border=\"1\"\nheight=\"200\" hspace=\"4\" vspace=\"16\" width=\"180\" /></a> \n\n<p>Like so many other <a href=\"http://www.engadget.com/entry/3341459602524447/\">imports</a> that just haven&#8217;t been able\nto break America, <a href=\"http://www.engadget.com/search/?q=toto\">Toto</a> ever remains on the list of companies we\nprobably won&#8217;t ever see selling well&#8212;enter the Swash (400/600) by Brondell, a Toto Washlet workalike (you know the\nWashlet, it&#8217;s kind of like a mini-bidet) with a heated seat and mechanical opening/closing mechanism to handle all your\n&#8220;posterior &amp; feminine wash[ing]&#8221; needs. Did we mention this\n<a href=\"http://www.engadget.com/search/?q=toilet&amp;submit=Go\">toilet accessory</a> was created by ex-Spinner.com\nfounder David Samuel? (As if that will change your opinion.)<br />\n\n<br />\n\n [Via\n<a href=\"http://sfgate.com/cgi-bin/article.cgi?file=/chronicle/archive/2005/02/07/BUGN9B65931.DTL&amp;type=business\">SFgate</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000433030976/','2005-02-10 22:30:12');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (212,3,'http://www.engadget.com/entry/1234000603030663/','The iDisk II 120x, the world\'s smallest 8GB USB flash drive','<a href=\"http://www.akibalive.com/archives/000593.html\"><img alt=\"Pretec 8GB usb drive\"\nsrc=\"http://www.weblogsinc.com/common/images/5214445910043188.jpg?0.0073818624811994304\" align=\"right\" border=\"0\"\nheight=\"51\" hspace=\"4\" vspace=\"16\" width=\"200\" /></a> \n\n<p>When you think about it, the really amazing thing about Pretec&#8217;s iDisk II 120x, which Solid Alliance (who is selling\nit in Japan) claims is the &#8220;world&#8217;s smallest 8GB flash memory drive&#8221; is that it just looks like any regular old USB\nflash drive. Just don&#8217;t go losing it like any regular old USB flash drive.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000603030663/','2005-02-10 22:30:12'),
 (213,3,'http://www.engadget.com/entry/1234000317030550/','Siemens SK65 review','<img alt=\"Siemens SK65 small review\"\nsrc=\"http://www.weblogsinc.com/common/images/3870978221142866.JPG?0.47551401541904337\" align=\"right\" border=\"1\"\nheight=\"205\" hspace=\"4\" vspace=\"16\" width=\"200\" /> \n\n<p><a href=\"http://www.engadget.com/search/?q=siemens\">Siemens</a> turned some heads (pun sort of intended) last year\nwith their announcement of their <a href=\"http://www.engadget.com/entry/1365040950537038/\">SK65</a>, a pretty radical\nform factor departure from the regular QWERTY keyboard-equipped mobile communicators out there. And what&#8217;s more, they\nproduced a version with BlackBerry Built-In (a fancy way of saying it&#8217;s got a bunch of BlackBerry software, and runs\nwith BlackBerry servers and services). But, as you may have heard, Siemens&#8217;s cellphone business at home and abroad has\nbeen <a href=\"http://www.engadget.com/entry/1234000757029388/\">languishing lately</a>, and there was some concern that\nthe SK65 might never get produced in any large number. And would you know what? We got our greedy little mitts on one\nand gave it the once over&#8212;click on to read what we think!</p>\n\n\n<br />\n\n <img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/9659091566711866.JPG?0.13972900885912332\"\nalign=\"top\" border=\"1\" height=\"440\" hspace=\"4\" vspace=\"4\" width=\"430\" /><strong><br />\n\n The specs</strong><br />\n\n <br />\n\n \n\n<p>So let&#8217;s get down to the nitty gritty; here are the essential specs you&#8217;re going to need on this thing:</p>\n\n\n<ul>\n  <li>2-inch 132x176 pixel 65k color TFT LCD screen</li>\n\n  <li>Tri-band GSM/GPRS</li>\n\n  <li>Full QWERTY keyboard (in our case, AZERTY, the Euro version of the same)</li>\n\n  <li>Bluetooth</li>\n\n  <li>MPEG4, H.263 playback</li>\n\n  <li>Up to 250/5 hours standby/talk time<br />\n</li>\n</ul>\n\n\n<p><img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/3970988221142865.JPG?0.5541167972725249\"\nalign=\"top\" border=\"1\" height=\"299\" hspace=\"4\" vspace=\"4\" width=\"430\" /><br />\n\n Twist and shout! (Sorry, we couldn&#8217;t resist.)</p>\n\n\n<p><img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/7312176086574065.JPG?0.831450721863118\"\nalign=\"top\" border=\"1\" height=\"468\" hspace=\"4\" vspace=\"4\" width=\"430\" /><br />\n\n Quite a bit larger than the hefty little MPx220</p>\n<strong>The phone and its feel</strong><br />\n\n <br />\n\n \n\n<p>When we first saw the press shots back in August last year, we were just as awestruck and impressed with the SK65&#8217;s\ninnovative design as anyone. But having one around the office, the reality sunk in pretty quickly&#8212;it&#8217;s a pretty\nfreaking big candybar when it&#8217;s not twisted open, and when it <em>is</em> open you&#8217;ve got a whole lot of phone both\nvertically and horizontally, which makes the tinyness of its 2-inch screen only that much more acute.<br />\n\n<br />\n\n We will be the first to admit that the device feels very brawny and sturdily built without feeling too weighty. Its\nhinge is definitely built for heavy use, but the positives end here. The keys on the front feel like they may pop out\nat any given moment, and what&#8217;s more, its defining feature&#8212;the QWERTY keyboard&#8212;wasn&#8217;t even that much of a pleasure to\nuse. You&#8217;d think with all that horizontal space they&#8217;d venture to make the keys horizontally oriented (being that the\nthumb&#8217;s orientation in-grip is horizontal here), but they went with vertical (part of the same problem that makes the\n<a href=\"http://www.engadget.com/entry/1234000717026048/\">Samsung i730</a>&#8217;s keyboard so difficult to use). Good on\nthem for making those keys reasonably large, but they just weren&#8217;t that easy to type on&#8212;the tactile marks on the F and\nJ keys were too thin to help orient the thumbs, and the vertical ridges on the keys were confusing to the touch. In\nother words, don&#8217;t expect to soon type without looking on this thing. And yes, we type on our QWERTY-cellphones without\nlooking.<br />\n\n<br />\n\n We might also mention that this design may also be a bit intrusive for the turbo-thumb tapping typers out there (you\nknow who you are). Those who thumb-type quickly on their keyboard often cross one thumb over to the other thumb&#8217;s side\nif it will be faster to hit a key in succession. With the screen between the two halves of the keyboard (just like in\nthe <a href=\"http://www.engadget.com/search/?q=nokia+68&amp;submit=Go\">Nokia 6800-series</a>) you&#8217;re prevented from\n&#8220;crossing over&#8221;.<br />\n\n <img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/4348125256845547.JPG?0.6234934290321165\"\nalign=\"top\" border=\"1\" height=\"408\" hspace=\"4\" vspace=\"4\" width=\"430\" /><img alt=\"Siemens SK65 review\"\nsrc=\"http://www.weblogsinc.com/common/images/3856532431928408.JPG?0.4329511906838963\" align=\"top\" border=\"1\"\nheight=\"408\" hspace=\"4\" vspace=\"4\" width=\"430\" /><br />\n\n Believe it or not, that SIM is damned near impossible to get out. Thanks Siemens.<br />\n\n<br />\n\n <strong>The software</strong><br />\n\n<br />\n\n It didn&#8217;t take long playing around with Siemens&#8217;s proprietary OS before you could tell a couple things; first, it\nwasn&#8217;t very well laid out. Its three softkeys were poorly placed&#8212;attached to the call and hang-up/cancel/back\nbuttons&#8212;and poorly used in the system. On the by and by, the interface was less than intuitive, and not to terribly\neasy on the eyes, since that low resolution causes some severely aliased icons. Those familiar with BlackBerrys will\nget the general gist of things as the nav layout is somewhat similar, but you won&#8217;t hear us claiming that it&#8217;s anywhere\nnear as straight-forward.<br />\n\n<br />\n\n Siemens did include a few value-adds that made the phone a little easier to swallow, like a unit converter, file\nsystem manager, themes, and even a European survival dictionary, but the real winner here is clearly the BlackBerry\nBuilt-In.<br />\n\n<br />\n\n To its credit, the device can play back MPEG4, and H.263, but you won&#8217;t care very much about that with no media slot\nand a miniscule amount of internal memory; we&#8217;re left wondering why they even bothered adding support for the\ncodecs.<br />\n\n<br />\n\n <img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/2128125357167771.JPG?0.46490397950834506\"\nalign=\"top\" border=\"1\" height=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><img alt=\"Siemens SK65 review\"\nsrc=\"http://www.weblogsinc.com/common/images/6436656122255311.JPG?0.410557536651305\" align=\"top\" border=\"1\"\nheight=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><br />\n\n Who thinks to actually bother making you confirm a power on?</p>\n\n\n<p><img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/2982223788833078.JPG?0.9372168417678379\"\nalign=\"top\" border=\"1\" height=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><img alt=\"Siemens SK65 review\"\nsrc=\"http://www.weblogsinc.com/common/images/8413298218797398.JPG?0.17189390507613145\" align=\"top\" border=\"1\"\nheight=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><br />\n\n You&#8217;ll be seeing that screen on the left quite some bit in 3-minute intervals.<br />\n\n <img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/4475937625971248.JPG?0.5827337746385098\"\nalign=\"top\" border=\"1\" height=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><img alt=\"Siemens SK65 review\"\nsrc=\"http://www.weblogsinc.com/common/images/8288631317563729.JPG?0.35837701713540837\" align=\"top\" border=\"1\"\nheight=\"266\" hspace=\"4\" vspace=\"4\" width=\"200\" /><br />\n\n Email search and mail client options.<br />\n\n<br />\n\n <strong>Conclusion</strong><br />\n\n<br />\n\n If you are one of the few who have an SK65, you&#8217;re almost undoubtedly not an American (unless you&#8217;re sitting on\nSiemens&#8217; board of directors)&#8212;but you shouldn&#8217;t worry too much about that. Suffice it to say, we just don&#8217;t have very\nmuch postive to say about the device; when it showed up, we really wanted to fall in love. And it does feel solid ( the\nhinge is built <em>very</em> well), but outside that, the screen, interface, graphics, and keyboard are severely\nlacking. If you find yourself in a position to drop whatever the asking price is for one of these (right now anywhere\nbetween $500 and a g, we hear) we humbly suggest you pass and plunk down for something a little more realistic, like a\n<a href=\"http://www.engadget.com/entry/6281966886574165/\">Treo 650</a> or maybe waiting for HP&#8217;s new\n<a href=\"http://www.engadget.com/entry/1234000913030286/\">hw6500 iPAQ Mobile Communicator</a>.<br />\n\n<br />\n\n <img alt=\"Siemens SK65 review\" src=\"http://www.weblogsinc.com/common/images/0646544776586300.JPG?0.4943786487189473\"\nalign=\"top\" border=\"1\" height=\"557\" hspace=\"4\" vspace=\"4\" width=\"430\" /></p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000317030550/','2005-02-10 22:30:12'),
 (214,3,'http://www.engadget.com/entry/1234000180030954/','Sony\'s new HS75, HS75P, HS95, and HS95P X-black monitors','<a href=\"http://www.sony.co.uk/PageView.do?site=odw_en_GB&amp;page=ProductSeriesHome&amp;section=en_GB_Products&amp;productcategory=%2FComputing%2FComputer+Displays%2FFlatpanel+LCD\">\n<img alt=\"Sony HS monitor\" src=\"http://www.weblogsinc.com/common/images/7821594493861350.JPG?0.781967734843245\"\nalign=\"right\" border=\"0\" height=\"204\" hspace=\"4\" vspace=\"16\" width=\"205\" /></a> \n\n<p>Looks like Sony&#8217;s updated their X-brite (aka X-black)\n<a href=\"http://www.engadget.com/entry/0401742327562628/\">equipped</a>\n<a href=\"http://www.engadget.com/entry/3733175641895053/\">HS lineup</a> of LCD monitors with new stylings a little more\nreminiscent of their recently released <a href=\"http://\">VAIO V-series</a> PCs; their new SDM-HS75, SDM-HS95,\nSDM-HS75P, and SDM-HS95P monitors are, unfortunately, near-standard aspect ratio (5:4) with mere SXGA (1280x1024)\nresolutions on both their respective 17 and 19-inch sizes. The 17 and 19-inch Premium models (the two with the P at the\nend) have 600:1 and 1000:1 contrast ratios compared to their 500:1 standard counterparts, though, and all models come\nwith DVI and analog inputs. We&#8217;re still not huge on the fixed height/angle part though, but with a screen that pretty,\nwe&#8217;re gonna try and hold our tongues.<br />\n\n<br />\n\n [Via <a href=\"http://www.biosmagazine.co.uk/article.php?id=1448\">BIOS</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000180030954/','2005-02-10 22:30:13');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (215,3,'http://www.engadget.com/entry/1234000457030960/','Apple rebuffs Sirius on satellite radio iPod','<a href=\"http://money.cnn.com/2005/02/09/news/midcaps/sirius_ipod/index.htm\"><img height=\"170\" alt=\"4G iPod\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/1523176874342620.jpg?0.4101608894065282\" width=\"100\" align=\"right\"\nvspace=\"16\" border=\"0\" /></a> \n\n<p>Remember all those crazy rumors from a couple of months ago that\n<a href=\"http://www.engadget.com/entry/1234000547022729/\">Apple and Sirius were teaming up on some sort of iPod with a\nbuilt-in satellite radio receiver</a>? Seemed a little dubious at the time (simply cramming a Sirius chipset into an\niPod in the first place would be the opposite of easy), but now we know why everyone was gossiping in the first place.\nSirius prez Mel Karmazin admitted during a talk at a media conference yesterday that he had approached Steve Jobs about\nadding Sirius to the iPod and found no love. In Mel&#8217;s words: the &#8220;current thinking&#8221; at Apple is that &#8220;they don&#8217;t need\nto put satellite radio in their box.&#8221;<br />\n\n<br />\n\n[Thanks everyone who sent this one in]</p>\n<br />\n\n<br />\n\n\n',NULL,'','http://www.engadget.com/entry/1234000457030960/','2005-02-10 22:30:13'),
 (216,3,'http://www.engadget.com/entry/1234000023030798/','Shuttle\'s SB86i i-Series','<p style=\"text-align: left;\"><a href=\"http://global.shuttle.com/Product/Barebone/SB86i.asp\"><img alt=\"Shuttle SB86i\"\nsrc=\"http://www.weblogsinc.com/common/images/0028359724857893.JPG?0.88966541380429\" align=\"right\" border=\"1\"\nheight=\"182\" hspace=\"4\" vspace=\"16\" width=\"230\" /></a>You know\n<a href=\"http://www.engadget.com/search/?q=shuttle&amp;submit=Go\">Shuttle</a>, they&#8217;ve been working the\n<a href=\"http://www.engadget.com/search/?q=sff\">SFF PC</a> angle to great effect the last couple years, and their new\nSB86i i-Series chassis is definitely the icing on the cake. We&#8217;re not going to rehash the whole will the Mac mini\n<a href=\"http://www.engadget.com/entry/1234000093029216/\">change the way we look at PCs</a> thing again, but we will\ngaze upon this cute little box lustfully; remember, you can&#8217;t expect solid gold since they really only do the barebones\nPC thing, but if you&#8217;re down with the <a href=\"http://www.engadget.com/search/?q=btx&amp;submit=Go\">BTX</a>, this guy\nbrings PCI-Express, SATA RAID, 4 USB 2.0 ports, 2 1394 ports, an 8-in-1 card reader, Gigabit Ethernet, and 7.1-channel\nsurround to the table, just in case you want to make it your new budget Media Center PC. Which we most certainly\ndo.<br />\n\n<br />\n\n [Via <a href=\"http://www.firstadopter.com/fa/archives/000640.html\">FirstAdoptor</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000023030798/','2005-02-10 22:30:13');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (217,3,'http://www.engadget.com/entry/1234000840030941/','Firefly emergency cellphone for kids','<a href=\"http://www.suncom.com/equipment/Firefly.shtml\"><img height=\"167\" alt=\"Firefly\" hspace=\"4\"\nsrc=\"http://www.weblogsinc.com/common/images/5452460712523346.JPG?0.5189000147999504\" width=\"90\" align=\"right\"\nvspace=\"16\" border=\"1\" /></a> \n\n<p>We&#8217;re pretty sure within a few years nary an American adult worth their weight in salt (or soccer balls) will be\nsatisfied until every family member has some time of cellular device, from\n<a href=\"http://www.engadget.com/search/?q=elderly+cell&amp;submit=Go\">grams and gramps</a> to their\n<a href=\"http://www.engadget.com/search/?q=kid+cell&amp;submit=Go\">pre-pubescent little darlings</a>. A little less\nnovelty and a little more sombre than the <a href=\"http://www.engadget.com/entry/3092323777711756/\">MyMo kids&#8217;</a>\n<a href=\"http://www.engadget.com/entry/1234000403027045/\">cellphone</a>, the decidedly more advanced GSM-roaming\nFirefly has a screen (that&#8217;s a plus), dedicated mom and dad call buttons, a 20-number phonebook, a backpack hook, and,\nof course, a 911 button. Of course, we&#8217;d be a bit concerned about that 911 button getting triggered at such inopportune\ntime as, well, any time it&#8217;s not intended, but we remain hopeful they&#8217;ve 8-12-year old-proofed it sufficiently.<br />\n\n<br />\n\n[Thanks, Mr. Yuk]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000840030941/','2005-02-10 22:30:13'),
 (218,3,'http://www.engadget.com/entry/1234000423030935/','The USB-powered piezo negative ionizer','<a href=\"http://www.thanko.jp/EPI585.html\"><img alt=\"Thanko USB-powered piezo negative ionizer\"\nsrc=\"http://www.weblogsinc.com/common/images/7302177097685276.JPG?0.7891357794146154\" align=\"right\" border=\"1\"\nheight=\"176\" hspace=\"4\" vspace=\"16\" width=\"230\" /></a>\n\n<p>They call it aeroionotherapy&#8212;some believe in it, some don&#8217;t&#8212;and it&#8217;s supposed to relieve you&nbsp; of\nrestlessness, anxiousness, depression, and high blood pressure if you charge the air in a room with negatively charged\nions. We&#8217;re not calling BS&#8212;you can judge for yourself whether it&#8217;s quack medicine&#8212;but if you&#8217;re a believer, it might\ninterest you to know that the EPI585 generates 5 million negative ions per cc via USB. And who do we have to thank for\nthis brilliant invention? None other than <a href=\"http://www.engadget.com/search/?q=thanko\">Thanko</a>, of course,\npurveyor of wacked out <a href=\"http://www.engadget.com/search/?q=usb+power&amp;submit=Go\">USB-powered</a> gadgets\nforever and ever.<br />\n\n<br />\n\n[Via <a href=\"http://\">AkihabaraNews</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000423030935/','2005-02-10 22:30:13');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (219,3,'http://www.engadget.com/entry/1234000413030931/','iSpy, the Smartphone motion detector','<a href=\"http://www.mpx200.org/forums/index.php?s=fe3b3ad9e26896055eaf48d4ce88dcda&amp;showtopic=7152\"><img alt=\"iSpy app\"\n     src=\"http://www.weblogsinc.com/common/images/4215667345601867.JPG?0.8970109101485263\" align=\"right\" border=\"1\"\n     height=\"220\" hspace=\"4\" vspace=\"16\" width=\"176\" /></a> \n\n<p>We don&#8217;t even know where to start with this one, but if you&#8217;re an up-and-coming spy whose\n<a href=\"http://www.engadget.com/search/?q=spy&amp;submit=Go\">gear department</a> is facing budget cutbacks (hey, whose\nisn&#8217;t these days?) then maybe you can get your Q of sorts to invest in iSpy, an apparently rudimentary\n<a href=\"http://www.engadget.com/search/?q=smartphone\">Smartphone</a> app that compares images at intervals from your\ncameraphone&#8212;if the image changes, an alarm is sounded. So let&#8217;s get this straight. You&#8217;re leaving your phone out in the\nopen to spy on people, and when it detects a change in its field of vision, it makes a noise. &#8220;Someone stole my phone\non a mission, Miss Monnypenny.&#8221;<br />\n\n<br />\n\n [Via <a href=\"http://www.smartphonethoughts.com/index.php?action=expand,7550\">SmartphoneThoughts</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000413030931/','2005-02-10 22:30:13'),
 (220,3,'http://www.engadget.com/entry/1234000730030929/','\"Companion\" scanner makes grocery shopping easier for elderly','<a href=\"http://news.bbc.co.uk/2/hi/uk_news/england/bristol/somerset/4243111.stm\"><img height=\"152\" alt=\"Companion\"\nhspace=\"4\" src=\"http://www.weblogsinc.com/common/images/7166386751884829.JPG?0.1214499710891207\" width=\"203\"\nalign=\"right\" vspace=\"16\" border=\"0\" /></a> \n\n<p>The BBC has a piece on a joint project between the Bristol City Council, Brunel University and Somerfield\nsupermarket that is aiming to help the elderly do their grocery shopping from home.&nbsp; The &#8220;Companion&#8221; is just a\nbarcode reader that senior citizens use to scan items from a catalogue or straight from the cans, it then automatically\nplaces an order to the supermarket through a phone line (think of it as CueCat for people who might actually use\nit).&nbsp; The project is currently in a trial stage with about a dozen people that will run until July, and there&#8217;s no\nword on when the system might actually be rolled out.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000730030929/','2005-02-10 22:30:13');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (221,3,'http://www.engadget.com/entry/1234000667030930/','Mitsubishi\'s PocketProjector','<a href=\"http://www.chait.net/index.php?p=572&amp;page=2\"><img alt=\"Mitsubishi PocketProjector\"\nsrc=\"http://www.weblogsinc.com/common/images/3746419218685164.JPG?0.9690184877728583\" align=\"top\" border=\"1\"\nheight=\"284\" hspace=\"4\" vspace=\"4\" width=\"425\" /></a><br />\n\n\n<p>Maybe barely pocketable if you&#8217;re rocking the XXXL cargo pants, Mitsubishi just announced the PocketProjector, a\ntiny DLP projector that weighs just 14 ounces and has a resolution of 800x600 (which is plenty good for all your\nnon-high def needs). Should be out in July with a retail price of $699.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000667030930/','2005-02-10 22:30:13'),
 (222,3,'http://www.engadget.com/entry/1234000247031233/','Fujitsu N-3500 laptop with \"CRT-quality\" display','<p><img alt=\"fujitsu lifebook n3500\"\nsrc=\"http://www.weblogsinc.com/common/images/0760112677722978.jpg?0.8751816951114685\" align=\"right\" border=\"0\"\nheight=\"132\" hspace=\"4\" vspace=\"16\" width=\"181\" />Despite the fact that pretty much the whole world has switched from\nCRTs to LCD displays, if you&#8217;re a purist about color, you&#8217;ve probably got at least one CRT around, and chances are it&#8217;s\na midrange model like LaCie&#8217;s $800 ElectronBlue IV or a higher-end one like the NEC-Mitsubishi screens that can go for\nas much as $5,000. So, when Fujitsu claims that the LCD on its new LifeBook N3500 &#8220;rivals CRT displays,&#8221; we&#8217;re a little\ndubious, particularly since this is a consumer model that goes for as little as $1,499 in a basic configuration. And\nthat, of course, is the kicker. For consumers looking for a decent gaming, surfing, DVD-viewing and basic photo-editing\nbox, this may be as close to CRT-quality as necessary. But for professional needs, it probably still has a ways to\ngo.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000247031233/','2005-02-11 08:29:51'),
 (223,3,'http://www.engadget.com/entry/1234000677031204/','Plantronics MX-100s cellphone headset/audio earphone combo','<img alt=\"plantronics mx-100s\" src=\"http://www.weblogsinc.com/common/images/7277407862895831.jpg?0.4571952058860377\"\nalign=\"right\" border=\"1\" height=\"125\" hspace=\"4\" vspace=\"16\" width=\"125\" /> \n\n<p>If you spend a lot of time listening to music on a portable audio player, and also spend a fair amount of time on\nthe cellphone, you&#8217;ve probably dealt with the headset swap. You know, it&#8217;s when you&#8217;re in the middle of rocking out and\nyour phone vibrates (after all, you&#8217;re not going to hear it ring). You either frantically switch headsets or yank your\nheadset off, just in time to discover that the call&#8217;s rolled over to voicemail already (either that, or it&#8217;s someone\nyou really don&#8217;t want to speak to). You could do what we do and just let the voicemail pick up anyhow, or you could\npick up the new Plantronics MX-100-s combo. As you may have guessed by now, it&#8217;s a single set of earbuds that works\nboth as a cellphone headset and stereo phones for a portable audio player. Plantronics is pitching this as an iPod\naccessory &#8212; it comes in the obligatory white plastic, can be bought at Apple stores, and presumably sports one of those\nsnazzy new &#8220;<a href=\"http://www.engadget.com/entry/1234000543027232/\">Made For iPod</a>&#8221; stickers. Needless to say, it\nshould work with any audio player. While we think this is a step in the right direction, it&#8217;s still a tangle of wires,\nespecially if you&#8217;re used to keeping your phone and audio player in separate pockets. The dual jacks on this thing mean\nthey&#8217;re joined at the hip &#8212; your hip, if that&#8217;s where you stash your gear. What we really want is a version of this\nthat does <a href=\"http://www.engadget.com/entry/1234000823030675/\">Bluetooth</a>. But somehow we don&#8217;t expect to find\nthat for $40, which is what this goes for.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000677031204/','2005-02-11 08:29:51');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (224,3,'http://www.engadget.com/entry/1234000960031206/','Voom = Not dead yet?','<a href=\"http://www.forbes.com/feeds/ap/2005/02/10/ap1820437.html\"><img alt=\"Voom\"\nsrc=\"http://www.weblogsinc.com/common/images/3868755887686398.jpg?0.7498072575469006\" align=\"right\" border=\"0\"\nheight=\"109\" hspace=\"4\" vspace=\"16\" width=\"282\" /></a> \n\n<p>Cablevision <a href=\"http://www.engadget.com/entry/1234000303028426/\">selling their satellite to Echostar sorta put\nthe hurt on them</a>, but is there a chance that high-definition satellite service Voom might bounce back? Cablevision\nfounder and Chairman Charles Dolan wasn&#8217;t too happy about selling off the Voom satellite in the first place (his board\nof directors forced the sale on him), but now he&#8217;s trying to buy Voom&#8217;s remaining assets (like its 26,000 subscribers\nand licenses to its 21 channels) so he can form a new private venture to keep it going. How irrationally in love with\nVoom must this guy be? His company ditches it, but he is so unable to let go that he&#8217;s basically doing everything he\ncan to keep Voom alive. He&#8217;s probably just going to end up losing a lot of his own money this time around (it&#8217;s\nestimated that Voom has already lost a billion dollars), but you gotta admire his dedication.<br />\n\n<br />\n\n [Thanks, Jim]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000960031206/','2005-02-11 08:29:51'),
 (225,3,'http://www.engadget.com/entry/1234000737031152/','M-Bird\'s updated XT-22 audio player drops speaker, maintains \"unique\" style','<p><img alt=\"mbird x-22\" src=\"http://www.weblogsinc.com/common/images/2871112676610755.jpg?0.5521962294707562\"\nalign=\"right\" border=\"1\" height=\"123\" hspace=\"4\" vspace=\"16\" width=\"156\" />When we checked out the\n<a href=\"http://www.engadget.com/entry/1401731295338375/\">M-Bird X-21</a> audio player last year, we commented that\nalthough it looked like it was cobbled together from spare parts of other players, the fact that it had built-in stereo\nspeakers made it a unique and possibly worthwhile product. Well, M-Bird has gone ahead and updated the unit, and the\nX-22 still sports the original&#8217;s <s>butt-ugly</s> distinctive look, but has dropped one of the speakers, making it an\naudio player with built-in mono playback, hardly a unique feature these days. Other additions to the Korea-only unit\ninclude USB 2.0 and Ogg Vorbis support, but let&#8217;s face it: you&#8217;re not buying this for what it does; you&#8217;re getting it\nfor what it looks like. Consider it the anti-iPod &#8212; instead of a sleek and shiny unit, you get something that Max\nRockatansky might have used to add some tunes to his travels.<br />\n\n<br />\n\n [Via <a href=\"http://www.dapreview.net/\">DAPreview</a>]</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000737031152/','2005-02-11 08:29:51');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (226,3,'http://www.engadget.com/entry/1234000773031137/','Nokia and RealNetworks slip deeper into bed together','<img alt=\"Nokia 7710\" src=\"http://www.weblogsinc.com/common/images/1365141061648149.jpg?0.9458682193794693\"\nalign=\"right\" border=\"0\" height=\"142\" hspace=\"4\" vspace=\"16\" width=\"240\" /> \n\n<p>Nokia and RealNetworks have announced an extension of their existing relationship.&nbsp; RealPlayer has been the\nde-facto media app on all of Nokia&#8217;s Series 60 devices (and the\n<a href=\"http://www.engadget.com/entry/2128136368270003/\">super-sweet 7710</a>, which runs Series 90) and it appears\nthese two are quite fond of each other.&nbsp; RealNetworks will make available the <a href=\"http://\">Helix DNA</a>\nmedia player, a more open media technology platform they&#8217;re evangelizing.&nbsp; The Helix DNA code should make its way\ninto Nokia handsets and will allow full support for a greater number of content formats, including 3GPP, MPEG-4, and of\ncourse RealVideo.</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000773031137/','2005-02-11 08:29:51'),
 (227,3,'http://www.engadget.com/entry/1234000990031192/','Hasbro hopes to hook America\'s youth on cellphones','<img alt=\"Hasbro ChatNow\" src=\"http://www.weblogsinc.com/common/images/1883457356723212.JPG?0.595388186391983\"\nalign=\"right\" border=\"0\" height=\"298\" hspace=\"12\" vspace=\"12\" width=\"200\" /> \n\n<p>ChatNow is the name of Hasbro&#8217;s new communication device designed for the tween (8-12) market.&nbsp; Aiming for\nthose members of America&#8217;s youth who are just a bit too young to have a cellphone (though probably not according to the\ntarget market), the ChatNow system will allow the members of Jojo&#8217;s fan-club to call or text one another using\nwalkie-talkie technology.&nbsp; Developing their device around short radio technology, Hasbro allows parents to enable\ntheir child&#8217;s communication without entering into a service contract.&nbsp; The ChatNow will include a digital camera,\n10 ringtones, text messaging ability, and last but not least, for silent call alerts&hellip;flashing lights!</p>\n\n\n',NULL,'','http://www.engadget.com/entry/1234000990031192/','2005-02-11 08:29:51');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (228,4,'http://www.docnotes.net/cat_web_technology.html','Medical Weblogs -  FAQ','The new version of Medlogs.com - The News Aggregator for Medical Topics is now oficially live.&nbsp; This entry will serve as an FAQ for the new version of the site.\n\nWhat\'s a medical weblog?A weblog is ... uh .. well, let\'s look it up in the wikipedia:&nbsp; Definition: WeblogSo now you know what a weblog is.&nbsp; What\'s a medical weblog?&nbsp; It\'s&nbsp;a weblog with a focus on medicine.&nbsp; Some medlical weblogs are by physicians .. some by people with a certain disease or condition .. some by healthcare technology workers, pharmacists, EMTs, nurses, medical students, residents .. you get the idea.A key component of personal weblogs we\'ve chosen for inculsion in Medlogs.com si that they are not devoted to selling something.&nbsp; Sure .. some of the weblogs have amazon ads or google ads on them, but the primary purpose of the site is not to generate revenue or sell somthing that generates revenue.&nbsp; If you notice that one of the sites we include IS doing this, please let us know by using the contact form on the main page.\nWhat is the history of medical weblogs?&nbsp; The first medical weblog was David Theige\'s MedEdnews.&nbsp; Inspired by Dave winer\'s Scripting News, David was an avid weblogger, and made many wonderful contributions to medical education with this resource.&nbsp; From The Internet Archive, one can see that David\'s very early work - called \"an Educator\'s Journal\"&nbsp;- goes back to December 3, 1998.&nbsp;&nbsp;Alas, David seems to have lost interest in blogging, as MedEdNews hasn\'t been updated since 2001.&nbsp;&nbsp; Also inspired by Winer, Jacob Reider\'s weblog (ok .. that\'s me .. but I sound more important in the 3rd person, don\'t I?) was first published in its current form on November 14, 1999.&nbsp;&nbsp; The sites generally followed Winer\'s style - serving as a method of sharing useful information found on the web.&nbsp;With the maturing tools, weblogs took off - as did medical weblogs.&nbsp; Steve Hoffman&nbsp;wrote the first (that I know of) non-physician medical weblog; Sydney Smith, and Dr Bob were early arrivals who remain some of the most popular webloggers .. and then (predictably) .. on came the next generation with a vengance.&nbsp; In fact, I\'m surprised that it took so long for the medical students and residents to catch on, but I think that by a few months from now the \"trainee\" weblogs will outnumber the attending physicians.&nbsp; \nHow does medlogs work?With an RSS or Atom feed, Any weblog post is available in a format that other computers can read.&nbsp; So medlogs.com asks your weblog if it has any new posts.&nbsp; We do this every 30 minutes right now.&nbsp; Someday soon, we\'ll proably accept a \"ping\" from your weblog so that we don\'t have to ask your weblog&nbsp;if you have a new post .. it will just tell us.&nbsp; Once we get this worked out on our end, we\'ll tell you how to do it on your end.&nbsp; Like most things weblog.&nbsp; It\'s easy.&nbsp; Medlogs reads all of these feeds, then organizes them in reverse chronological order.&nbsp; So the newest posts are on top.&nbsp;\nHow are medical weblogs arranged?&nbsp; We have several categories.&nbsp; If you Thingk we\'ve arranged them incorrectly, or if you thinkn one is in the wrong place, please let us know by using the contact form.\nWhy isn\'t my weblog in medlogs.com?There are usually two reasons why we don\'t have you in here.\n\nWe don\'t know about your weblog.&nbsp; Please let us know and we\'ll add you.\nYou don\'t have an RSS or ATOM feed.&nbsp; You need one for medlogs to read your weblog.&nbsp; Please read the documentation for your blogging software.&nbsp; It\'s usually a matter of turning it on.&nbsp; \nThat\'s it for now.&nbsp; I\'ll update this post as time permits.&nbsp; If you have additional questions that you think I should put in the FAQ, please let me know.','2004-05-31 21:46:47','','1805@http://www.docnotes.net/','2005-02-11 09:36:38'),
 (229,4,'http://www.docnotes.net/cat_politics.html','Primary Care jobs?','A Chance to Cut is a Chance to Cure mentions a Medical Economics article about jobs in primary care, and how Internists are (in some markets) in greater demand than family physicians. Hospital systems greater interest in Internists\"... is partly a byproduct of employers\' current focus on recruiting specialists\" according to one of the recruiters quoted in the MedEc article. \nWell .. we family physicians can be a bit .. uh .. thin-skinned about this sort of stuff, so please forgive me if I seem a bit negative about the post for a few reasons: \nI am disheartened that rather few internists are attracted to primary care.&nbsp; \nI am disheartened that some recruiters and \"hospital systems\" are drawn to Internists rather than family physicians due to a perception that Internists drive more specialty referrals. Business is business, I suppose. So if the goal of a hospital system is to drive referrals .. and increase utilization of highly reimbursed services (such as surgery), then I suppose these concepts are right on target and we all should nod our heads in agreement. \nYet I wonder if this all misses the point. Why are we providing healthcare? Is the primary goal is to earn money .. and healthcare is the market? (Just like selling cars or baseball hats or computers) .. I sure hope not. As a profession, we do what we do because we want to deliver a valuable service to the world. \nYes - we want/need to be reimbursed - or we couldn\'t sustain the service. But reimbursement isn\'t the primary goal.&nbsp; And if we consider the goals (implied, perhaps) of family physicians - I would suggest that they coincide with the healthcare needs of a community better than most other physicians. \nYet employers of physicians are sadly more interested in the financial picture than the healthcare needs of a community. \n\nThey need to build demand for their service by hiring an Internist rather than a Family Physician. Wow. \nLet\'s change a few words and see how similar that is to: \n\n\"General Motors needed to build demand for their cars by killing off public transportation. \nYeh .. I\'m streching the analogy a bit .. but .. you get the point .. is healthcare about \"increasing market segment\" or about \"meeting a community\'s healthcare needs?\" I argue that the two are inherently at odds. Physician supply and recruiting remarkably DOES change healthcare. Yet these \"market force\" decisions will hurt us far more than they will help us in the long run. We need a system where the skills of physicians trained and recruited will meet the healthcare needs of a community - not the fiscal needs of a hospital or healthcare entitiy.','2004-05-30 00:39:08','','1804@http://www.docnotes.net/','2005-02-11 09:36:38');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (230,4,'http://www.docnotes.net/cat_obstetrics.html','Epidural analgesia and c-section rates','From BMJ this week: \n\nEpidural analgesia using low concentration infusions of bupivacaine is unlikely to increase the risk of caesarean section but may increase the risk of instrumental vaginal delivery. Although women receiving epidural analgesia had a longer second stage of labour, they had better pain relief. \nMy partner delivered a baby this week and struggled with 2nd stage so much that she ended up cutting an episiotomy and applying a vacuum and a consequence was&nbsp;a 4th degree tear.&nbsp; Last month, I cut the 2nd episiotomy of my lifetime and we had to fix a 3rd degree tear (one of only a handful I\'ve been involved with).&nbsp; Common theme?&nbsp; Epidural analgesia.&nbsp; \nI struggle with this often.&nbsp; On one hand .. epidurals are wonderful adjuncts to the care that we can provide to women in labor.&nbsp; The expoerience can be transformed from a lengthy, horrible experience to uncomfortable and tolerable.&nbsp; Yes, yes .. I\'ll never know.&nbsp; I will never have a baby and so .. my perspective is inherently different from those who have HAD the experience.&nbsp; My life with back pain has certainly made me more sensitive to my patients with back pain .. and perhaps I would not be so hesitant to embrace universal epidurals if I had really experience the pains of labor.\nYet here we are.&nbsp; Epidurals can enhance the likelihood of instrumental delivery and therefore complications.&nbsp; Like most things in medicine .. there is not an easy answer here.&nbsp; We need to make careful, thoughtful decisions.&nbsp;','2004-05-29 10:44:02','','1803@http://www.docnotes.net/','2005-02-11 09:36:38'),
 (231,4,'http://www.docnotes.net/cat_medical_education.html','The 12 types of medical students','Discovered today on medlogs: This is very funny (and accurate too!)','2004-05-28 02:04:48','','1801@http://www.docnotes.net/','2005-02-11 09:36:38');
INSERT INTO `entry` (`id`,`fk_channel_id`,`url`,`title`,`body`,`authored_on`,`authored_by`,`guid`,`retrieved_on`) VALUES 
 (232,4,'','Graduation, free e- MDs medication database, evening hours','&nbsp;\nAn unusally long day .. but productive .. which is much better than a short unproductive day.\n\nThe Medical School &nbsp;graduation was today.&nbsp; This is the view from the stage .. where I was sitting .. 3rd row.&nbsp; Can\'t pick your nose when you are sitting on the stage.&nbsp; I wore my suit and tie.&nbsp; Was very well behaved and even got kinda wistful&nbsp;watching these new young physicians stepping into their careers.&nbsp; The speaker was Joseph Goldstein, who gave a nice short talk on the changing face of medicine today.&nbsp; His message:&nbsp; Genes are the future of medicine.&nbsp; I didn\'t know as many of the students in this class as I had others.&nbsp; I\'m not one for ceremony or tradition ... but this sort of event is meaningful to me: a recognition of four years of extremely hard work, and the true birthing of a herd of healers/helpers etc.&nbsp; \nOffice hours tonight were uneventful and kinda fun.&nbsp; We had a first year medical student shadowing me and it was refreshing to see the novelty of family medicine through her eyes.&nbsp; We had two patients who were here with concerns about possible lyme disease.&nbsp; the first turned out to be&nbsp;a \"textbook\" case of pityriasis rosea, and the second was cellulitis of the butt.&nbsp; We froze some skin tags, treated a UTI (and learned the reason for the term \"honeymoon cystitis\") and did a few well-child visits, mixed in with a few other new adult patients and a post-partum visit.&nbsp;She was struck with how easily I brought up the part of the social hisotry that rhymes with \"hex\" .. and how easily I asked about same-sex relationships.&nbsp; \"Just be matter-of-fact\" I said.Nothing is hard to talk about if you are not judgemental about it ... and I don\'t mean \"don\'t act judgemental\"&nbsp; I really mean .. don\'t be judgemental.&nbsp; This is easier for me with sexuality and other \"challenging\" topics .. and much harder for me with obesity and smoking and \"bad habits\" in general.\nStaying here at the office late to take care of the large pile of papers and patient messages.&nbsp; I got a bit behind on these last week .. and it takes a late night like this to really catch up.\ne-MDs is giving away its medication database.&nbsp; Hmm&nbsp; I wonder if NAPCI should try to distribute it&nbsp;... Multum will also give it away ... but not for commercial use.&nbsp; The Multum Lexicon Guide, BTW, is a wonderful resource.&nbsp; A must-read for anyine interested inhealther informatics... back to the charts ...','2004-05-28 01:24:26','','1800@http://www.docnotes.net/','2005-02-11 09:36:38');
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT;
SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS;
SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
