<cfcomponent displayName="Soundings" hint="Core CFC for the application. Main purpose is to handle settings." output="false">

	<cffunction name="getSettings" access="public" returnType="struct" output="false"
				hint="Returns application settings as a structure.">
		
		<!--- load the settings from the ini file --->
		<cfset var settingsFile = replace(getDirectoryFromPath(getCurrentTemplatePath()),"\","/","all") & "/settings.ini">
		<cfset var iniData = getProfileSections(settingsFile)>
		<cfset var r = structNew()>
		<cfset var key = "">
		
		<cfloop index="key" list="#iniData.settings#">
			<cfset r[key] = getProfileString(settingsFile,"settings",key)>
		</cfloop>
		
		<cfreturn r>
		
	</cffunction>
	
	<cffunction name="setPassword" access="public" returnType="void" output="false" roles="surveyadmin"
				hint="Updates the password">
		<cfargument name="password" type="string" required="true" hint="Hashed version of password.">
		<cfset var settingsFile = replace(getDirectoryFromPath(getCurrentTemplatePath()),"\","/","all") & "/settings.ini">

		<cfset setProfileString(settingsFile,"settings","password",arguments.password)>
	</cffunction>
	
</cfcomponent>