/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.adobe.ac
{
	import mx.core.Application;
	import mx.core.UIComponent;
   
	public class Observer 
	{
		protected var isHandlerInitialized : Boolean = false;
		protected var isSourceInitialized : Boolean = false;
		
		public function get handler() : Function
		{
			return null;
		}
  
		public function get source() : Object
		{
			return null;
		}
		
		public function execute( method : Function, ...params : Array ) : Object
		{
			var returnValue : Object;
			try
			{
				returnValue = method.apply( null, params );
			}
			catch( e : Error )
			{
				delay( e );
			}
			return returnValue;
		}
			
		protected function callHandler() : void
		{
			try
			{
				handler.call( null, source );
			}
			catch( e : Error )
			{
				delay( e );
			}
		}
   
		protected function delay( e : Error ) : void
		{
			UIComponent( Application.application ).callLater( throwException, [ e ] );
		}
   
		private function throwException( e : Error ) : void
		{
			throw e;
		}
	}
}