<cfsetting enablecfoutputonly="true" showdebugoutput="false">

<cfset request.mashed.mode = "galleon" />

<!---
	Name         : Application.cfm
	Author       : Raymond Camden 
	Created      : June 01, 2004
	Last Updated : May 1, 2007
	History      : Don't load app.cfc, load galleon.cfc. Also pass settings to messages. (rkc 7/14/05)
				   Make app name dynamic. Remove mapping (rkc 8/27/05)
				   Support for sorting, errors (rkc 9/15/05)
				   Better admin check, logout fix (rkc 7/12/06)
				   Even better admin check, really (rkc 7/18/06)
				   BD fix, attachment folder (rkc 11/3/06)
				   Fix for getting attachment dir (rkc 11/16/06)
				   Use Factory (thanks Rob Gonda) (rkc 2/21/07)
				   case fix for the factory (rkc 5/1/07)
	Purpose		 : 
--->

<!---
<cfset appName = "modelglue.com">
<cfset prefix = getCurrentTemplatePath()>
<cfset prefix = reReplace(prefix, "[^a-zA-Z]","","all")>
<cfset prefix = right(prefix, 64 - len(appName))>
--->

<cfapplication name="model_glue_com" sessionManagement=true loginstorage="session">

<!---
BD wants error.cfm to be relative when the app.cfm is run inside the admin
folder. See: http://ray.camdenfamily.com/index.cfm/2005/9/21/Galleon-Issue-with-BlueDragon
--->
<cfif server.coldfusion.productname is "BlueDragon">
	<cfif findNoCase("/admin", cgi.script_name)>
	   <cferror type="exception" template="../error.cfm">
	<cfelse>
	   <cferror type="exception" template="error.cfm">
	</cfif>
<cfelse>
	<cferror type="exception" template="error.cfm">
</cfif>

<cfif not isDefined("application.galleon.init") or isDefined("url.reinit")>
	<cfset application.galleon = structNew() />
	
	<cfset structDelete(application.galleon, "userCache")>

	<!--- get user CFC --->
	<cfset application.galleon.factory = createObject("component","cfcs.objectfactory").init()>
	
	<!--- Get main settings --->
	<cfset application.galleon.settings = application.galleon.factory.get('galleonSettings').getSettings()>

	<cfset application.galleon.settings.attachmentdir = getDirectoryFromPath(getCurrentTemplatePath()) & "attachments">

	<cfif not directoryExists(application.galleon.settings.attachmentdir)>
		<cfdirectory action="create" directory="#application.galleon.settings.attachmentdir#">
	</cfif>
	
	<!--- get user CFC --->
	<cfset application.galleon.user = application.galleon.factory.get('user')>

	<!--- get utils CFC --->
	<cfset application.galleon.utils = application.galleon.factory.get('utils')>
		
	<!--- get conference CFC --->
	<cfset application.galleon.conference = application.galleon.factory.get('conference')>
	
	<!--- get forum CFC --->
	<cfset application.galleon.forum = application.galleon.factory.get('forum')>

	<!--- get thread CFC --->
	<cfset application.galleon.thread = application.galleon.factory.get('thread')>

	<!--- get message CFC --->
	<cfset application.galleon.message = application.galleon.factory.get('message')>

	<!--- get rank CFC --->
	<cfset application.galleon.rank = application.galleon.factory.get('rank')>

	<cfset application.galleon.init = true>
	
</cfif>

<!--- include UDFs --->
<cfinclude template="includes/udf.cfm">

<cfif isDefined("url.logout")>
	<cfset structDelete(session, "user")>
	<cflogout>
</cfif>

<!--- handle security --->
<cflogin>
	<!--- are we trying to logon? --->
	<cfif isDefined("form.logon")>
		<cfif isDefined("form.username") and isDefined("form.password")>
			<cfif application.galleon.user.authenticate(trim(form.username), trim(form.password))>
				<!--- good logon, grab their groups --->
				<cfset mygroups = application.galleon.user.getGroupsForUser(trim(form.username))>
				<cfset session.user = application.galleon.user.getUser(trim(form.username))>		
				<cfloginuser name="#trim(form.username)#" password="#trim(form.password)#" roles="#mygroups#">
			</cfif>
		</cfif>
	</cfif>
	
</cflogin>

<!--- Used by index, forums, and threads ---->
<!--- however, if threads, default to lastpost --->
<!--- however, don't do this in the admin ;) --->
<cfif not structKeyExists(variables, "isAdmin")>
	<cfif findNoCase("threads.cfm", cgi.script_name)>
		<cfparam name="url.sort" default="lastpost">
		<cfparam name="url.sortdir" default="desc">
	<cfelse>
		<cfparam name="url.sort" default="name">
		<cfparam name="url.sortdir" default="asc">
	</cfif>
</cfif>


<cfsetting enablecfoutputonly=false>