/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/


package com.firemoss.modelglue.tags
{
	import com.firemoss.modelglue.Framework;
	import mx.controls.Alert;
	import mx.core.UIComponent;
	import mx.events.FlexEvent;
	import com.firemoss.modelglue.loader.TagBasedLoader;
	import com.firemoss.modelglue.ModelGlueFramework;
	
	public class ModelGlue extends UIComponent
	{

		//public var framework:Framework = Framework.getInstance();
		public var framework:Framework = ModelGlueFramework.framework;
		private var loader:TagBasedLoader;
		
		[ArrayElementType("com.firemoss.modelglue.tags.Controller")]
		public var controllers:Array;

		[ArrayElementType("com.firemoss.modelglue.tags.event.Handler")]
		public var eventHandlers:Array;

		public function ModelGlue() {
			this.addEventListener(FlexEvent.CREATION_COMPLETE, this.load);
			this.loader = new TagBasedLoader(this, this.framework);
		}
		
		public function load(e:FlexEvent):void {
			this.loader.load();
		}
		
	}
}