/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.service
{
	import mx.rpc.AbstractOperation;
	import mx.controls.Alert;
	import mx.rpc.AsyncToken;
	import com.firemoss.modelglue.event.ModelGlueEvent;
	import mx.rpc.IResponder;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.events.FaultEvent;
	
	public class AsynchronousOperationProxy implements IResponder
	{
		private var operation:AbstractOperation;
		private var responderObject:Object;
		
		public function AsynchronousOperationProxy(responderObject:Object, operation:AbstractOperation) {
			this.operation = operation;
			this.responderObject = responderObject;
		}
		
		public function apply(...rest):void {
			var arguments:Array = rest as Array;
			var operationArguments:Array = new Array();
			var i:int;
			var resultFunction:Function;
			var faultFunction:Function;
			var send:Function;
			var token:AsyncToken;
					
			for (i=0;i<arguments.length;i++) {
				if (arguments[i] is Function) {
					break;
				} else {
					operationArguments.push(arguments[i]);
				}
			}
			
			if (i < arguments.length) {
				resultFunction = arguments[i];
				i++;	
			}

			if (i < arguments.length) {
				faultFunction = arguments[i];
				i++;	
			}
			
			send = this.operation.send;
			
			token = send.apply(this.operation, operationArguments);
			
			token.innerResultFunction = resultFunction;
			token.innerFaultFunction = faultFunction;
			token.arguments = operationArguments;

			token.addResponder(this);			
		}
		
		/* IResponder Implementation */
		public function result(data:Object):void {
			var result:ResultEvent = data as ResultEvent;
			var func:Function;
			
			if (result.token.resultFunction) {
				func = result.token.innerResultFunction as Function;
				func.apply(this.responderObject, [result]);
			}
		}
		
		public function fault(info:Object):void {
			var fault:FaultEvent = info as FaultEvent;
			var func:Function;
			
			if (fault.token.faultFunction) {
				func = fault.token.innerFaultFunction as Function;
				func.apply(this.responderObject, [result]);
			} else {
				throw(info);
			}
		}
		
	}
}