<cfinclude template="misc.cfm" />

<cfset logpath=getdebuglogpath()>
<cfset logfile="#logpath#eventhandler1.txt ">
<cffile action="write"  file="#logfile#" output="#NOW()#" >

<cfset slash =getslash()>

<cfparam name ="ideeventinfo">
<cfset a=AddEventHandler(ideeventinfo) >

<cffunction name="AddEventHandler" access="private" >
	<cfargument name="ideeventinfo" required="yes" >

    <cfset xmldoc = XMLParse(ideeventinfo) >
    <cfset fileval = xmldoc.event.ide.projectview.resource.xmlAttributes.path />
	<cffile  action="append"  file="#logfile#" output="#ideeventinfo#" addnewline="true"> 
 	<cfset userInputs = XMLSearch(xmldoc, "/event/user/input")>   
	
	<cfset userentry = XMLSearch(xmldoc, "/event/user/input[@name='eventname']")>  
	<cfif ArrayLen(userentry) GT 0> 
		<cfset eventname= userentry[1].XMLAttributes.value>
	<cfelse >
		<cfset eventname= "">
	</cfif>

	<cfset userentry1 = XMLSearch(xmldoc, "/event/user/input[@name='broadcastmsg']")>  
	<cfif ArrayLen(userentry1) GT 0> 
		<cfset broadcastmsg= userentry1[1].XMLAttributes.value>
	<cfelse >
		<cfset broadcastmsg= "">
	</cfif>

	<cfset userentry2 = XMLSearch(xmldoc, "/event/user/input[@name='viewname']")>  
	<cfif ArrayLen(userentry2) GT 0> 
		<cfset viewname= userentry2[1].XMLAttributes.value>
	<cfelse >
		<cfset viewname= "">
	</cfif>

	<cfset userentry3 = XMLSearch(xmldoc, "/event/user/input[@name='viewpath']")>  
	<cfif ArrayLen(userentry3) GT 0> 
		<cfset viewpath= userentry3[1].XMLAttributes.value>
	<cfelse >
		<cfset viewpath= "">
	</cfif>
		
	<cfset userentry4 = XMLSearch(xmldoc, "/event/user/input[@name='viewvalname']")>  
	<cfif ArrayLen(userentry4) GT 0> 
		<cfset viewvalname= userentry4[1].XMLAttributes.value>
	<cfelse >
		<cfset viewvalname= "">
	</cfif>
	
	<cfset userentry5 = XMLSearch(xmldoc, "/event/user/input[@name='viewval']")>  
	<cfif ArrayLen(userentry5) GT 0> 
		<cfset viewval= userentry5[1].XMLAttributes.value>
	<cfelse >
		<cfset viewval= "">
	</cfif>

	

	
	<cffile action="append"  file="#logfile#" 
			output="
					eventname =#eventname#	
					broadcastmsg =#broadcastmsg#	
					viewname=#viewname#		
					viewpath=#viewpath#		
					viewvalname=#viewvalname# 
					viewval=#viewval#" 
			addnewline="true">

	<cfif Len(Trim(eventname))EQ 0>
	<cffile action="append"  file="#logfile#" output="EventName is null so cannot proceed" addnewline="true">
	<cfheader statuscode="432" statustext="EventName is null so cannot proceed">
	
	<cfabort />
	</cfif>
	
	<cfif trim(viewname) NEQ "" AND trim(viewpath) NEQ "">

	<cfif find(".cfm", viewname,Len(viewname)-5) EQ 0>
	<cfset viewname="#viewname#.cfm">
	</cfif>
	<cfset viewfile="#viewpath##slash##viewname#">

	<cffile action="append"  file="#logfile#" 
			output="
					viewfile =#viewfile#" 
			addnewline="true">
	
	<cfif DirectoryExists(viewpath) EQ "No">
		<cffile action="append"  file="#logfile#" output="Invalid view Directory #viewpath#" addnewline="true">
		<cfheader statuscode="432" statustext="Invalid view Directory">
		<cfabort />
	</cfif>
	<!----- Creating  a view file ---->
	<cfif Trim(viewname) NEQ "" AND fileexists(viewfile) EQ "No">
		<cffile action="write" file="#viewfile#" output="View file generated by ModelGlue Assistant" >
		<cffile action="append"  file="#logfile#" output="View file created by ModelGlue Assistant" addnewline="true">
	</cfif>
	</cfif>

	<!-----Create eventhandler entry------>
	<cfset mxmlobj=xmlsearch(xmldoc,"/event/ide/projectview")>
	<cfif fileval EQ "">
	<cfset modelxmlpath=#mxmlobj[1].xmlattributes.projectlocation# >
	<cfset modelxmlfile =modelxmlpath & "#slash#config#slash#ModelGlue.xml">
	<cfelse>
	<cfset modelxmlfile = fileval />
	</cfif>
	<!--- Chekcing for the existance of model ---->
	<cfif fileExists(modelxmlfile) EQ "No">
		<cffile action="append"  file="#logfile#" output="Unable to find modelgluexml file in the current project at #modelxmlfile#" addnewline="true">
		<cfheader statuscode="432" statustext="Unable to find modelgluexml file in the current project">
		<cfabort />
	</cfif>
	<cffile action="read" file="#modelxmlfile#" variable="modelxml">	
	<cfset modelxmlobj=xmlparse(modelxml)>

	<cfif Trim(eventname) NEQ "" >
		
		<cfset eventhndlersnum=searchfornode(modelxmlobj.modelglue,"event-handlers")>
 		<cfset xmlevents= modelxmlobj.modelglue.xmlchildren[eventhndlersnum]>
	
		<!---- Creating eventhandler entry   ------>
		<cfif searchforelement(xmlevents,"name",eventname) EQ 0>
			<cfset num=numofchildren(xmlevents)+1>
			<cfset xmlevents.xmlchildren[num]= xmlelemnew(modelxmlobj,"event-handler")>
			<cfset xmlevents.xmlchildren[num].xmlattributes["name"]="#eventname#">
		<cfelse>
			<!---Stop processing if already an event exists with the same name --->
			<cffile action="append"  file="#logfile#"	output="EventName Already Exists  so cannot proceed" addnewline="true">
			<cfheader statuscode="432" statustext="EventName Already Exists  so cannot proceed">
			<cfabort />
		</cfif>
	
		<cfset elemnum=searchforelement(xmlevents,"name",eventname)>
		<cfset eventnode= xmlevents.xmlchildren[elemnum]>

		<!----- Create broadcast entry ---->
		<cfif Trim(broadcastmsg) NEQ "">
			<cfset evnthndlrs=searchfornode(xmlevents,"name",eventname)>
			
			<cfif searchfornode(eventnode,"broadcasts") EQ 0>
				<cfset childnum=numofchildren(eventnode)+1>
				<cfset eventnode.xmlchildren[childnum]=xmlelemnew(modelxmlobj,"broadcasts")>
			</cfif>

			<cfif searchforelement(xmlevents.xmlchildren[elemnum].broadcasts,"name",broadcastmsg) EQ 0>
				<cfset msgnum=numofchildren(eventnode.broadcasts)+1>
				<cfset eventnode.broadcasts.xmlchildren[msgnum]=xmlelemnew(modelxmlobj,"message")>
				<cfset eventnode.broadcasts.xmlchildren[msgnum].xmlattributes["name"]="#broadcastmsg#">
			</cfif>

		</cfif>

	</cfif>

	
	<!---- Include view  --->
		<cfif Trim(viewname) NEQ "">
			<cfset viewnode=searchfornode(eventnode,"views")>
			<cfif viewnode EQ 0>
				<cfset viewnode=numofchildren(eventnode)+1 >
				<cfset eventnode.xmlchildren[viewnode]=xmlelemnew(modelxmlobj,"views")>
			</cfif>
			<cfset includenode=searchforelement(eventnode.views,"template",viewname)>
			<cfif includenode EQ 0 >
				<cfset includenodenum=numofchildren(eventnode.views)+1>
				<cfset eventnode.views.xmlchildren[includenodenum]=xmlelemnew(modelxmlobj,"include")>
				<cfset includenode=eventnode.views.xmlchildren[includenodenum]>
				<cfset includenode.xmlattributes["name"]="body">
				<cfset includenode.xmlattributes["template"]="#viewname#">
			<cfelse >
				<cfset includenode=eventnode.views.xmlchildren[includenodenum]>
			</cfif>
	<!----- Add vew value----->
			<cfif Trim(viewvalname) NEQ "">
				<cfset viewvalnum=searchforelement(includenode,"name", viewvalname)>
				<cfif viewvalnum EQ 0>
					<cfset viewvalnum=numofchildren(includenode)+1>
					<cfset includenode.xmlchildren[viewvalnum]=xmlelemnew(modelxmlobj,"value")>
					<cfset 	includenode.xmlchildren[viewvalnum].xmlattributes["name"]= "#viewvalname#">
					<cfset includenode.xmlchildren[viewvalnum].xmlattributes["value"]= "#viewval#">
				</cfif>
			</cfif>	
		</cfif> 

		<cfset formmattednodestring=xmlHumanReadable(eventnode)>
		<cfset formattedstring=chr(10) & replace(formmattednodestring,"<?xml version=""1.0"" encoding=""UTF-8""?>","") & chr(10)>
		<cfset updatedmodelxml=insert(formattedstring,modelxml,find("</event-handlers>",modelxml,0)-1)>

		<cffile action="append"  file="#logfile#" 
			output=" After view is included
					updatedmodelxml=#updatedmodelxml#" 
			addnewline="true">
		<cffile action="write"  file="#modelxmlfile#" 
			output="#updatedmodelxml#" 
			addnewline="true">


</cffunction> 