<cfsetting showdebugoutput="false" />
<cfset helper = createObject("component","components.builderHelper").init(ideEventInfo)>

<cfif helper.getRunType() neq "projectview">
	<cfabort>
</cfif>
<cfset folder = helper.getSelectedResource().path>

<!--- 
So, based on the folder we will attempt to load your configuration files. For now, this is based on the assumption of
/config/ModelGlue.xml and/config/ColdSpring.xml - also support the .cfm versions
--->

<cfif directoryExists(folder & "/config")>
	<cfset configDir = folder & "/config/">
<cfelse>
	<cfoutput>
	Sorry, but we are unable to find the configuration folder: #folder#/config.
	</cfoutput>
	<cfabort>
</cfif>

<cfif fileExists(configDir & "ModelGlue.xml")>
	<cfset mgXML = configDir & "ModelGlue.xml">
<cfelseif fileExists(configDir & "ModelGlue.xml.cfm")>
	<cfset mgXML = configDir & "ModelGlue.xml.cfm">
<cfelse>
	<cfoutput>
	Sorry, but we are unable to find the ModelGlue configuration: #configDir#ModelGlue.xml.
	</cfoutput>
	<cfabort>
</cfif>

<cfif fileExists(configDir & "ColdSpring.xml")>
	<cfset csXML = configDir & "ColdSpring.xml">
<cfelseif fileExists(configDir & "ColdSpring.xml.cfm")>
	<cfset csXML = configDir & "ColdSpring.xml.cfm">
<cfelse>
	<cfoutput>
	Sorry, but we are unable to find the ModelGlue configuration: #configDir#ColdSpring.xml.
	</cfoutput>
	<cfabort>
</cfif>

<!--- begin to read in and parse our data --->
<cfset csFile = fileRead(csXML)>
<cfset configData = xmlParse(csFile)>
<cfset mgConfigRaw = xmlSearch(configData,"//beans/bean[@id='modelglue.modelGlueConfiguration']")>

<cfif arrayLen(mgConfigRaw) is 0>
	<cfoutput>
	Sorry, but this does not appear to be a Model-Glue 3.0 or higher application.
	</cfoutput>
	<cfabort>
</cfif>

<cfset mgConfigRaw = mgConfigRaw[1]>
<!--- preset some keys I assume --->
<cfset mgConfig = {reload="", debug="", eventValue="", defaultEvent="", missingEvent="", defaultExceptionHandler="", reloadPassword="", reloadKey="", applicationMapping="", viewMappings="", helperMappings="", generationEnabled=""}>

<cfloop index="x" from="1" to="#arrayLen(mgConfigRaw.property)#">
	<cfset config = mgConfigRaw.property[x]>
	<cfset mgConfig[config.xmlAttributes.name] = config.value.xmlText>
</cfloop>

<cfset mgFile = fileRead(mgXML)>
<cfset mgData = xmlParse(mgFile)>
<!--- before we try to config we need to look for includes as well --->
<cfset includeArray = xmlSearch(mgData, "/modelglue/include")>
<cfset includes = [mgXml]>
<cfif arrayLen(includeArray)>
	<cfloop index="inc" array="#includeArray#">
		<!---
		 We need to convert a path to a real path. This may be near impossible since we don't execute in process and have access to the mappings.
		 But we can make reasonable guesses. For example, */config/* should imply that config is in the same folder as our core MG file. 
		 --->
		 <cfif refindnocase(".*?/config/", inc.xmlAttributes.template)>
		 	<cfset pathWOConfig = rereplace(inc.xmlAttributes.template, ".*?/config/",  "")>
		 	<cfif fileExists(configdir & pathWOConfig)>
 				<cfset arrayAppend(includes, configdir & pathWOConfig)>
			</cfif>
		</cfif>
	</cfloop>
</cfif>

<!--- Going to add mg xml file to include array to allow me to simply loop over each item in the array --->
<!--- Note that we may not be able to 'find' the xml file --->
<!--- screw it - first draft, doing main file only --->
<cfset eventList = []>
<cfset controllerList = []>
<cfloop index="theFile" array="#includes#">
	
	<cfset xmlData = xmlParse(theFile)>
	<cfset events = xmlSearch(xmlData, "/modelglue/event-handlers/event-handler")>
	<cfloop index="x" from="1" to="#arrayLen(events)#">
		<cfset eventRaw = events[x]>
		<cfset event = {}>
		<cfset event.name = eventRaw.xmlAttributes.name>
		<cfset event.broadcasts = []>
		<cfset event.results = []>
		<cfset event.views = []>
		<cfset event.type = "TBD">
		
		<cfif structKeyExists(eventRaw, "broadcasts") and structKeyExists(eventRaw.broadcasts,"message")>
			<cfloop index="y" from="1" to="#arrayLen(eventRaw.broadcasts.message)#">
				<cfset messageRaw = eventRaw.broadcasts.message[y]>
				<cfset msg = {}>
				<cfset msg.name = messageRaw.xmlAttributes.name>
				<cfset arrayAppend(event.broadcasts, msg)>
			</cfloop>
		</cfif>
	
		<cfif structKeyExists(eventRaw, "results") and structKeyExists(eventRaw.results,"result")>
			<cfloop index="y" from="1" to="#arrayLen(eventRaw.results.result)#">
				<cfset resultRaw = eventRaw.results.result[y]>
				<cfset result = {}>
				<cfif structkeyExists(resultRaw.xmlAttributes, "name")>
					<cfset result.name = resultRaw.xmlAttributes.name>
				</cfif>
				<cfset result.do = resultRaw.xmlAttributes.do>
				<cfif structkeyExists(resultRaw.xmlAttributes, "redirect")>
					<cfset result.redirect = resultRaw.xmlAttributes.redirect>
				</cfif>
				<cfset arrayAppend(event.results, result)>
			</cfloop>
		</cfif>
	
		<cfif structKeyExists(eventRaw, "views") and structKeyExists(eventRaw.views,"include")>
			<cfloop index="y" from="1" to="#arrayLen(eventRaw.views.include)#">
				<cfset viewRaw = eventRaw.views.include[y]>
				<cfset view = {}>
				<cfset view.name = viewRaw.xmlAttributes.name>
				<cfset view.template = viewRaw.xmlAttributes.template>
				<cfset arrayAppend(event.views, view)>
			</cfloop>
		</cfif>
			
		<cfset arrayAppend(eventList, event)>
	</cfloop>

	<cfset controllers = xmlSearch(xmlData, "/modelglue/controllers/controller")>
	<cfloop index="x" from="1" to="#arrayLen(controllers)#">
		<cfset controllerRaw = controllers[x]>
		<cfset controller = {}>
		
		<cfset controller.id = controllerRaw.xmlAttributes.id>
		<cfset controller.type = controllerRaw.xmlAttributes.type>

		<cfset arrayAppend(controllerList, controller)>
	</cfloop>
	
</cfloop>


<!---
<cfdump var="#controllerList#" abort>
<cfdump var="#eventList#" abort>
--->

<cfheader name="Content-Type" value="text/xml">
<cf_view id="modelgluesettings" title="Model-Glue Settings">

<script>
$(function() {
	$( "#tabs" ).tabs();
});
</script>

<div id="tabs">
	<ul>
		<li><a href="#config">Model-Glue Configuration</a></li>
		<li><a href="#event">Events</a></li>
		<li><a href="#tabs-3">Event Types</a></li>
		<li><a href="#controller">Controllers</a></li>
	</ul>
	<div id="config">
		 <cfoutput>
		 	<a href="#helper.getrooturl()#foo.cfm">foo</a> #helper.getcallbackurl()#<br/>
		 <table cellpadding="6" border="1">
		 	<tr>
		 		<td>Reload</td>
		 		<td>#mgconfig.reload#</td>
		 	</tr>
		 	<tr>
		 		<td>Debug</td>
		 		<td>#mgconfig.debug#</td>
		 	</tr>
		 	<tr>
		 		<td>Event Value</td>
		 		<td>#mgconfig.eventValue#</td>
		 	</tr>
		 	<tr>
		 		<td>Default Event</td>
		 		<td>#mgconfig.defaultevent#</td>
		 	</tr>
		 	<tr>
		 		<td>Missing Event</td>
		 		<td>#mgconfig.missingEvent#</td>
		 	</tr>
		 	<tr>
		 		<td>Default Exception Handler</td>
		 		<td>#mgconfig.defaultexceptionhandler#</td>
		 	</tr>
		 	<tr>
		 		<td>Reload Password</td>
		 		<td>#mgconfig.reloadpassword#</td>
		 	</tr>
		 	<tr>
		 		<td>Reload Key</td>
		 		<td>#mgconfig.reloadkey#</td>
		 	</tr>
		 	<tr>
		 		<td>Application Mapping</td>
		 		<td>#mgconfig.applicationMapping#</td>
		 	</tr>
		 	<tr>
		 		<td>View Mappings</td>
		 		<td>#mgconfig.viewMappings#</td>
		 	</tr>
		 	<tr>
		 		<td>Helper Mappings</td>
		 		<td>#mgconfig.helperMappings#</td>
		 	</tr>
		 	<tr>
		 		<td>Generation Enabled</td>
		 		<td>#mgconfig.generationEnabled#</td>
		 	</tr>
		 </table>
		 </cfoutput>

	</div>
	<div id="event">
		<cfloop index="event" array="#eventList#">
			<cfoutput>
			<p>
			<b>#event.name#</b><br/>
			Broadcasts: <cfloop index="x" from="1" to="#arrayLen(event.broadcasts)#">#event.broadcasts[x].name#<cfif x lt arrayLen(event.broadcasts)>, </cfif></cfloop><br/>
			Views: <cfloop index="x" from="1" to="#arrayLen(event.views)#">#event.views[x].name# (#event.views[x].template#)<cfif x lt arrayLen(event.views)>, </cfif></cfloop><br/>
			Results: <cfloop index="x" from="1" to="#arrayLen(event.results)#">#event.results[x].do#<cfif x lt arrayLen(event.results)>, </cfif></cfloop><br/>
			</p>
			</cfoutput>
		</cfloop>
	</div>
	<div id="controller">
		<cfloop index="controller" array="#controllerList#">
			<cfoutput>
			<p>
			<b>#controller.id# (#controller.type#)</b><br/>
			</p>
			</cfoutput>
		</cfloop>
	</div>
</div>
</cf_view>