<!---
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
--->
<cfcomponent output="false">

<cffunction name="init" output="false">
	<cfargument name="transfer" />
	<cfset variables.transfer = arguments.transfer />
</cffunction>

<cffunction name="list" returntype="array" output="false">
	<cfset var qry = variables.transfer.list("com.firemoss.modelglue.flex.examples.contactmanager.model.Contact") />
	<cfset var result = arrayNew(1) />
	<cfset var contact = "" />
	<cfset var i = "" />
		
	<cfloop query="qry">
		<cfset contact = createObject("component", "com.firemoss.modelglue.flex.examples.contactmanager.service.model.ContactTO") />
		<cfloop list="#qry.columnList#" index="i">
			<cfset contact[i] = qry[i][qry.currentRow] />
		</cfloop>
		<cfset arrayAppend(result, contact) />
	</cfloop>
	
	<cfreturn result />
</cffunction>

<cffunction name="save" type="any" returntype="any" output="false">
	<cfargument name="target" required="true" />
	<cfset var i = "" />
	
	<cfif isArray(arguments.target)>
		<cfloop from="1" to="#arrayLen(arguments.target)#" index="i">
			<cfset arguments.target[i] = saveContact(arguments.target[i]) />
		</cfloop>
	<cfelse>
		<cfset arguments.target = saveContact(arguments.target) />
	</cfif>
	
	<cfreturn arguments.target />
</cffunction>

<cffunction name="saveContact" access="private">
	<cfargument name="contactTO" />
	
	<cfset var contact = toTransferObject(arguments.contactTO, "com.firemoss.modelglue.flex.examples.contactmanager.model.Contact") />
	<cfset var dto = createObject("component", "com.firemoss.modelglue.flex.examples.contactmanager.service.model.ContactTO") />

	<cflog text="Saving contact: #contact.getFirstname()# / #contact.getContactId()#" />
	<cfset variables.transfer.save(contact) />

	<cfreturn toDTO(contact, dto) />
</cffunction>

<cffunction name="destroy" type="any" returntype="void" output="false">
	<cfargument name="target" required="true" />
	<cfset var i = "" />
	
	<cfif isArray(arguments.target)>
		<cfloop from="1" to="#arrayLen(arguments.target)#" index="i">
			<cfset deleteContact(arguments.target[i]) />
		</cfloop>
	<cfelse>
		<cfset deleteContact(arguments.target) />
	</cfif>
</cffunction>

<cffunction name="deleteContact" access="private">
	<cfargument name="contactTO" />

	<cfset var contact = variables.transfer.get("com.firemoss.modelglue.flex.examples.contactmanager.model.Contact", arguments.contactTO.contactId) />	
	<cfset variables.transfer.delete(contact) />
</cffunction>

<cffunction name="toTransferObject" access="private" output="false">
	<cfargument name="to" />
	<cfargument name="classname" />
	
	<cfset var transferObject = variables.transfer.get(arguments.classname, arguments.to.contactId) />
	<cfset var i = "" />
	
	<cfloop collection="#arguments.to#" item="i">
		<cfset evaluate("transferObject.set#i#(arguments.to[i])") />
	</cfloop>
	
	<cfreturn transferObject />
</cffunction>

<cffunction name="toDTO" access="private" output="false">
	<cfargument name="transferObject" />
	<cfargument name="dto" />
	
	<cfset var i = "" />
	<cfset var value = "" />
	
	<cfloop collection="#arguments.dto#" item="i">
		<cfinvoke component="#arguments.transferObject#" method="get#i#" returnvariable="value" />
		<cfset arguments.dto[i] = value />
	</cfloop>
	
	<cfreturn arguments.dto />
</cffunction>
			
</cfcomponent>