/*
LICENSE INFORMATION:

Copyright 2010, Joe Rinehart, Dan Wilson

Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue 'Gesture' 3.2 Alpha 2 (3.2.750.403).

The version number in parentheses is in the format versionNumber.subversion.revisionNumber.
*/

$(document).ready(function() {
	
	$('table.dataTable').each(function() {
		
		var thisTable = $(this);
		var entityName = thisTable.attr('id').replace(/Table/, '');
		var th = thisTable.find('thead th');
		var columns = [];
		
		th.each(function(index) {
			if (index == 0)
				columns.push( { sType: 'html' } );
			else if ($.trim( $(this).text() ).length == 0)
				columns.push( { bSearchable: false, bSortable: false } );
			else
				columns.push( null );
		});
		
		thisTable.dataTable( {
			aoColumns: columns,
			bAutoWidth: false,
			bJQueryUI: true,
			fnDrawCallback: function() {
				var tableId = arguments[0].sTableId;
				
				$('#' + tableId).parents('.dataTables_wrapper').next('.addLink').add('#' + tableId + ' td.button a').button();
			}
		});
		
		thisTable.find('td.delete a').live('click', function() {
			
			var linkTarget = $(this).attr('href');
			
			$('<div>Are you sure you wish to delete this ' + entityName + ' record?</div>').appendTo('body').dialog( {
				buttons: {
					Cancel: function() {
						$(this).dialog('close').remove();
					},
					OK: function() {
						window.location.href = linkTarget;
						$(this).dialog('close').remove();
					}
				},
				modal: true,
				title: 'Delete ' + entityName
			});
			
			return false;
			
		});
		
	});
	
});
