<cfsetting enablecfoutputonly=true>
<!---
	Name         : user_edit.cfm
	Author       : Raymond Camden 
	Created      : August 3, 2007
	Last Updated : 
	History      : 
--->
<cfimport taglib="../tags/" prefix="tags">

<cfif isDefined("form.cancel") or not isDefined("url.id")>
	<cflocation url="users.cfm" addToken="false">
</cfif>

<cfif isDefined("form.save")>
	<cfset form = request.udf.cleanStruct(form)>
	<cfset errors = "">
	<cfif not len(form.username)>
		<cfset errors = errors & "You must specify a username.<br>">
	</cfif>
	<cfif url.id is 0 and not len(form.password)>
		<cfset errors = errors & "You must specify a password for a new user.<br>">
	</cfif>
		
	<cfif not len(errors)>

		<cfset data = structNew()>
		<cfset data.username = form.username>
		<cfif len(trim(form.password))>
			<cfset data.password = form.password>
		</cfif>
		
		<cftry>	
			<cfif url.id neq 0>
				<cfset data.originalusername = url.id>
				<cfset application.user.updateUser(argumentCollection=data)>
			<cfelse>
				<cfset application.user.addUser(argumentCollection=data)>		
			</cfif>
			<cfset msg = "User, #form.username#, has been updated.">
			<cflocation url="users.cfm?msg=#urlEncodedFormat(msg)#">
			<cfcatch>
				<cfset errors = cfcatch.message>
			</cfcatch>
		</cftry>
				
	</cfif>
</cfif>

<!--- get survey if not new --->
<cfif url.id neq 0>
	<cfset user = application.user.getUser(url.id)>
	<cfparam name="form.username" default="#user.username#">	
<cfelse>
	<cfparam name="form.username" default="">
</cfif>

<tags:layout templatename="admin" title="User Editor">

<cfoutput>
<p>
Please use the form below to enter details about the user. All required fields are marked (*). 
Because passwords are hashed in the database, you cannot set the current password. If you enter
a new password it will overwrite the old one.
</p>

<p>
<cfif isDefined("errors")><ul><b>#errors#</b></ul></cfif>
<form action="#cgi.script_name#?#cgi.query_string#" method="post" autocomplete="off">
<table cellspacing=0 cellpadding=5 class="adminEditTable" width="100%">
	<tr valign="top">
		<td width="200"><b>(*) Username:</b></td>
		<td><input type="text" name="username" value="#form.username#" size="50"></td>
	</tr>
	<tr valign="top">
		<td width="200"><b>New Password:</b></td>
		<td><input type="password" name="password" value="" size="50"></td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td><input type="submit" name="save" value="Save">
		<input type="submit" name="cancel" value="Cancel"></td>
	</tr>
</table>
</form>
</p>
</cfoutput>

</tags:layout>

<cfsetting enablecfoutputonly=false>