/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/


package com.firemoss.modelglue
{
	import com.firemoss.modelglue.tags.Controller;
	
	
	public class ModelGlueFramework
	{
		private static var _framework:Framework = Framework.getInstance();
		
		public static function get framework():Framework {
			return ModelGlueFramework._framework;			
		}
		
		public static function getController(id:String):Controller {
			return ModelGlueFramework._framework.getController(id);
		}
		
		public static function subscribe(messageName:String, subscriber:Object, listenerFunction:Function):void {
			ModelGlueFramework._framework.addMessageListener(messageName, subscriber, listenerFunction);
		}
	}
}