/*
LICENSE INFORMATION:

Copyright 2010, Joe Rinehart, Dan Wilson

Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue 'Gesture' 3.2 Alpha 2 (3.2.750.403).

The version number in parentheses is in the format versionNumber.subversion.revisionNumber.
*/

$(document).ready(function() {
	
	$('#frmMain .multiSelect').each(function() {
		var label = $.trim( $(this).prev('label').text() );
		
		$(this).css('width', '33%').multiSelect({
			checkAllText: 'Select all',
			noneSelectedText: 'Select ' + label,
			onOpen: function() {
				$('.ui-multiselect-options').position( { my: 'left top', at: 'left bottom', of: $('.ui-multiselect-options').prev() } );
			},
			selectedText: function(numChecked, numTotal, checkedInputs) {
				if (numChecked > 5)
					return numChecked + ' ' + label + ' selected';
				else {
					var message = '';
					$.each(checkedInputs, function() {
						if (message.length == 0)
							message = $(this).attr('title');
						else
							message += ', ' + $(this).attr('title');
					});
					return message;
				}
			},
			unCheckAllText: 'Select none'
		});
	});
	
	$('#frmMain .ui-multiselect').css({ borderWidth: '2px', fontSize: '.8em' });
	$('#frmMain .ui-multiselect input').css({ marginRight: '-2px', paddingLeft: '2px' });
	$('#frmMain .ui-multiselect span').css('margin-top', '2px');

	$('#frmMain .textInput, #frmMain .selectInput').addClass('ui-corner-all ui-state-default')
		.css({ background: 'white none repeat scroll 0 0', paddingLeft: '2px' })
		.hover(
			function() {
				$(this).css('border', '2px solid #999999')
			},
			function() {
				$(this).css('border', '2px solid #DFDFDF');
			}
		);
	
	$('#frmMain .addDatePicker').datepicker();
	
	$('#frmMain :submit').button();
	
});
