/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.eventhandler {
	
	import com.firemoss.modelglue.util.Iterator;
	import flash.utils.Dictionary;
	import com.firemoss.modelglue.tags.event.Result;

	public class EventHandler {

		private var _name:String;
		private var broadcasts:Array;
		private var explicitResults:Dictionary;
		private var implicitResults:Array;
		
		public function EventHandler() {
			this.broadcasts = new Array();
			this.explicitResults = new Dictionary();
			this.implicitResults = new Array();
		}

		public function set name(value:String):void {
			if (this._name == null) this._name = value;
		}		
		public function get name():String {
			return this._name;
		}
		
		public function get messageBroadcasts():Array {
			return this.broadcasts;
		}
		public function addMessageBroadcast(mb:MessageBroadcast):void {
			this.broadcasts.push(mb);
		}
		
		public function addExplicitResult(name:String, result:Result):void {
			if (this.explicitResults[name] == null) this.explicitResults[name] = new Array();
			
			this.explicitResults[name].push(result);
		}
		
		public function getExplicitResults(name:String):Array {
			if (this.explicitResults[name] == null) this.explicitResults[name] = new Array();
			
			return this.explicitResults[name];
		}
		
		public function addImplicitResult(eventHandlerName:String):void {
			this.implicitResults.push(eventHandlerName);
		}
		
		public function getImplicitResults():Array {
			return this.implicitResults;
		}
		
	}
}