/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.service {
	import mx.rpc.AbstractService;
	import com.firemoss.modelglue.error.ModelGlueError;
	import mx.controls.Alert;
	import mx.rpc.remoting.mxml.Operation;
	import mx.rpc.AbstractOperation;
	import mx.rpc.IResponder;
	import mx.collections.ArrayCollection;
	import mx.rpc.AsyncToken;
	import flash.utils.Proxy;
	import flash.utils.flash_proxy;
	import flash.utils.Dictionary;
	import com.firemoss.modelglue.controller.ModelGlueController;	
	
 	public dynamic class ServiceProxy extends Proxy {
 		private var _inner:Object = new Object();
 		
		flash_proxy override function callProperty(name:*, ...rest):* {
			var proxy:AsynchronousOperationProxy;
			var f:Function;
			var service:AbstractService;

			if (this._inner.asyncProxies[name.localName] == null) {
				service = this._inner.target as AbstractService;
				proxy = new AsynchronousOperationProxy(this._inner.controller, service.getOperation(name.localName));
				this._inner.asyncProxies[name.localName] = proxy;
			} else {
				proxy = this._inner.asyncProxies[name.localName] 
			}
						
			f = proxy.apply;
			
			f.apply(proxy, rest);
		}

		flash_proxy override function getProperty(name:*):* {
			return this._inner[name]
		}

		flash_proxy override function setProperty(name:*, value:*):void {
			this._inner[name] = value;
		}
	
		     
  	public function ServiceProxy(service:Object, controller:ModelGlueController) {
			this.asyncProxies = new Dictionary();
			this.controller = controller;
			
			if (service is AbstractService) {
				this.target = service as AbstractService;
			}	else if (service is String) {
				this.target = ServiceLocator.getInstance().getService(service as String);					
			} else {
				throw new ModelGlueError(ModelGlueError.MODEL_GLUE_DELEGATE_CONSTRUCTOR_BAD, "");
			}
		}
		
	}

}