CREATE TABLE `answers` (
`id` varchar(35) NOT NULL,
`questionidfk` varchar(35) NOT NULL,
`answer` varchar(255) NOT NULL,
`rank` int(10) NOT NULL DEFAULT '0' ,
PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE `questions` (
`id` varchar(35) NOT NULL,
`surveyidfk` varchar(35) NOT NULL,
`question` varchar(255) NOT NULL,
`questiontypeidfk` varchar(35) NOT NULL,
`rank` int(10) unsigned NOT NULL DEFAULT '0',
`required` tinyint(3) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `questiontypes` (
`id` varchar(35) NOT NULL,
`name` varchar(50) NOT NULL,
`handlerroot` varchar(50) NOT NULL,
PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `results` (
`owneridfk` varchar(255) NOT NULL,
`questionidfk` varchar(35) NOT NULL,
`answeridfk` varchar(35) NULL,
`truefalse` tinyint(3) unsigned NULL,
`textbox` varchar(255) NULL,
`textboxmulti` text NULL,
`other` varchar(255) NULL,
`itemidfk` varchar(35) NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE survey_emailaddresses (
`surveyidfk` varchar(35) NOT NULL,
`emailaddress` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE survey_results (
`surveyidfk` varchar(35) NOT NULL,
`ownerid` varchar(50) NOT NULL,
`completed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE surveys (
`id` varchar(35) NOT NULL,
`name` varchar(50) NOT NULL,
`description` varchar(255) NOT NULL,
`active` tinyint(3) unsigned NOT NULL DEFAULT '0',
`datebegin` datetime NULL,
`dateend` datetime NULL,
`resultmailto` varchar(50) NULL,
`surveypassword` varchar(50) NULL,
`thankyoumsg` text NULL,
PRIMARY KEY (id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE users (
`username` varchar(255) NOT NULL,
`password` varchar(255) NULL,
PRIMARY KEY (username)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



INSERT INTO questiontypes(id, name, handlerroot)
VALUES('1EB9DDE1-C9C4-302C-3B98D7C3FEFD49E6', 'Matrix', 'matrix');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C3818CC-0A9C-D457-7471E322BAD72874', 'True/False', 'truefalse');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C38479C-9A5D-10AA-84C4575501F22BAB', 'Yes/No', 'yesno');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C386D16-A997-7B46-A0A52A767EC27586', 'Multiple Choice (Single Selection)', 'multiplechoice');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C3898D9-B098-B443-BA496411714AF499', 'Multiple Choice (Multi Selection)', 'multiplechoicemulti');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C38BE43-0B52-6068-0725ABBD4380A2A4', 'Multiple Choice (Multi Selection) with Other', 'multiplechoicemultiother');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C38E841-9913-D91D-2A84D3F4A13AF92E', 'Multiple Choice (Single Selection) with Other', 'multiplechoiceother');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C390D2F-BA60-EA48-8EF87424CF09FD03', 'Text Box (Single)', 'textbox');

INSERT INTO questiontypes(id, name, handlerroot)
VALUES('6C3930D4-AA69-D471-58DBBC6CF38E5101', 'Text Box (Multi)', 'textboxmulti');

INSERT INTO users(username, password)
VALUES('admin', '21232F297A57A5A743894A0E4A801FC3');