--------------------------------------------------------------------------------
-- Script for creating default database setup for Galleon Forum
--
-- You need to execute this script as sys user and sysdba
--
-- Copyright by ComputerOil AG 2006
--
-- History:
-- 07/29/2006	Created this script

--------------------------------------------------------------------------------

SET TAB OFF;
SET ECHO OFF;
SET FEEDBACK OFF;
SET SHOWMODE OFF;

spool galleon

--------------------------------------------------------------------------------
-- CREATE THE SCHEMA (USER)
--------------------------------------------------------------------------------

prompt ===========================
prompt Setting up the Galleon Schema ...
prompt

-- Prompt for schema name
accept theuser char format a30 prompt "Enter the schema name: "

-- Prompt for schema password
accept thepass char format a30 prompt "Enter the schema password: "

-- Prompt for prefix name
accept theprefix char format a30 prompt "Enter the prefix of the tables: "

drop user &theuser cascade;

create user &theuser identified by &thepass;

grant connect, resource to &theuser;

prompt Galleon Schema done
prompt ===========================
prompt

--------------------------------------------------------------------------------
-- CREATE THE DEFAULT TABLES
--------------------------------------------------------------------------------

prompt ===========================
prompt Adding tables now ...

-- conferences
CREATE TABLE &theuser..&theprefix.CONFERENCES
(id varchar2(35 char), 
name varchar2(255 char), 
description varchar(255 char), 
active number);

-- forums
CREATE TABLE &theuser..&theprefix.FORUMS
(id varchar2 (35 char),
name varchar2 (255 char),
description varchar2 (255 char),
readonly number,
active number,
conferenceidfk varchar2 (35 char));

-- groups
CREATE TABLE &theuser..&theprefix.GROUPS
(Id varchar2 (35 char),
thegroup varchar2 (50 char));

-- messages
CREATE TABLE &theuser..&theprefix.MESSAGES
(Id varchar2(35 char),
title varchar2(255 char),
body clob,
posted date,
useridfk varchar2(35 char),
threadidfk varchar2(35 char));

-- ranks
CREATE TABLE &theuser..&theprefix.RANKS
(Id varchar2(35 char),
name varchar2(50 char),
minposts number);

-- search_log
CREATE TABLE &theuser..&theprefix.SEARCH_LOG
(searchterms varchar2(255 char),
datesearched date);

-- subscriptions
CREATE TABLE &theuser..&theprefix.SUBSCRIPTIONS
(Id varchar2(35 char),
useridfk varchar2(35 char),
threadidfk varchar2(35 char),
forumidfk varchar2(35 char),
conferenceidfk varchar2(35 char));

-- threads
CREATE TABLE &theuser..&theprefix.THREADS
(Id varchar2(35 char),
name varchar2(255 char),
active number,
readonly number,
useridfk varchar2(35 char),
forumidfk varchar2(35 char),
datecreated date,
sticky number);

-- users
CREATE TABLE &theuser..&theprefix.USERS
(Id varchar2(35 char),
username varchar2(50 char),
password varchar2(50 char),
emailaddress varchar2(255 char),
datecreated date,
confirmed number);

-- users_groups
CREATE TABLE &theuser..&theprefix.USERS_GROUPS
(useridfk varchar2(35 char),
groupidfk varchar2(35 char));

prompt Adding tables done
prompt ===========================
prompt

--------------------------------------------------------------------------------
-- CREATE PRIMARY KEYS
--------------------------------------------------------------------------------

ALTER TABLE &theuser..&theprefix.CONFERENCES ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.FORUMS ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.GROUPS ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.MESSAGES ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.RANKS ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.SUBSCRIPTIONS ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.THREADS ADD (PRIMARY KEY (id));
ALTER TABLE &theuser..&theprefix.USERS ADD (PRIMARY KEY (id));

--------------------------------------------------------------------------------
-- DO THE INSERTS
--------------------------------------------------------------------------------

prompt ===========================
prompt Adding default table values now ...

-- groups
INSERT INTO &theuser..&theprefix.GROUPS VALUES ('AD0F29B5-BEED-B8BD-CAA9379711EBF168','forumsmember');
INSERT INTO &theuser..&theprefix.GROUPS VALUES ('AD0F717C-AFE5-FD0E-77EB8FF5BDD858A2','forumsmoderator');
INSERT INTO &theuser..&theprefix.GROUPS VALUES ('C18B1118-7E9B-AEC8-14E8DB3C21EFCA1D','forumsadmin');

-- users
INSERT INTO &theuser..&theprefix.USERS VALUES ('C189C5AC-7E9B-AEC8-1DAEEEA03A562CF0','admin','admin','admin@localhost.com',NULL,1);

-- users_groups
INSERT INTO &theuser..&theprefix.USERS_GROUPS VALUES ('C189C5AC-7E9B-AEC8-1DAEEEA03A562CF0','C18B1118-7E9B-AEC8-14E8DB3C21EFCA1D');

prompt Adding default tables values done
prompt ===========================
prompt

commit;

prompt ===========================
prompt Database fully setup for Galleon forum!
prompt You can now exit the sqlplus app.
prompt ===========================

spool off;

-- Exit the sqlplus app
-- exit;
