<cfsilent>
	<cfset page.title = "The Model-Glue Framework" />
</cfsilent>

<cfinclude template="include/dspHeader.cfm" />

<div class="body">

<h1>Model-Glue</h1>

<p>
	The Model-Glue family of frameworks support Web application developers by making the construction of Object-Oriented Web and Rich Internet Applications a straightforward process.
</p>
<p>
	Through a simple implementation of Implicit Invocation and Model-View-Controller, they allow applications to be well organized without sacrificing flexibility.
</p>
<p>
	For a short list of web sites running Model-Glue, please visit our <a href="sites.cfm">sites</a> page. 
	Contact <a href="http://www.coldfusionjedi.com/">Raymond Camden</a> to have your site added to the list.
</p>

<div class="contentSection">
	<div class="contentIcon"><a href="/coldfusion.cfm"><img src="/images/mgTabletColdFusion.gif" /></a></div>
	<h1><a href="/coldfusion.cfm">Model-Glue: ColdFusion</a></h1>
	<cfoutput>
	<span class="contentNote">Currently Available Version: #application.downloads.mgcoldfusion3.version# - <a href="#application.downloads.mgcoldfusion3.url#">Download</a> <a href="/coldfusion.cfm">Learn More</a></span>
	<h3>Available Now:  #application.downloads.mgcoldfusion3beta.title# #application.downloads.mgcoldfusion3beta.version# </h3>
	</cfoutput>
	<p>
		Model-Glue: ColdFusion is designed to make it easier to use object-oriented models to create HTML-based applications.
	</p>
	<p>
		It enforces Model-View-Controller design, eases implicit invocation, does repetitive work for you, and plays well with other open-source ColdFusion frameworks.
	</p>
	<p>
		<strong>New:</strong> <a href="/wallpaper.cfm">Download Model-Glue wallpaper</a>
	</p>
</div>
<div class="contentSection">
	<h2><strong>Web Based Training for Model-Glue 3.1</h2>
	<p>
	<a href="training.cfm">Free self-paced training course</a></strong> is newly available!</a>
	</p>
</div
<div class="contentSection">
	<h2>Model-Glue is:</h2>
	
	<ol>
	<li>Unobtrusive.  <p>It's designed to be easy to use, letting you focus on business problems and user interface, not framework hoops.</p></li>
	
	<li>Enabling.  <p>It builds on ColdFusion as a productivity tool for writing Web applications.</p></li>
	
	<li>Strong but Simple.  <p>Model-Glue is based on Model View Controller and Implicit Invocation - but not at all complicated.</p></li>
	
	<li>Open.  <p>All code is released under the Apache Software License 2.0, meaning that it's free to download, use, and alter.</p></li>
	
	<li>Compatible.  <p>Model-Glue is lightweight enough to play well with others: it works with Model frameworks like Tartan and ColdSpring as well as Object/Relational Mapping frameworks like Reactor and Transfer.</p></li>
	
	</ol>
	
	<h2>What People Say About Model-Glue:</h2>
	<br />
	<em>Model-Glue is the best thing for ColdFusion since the cfquery tag. It relieves me of worrying about application organization and lets me focus on what matters - the business requirements of the application.</em>
	<div class="contentNote">Raymond Camden, VP of Technology for roundpeg</div>
	
	<br />
	<em>Model-Glue:Unity, by helping to eliminate a lot of tedious and redundant tasks, has allowed me to code more efficiently than I ever could have imagined.</em>
	<div class="contentNote">Scott Stroz, Senior Web Developer, AboutWeb, LLC</div>
	<br />
	<em>Model-Glue has enabled me to quit building infrastructure and start solving my clients' problems. I Sniff The Glue!</em>
	<div class="contentNote">Jared Rypka-Hauer, Adobe Community Experts</div>
	<br />
	
	<em>Model-Glue is more gooder!</em>
	<div class="contentNote">Anonymously yelled at CFUnited 2005</div>
</div>

<!---<div class="contentSection">
	<div class="contentIcon"><a href="/flex.cfm"><img src="/images/mgTabletFlex.gif" /></a></div>
	<h1><a href="/flex.cfm">Model-Glue: Flex</a></h1>
	<cfoutput>
	<span class="contentNote">Currently Available Version: #application.downloads.mgflex.version# - <a href="#application.downloads.mgflex.url#">Download</a> <a href="/flex.cfm">Learn More</a></span>
	</cfoutput>
	<p>
		Model-Glue: Flex brings implicit invocation, Model-View-Controller design, and cleaner, less repetitive integration with backend services to Flex 2.0 and AIR applications.
	</p>
	<p>
		It shuns repetitive, boilerplate code in favor of helper classes and expressive APIs.
	</p>
</div>--->

</div>

<cfinclude template="include/dspFooter.cfm" />