/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.eventhandler {
	import flash.utils.Dictionary;
	import com.firemoss.modelglue.util.Iterator;
	import com.firemoss.modelglue.event.ModelGlueEvent;
	import com.firemoss.modelglue.error.ModelGlueError;
	

	public class MessageBroadcast {
		/* Static */
		private static var messageBroadcasts:Dictionary = new Dictionary();
		
		public static function forMessageNamed(name:String):MessageBroadcast {
			if (MessageBroadcast.messageBroadcasts[name] == null) {
				MessageBroadcast.messageBroadcasts[name] = new MessageBroadcast(name);
			}
			
			return MessageBroadcast.messageBroadcasts[name];
		}

		/* Instance */	
		public var name:String;
		public var listeners:Array;
		public var arguments:Dictionary;
		
		public function MessageBroadcast(name:String) {
			this.name = name;
			this.listeners = new Array();
			this.arguments = new Dictionary();
		}
		
		public function addListener(target:Object, callback:Function):void{
			// Get the "singleton" version of this broadcast
			var mb:MessageBroadcast = MessageBroadcast.forMessageNamed(this.name);

			var listener:Listener = new Listener(target, callback);
			mb.listeners.push(listener);
		}
		
		public function invokeListeners(e:ModelGlueEvent):void {
			// Get the "singleton" version of this broadcast
			var mb:MessageBroadcast = MessageBroadcast.forMessageNamed(this.name);

			var listener:Listener;
			var i:int;
			
			for (i=0;i<mb.listeners.length;i++) {
				listener = mb.listeners[i] as Listener;
				listener.invoke(e);
				
				if (e.stopped) {
					break;
				}
			}			
		}
		
		public function addArgument(name:String, value:*):void {
			this.arguments[name] = value;
		}
		
	}
}