<cfsetting enablecfoutputonly=true>
<!---
	Name         : handlers/multiplechoice/save.cfm
	Author       : Raymond Camden 
	Created      : September 21, 2004
	Last Updated : March 30, 2006
	History      : 255 limit (rkc 10/12/05)
				 : tableprefix fix (rkc 3/30/06)
	Purpose		 : Supports True/False, Yes/No
--->

<cfscript>
/**
 * Returns TRUE if the string is a valid CF UUID.
 * 
 * @param str 	 String to be checked. (Required)
 * @return Returns a boolean. 
 * @author Jason Ellison (jgedev@hotmail.com) 
 * @version 1, November 24, 2003 
 */
function IsCFUUID(str) {  	
	return REFindNoCase("^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{16}$", str);
}
</cfscript>

<cfparam name="attributes.answer">
<cfparam name="attributes.questionidfk">
<cfparam name="attributes.owner">

<cfparam name="attributes.single" default="true">
<cfparam name="attributes.other" default="false">

<cfloop index="answer" list="#attributes.answer#">
	<cfquery datasource="#application.settings.dsn#">
		insert into #application.settings.tableprefix#results(owneridfk,questionidfk
			<cfif not attributes.other or isCFUUID(answer)>
			,answeridfk
			<cfelse>
			,other
			</cfif>
			)
		values(
			<cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="35" value="#attributes.owner#">,
			<cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="35" value="#attributes.questionidfk#">,
			<cfif isCFUUID(answer)>
				<cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="35" value="#answer#">
			<cfelse>
				<cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="255" value="#left(answer,255)#">
			</cfif>
		)
	</cfquery>
</cfloop>
				
<cfsetting enablecfoutputonly=false>

<cfexit method="exittag">