<cfsetting enablecfoutputonly=true>
<!---
	Name         : handlers/matrix/stats.cfm
	Author       : Raymond Camden 
	Created      : October 7, 2005
	Last Updated : March 30, 2006
	History      : Fix to ordering (rkc 2/11/06)
				 : tableprefix fix (rkc 3/30/06)
	Purpose		 : Maxtrix
--->

<cfparam name="attributes.questionidfk">
<cfparam name="attributes.r_data" type="variablename">


<cfset data = structNew()>
	
<!--- get my answer data --->
<cfset answers = application.question.getAnswers(attributes.questionidfk)>

<cfquery name="getAnswers" dbtype="query">
	select 		*
	from		answers
	where		rank >= 0
	order by 	rank asc
</cfquery>

<cfquery name="getItems" dbtype="query">
	select 		*
	from		answers
	where		rank < 0
	order by 	rank desc
</cfquery>

<!--- Pass to data a sorted list of answers to use in graphiing. --->
<cfset data.sortedAnswers = valueList(getAnswers.id)>
<!--- Pass to data a sorted list of items to use in graphiing. --->
<cfset data.sortedItems = valueList(getItems.id)>
	
<cfloop query="getItems">

	<cfset itemid = id>
	<cfset item = answer>
	<cfset data[itemid] = structNew()>
	
	<cfloop query="getAnswers">
		
		<cfquery name="getcount" datasource="#application.settings.dsn#">
			select	count(answeridfk) as total
			from	#application.settings.tableprefix#results
			where	answeridfk = <cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="35" value="#id#">
			and		itemidfk = <cfqueryparam cfsqltype="CF_SQL_VARCHAR" maxlength="35" value="#itemid#">
		</cfquery>
	
		<cfset data[itemid][id] = structNew()>
		<cfset data[itemid][id].label = answer>
		<cfset data[itemid][id].count = getcount.total>
		<cfset data[itemid][id].rank = rank>
		<cfset data[itemid].label = item>
	</cfloop>

</cfloop>
	
		
	
<cfset caller[attributes.r_data] = data>				
<cfsetting enablecfoutputonly=false>

<cfexit method="exittag">