/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.util
{
	public class Iterator
	{
		
		private var source:Array;
		private var position:int;
		
		public function Iterator(source:Array) {
			this.source = source;
			this.position = 0;
		}
		
		public function hasNext():Boolean {
			return this.position < this.source.length - 1;
		}
		
		public function next():Object {
			if (!hasNext()) throw new Error("Iterator does not have next element!");
			return this.source[this.position];
			this.position++;
		}
		
	}
}