/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.flex.examples.todolists.model
{
	import com.firemoss.collections.SubscribableArrayCollection;
	import mx.collections.ArrayCollection;

	public class TodoCollection extends SubscribableArrayCollection
	{
		[Bindable]
		public var complete:ArrayCollection;
		[Bindable]
		public var incomplete:ArrayCollection;
		
		public function TodoCollection(source:Array=null) {
			super(source);
			
			this.complete = new ArrayCollection();
			this.complete.filterFunction = this.completeFilter;
			this.complete.refresh();
			this.addSubscriber(this.complete);
						
			this.incomplete = new ArrayCollection();
			this.incomplete.filterFunction = this.incompleteFilter;
			this.incomplete.refresh();
			this.addSubscriber(this.incomplete);
		}
		
		public function incompleteFilter(item:Object):Boolean {
			var todo:Todo = item as Todo;
			
			return !todo.complete;
		}

		public function completeFilter(item:Object):Boolean {
			var todo:Todo = item as Todo;
			
			return todo.complete;
		}
		
		public function find(todo:Todo):Todo {
			var i:int;
			var result:Todo;
			
			for (i=0;i<this.length;i++) {
				if (this[i].name == todo.name) return this[i];	
			}	
			
			return result;
		}
				
	}
}