DROP TABLE IF EXISTS `galleon_conferences`;
CREATE TABLE `galleon_conferences` (
  `Id` varchar(35) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `active` tinyint(1) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_forums`;
CREATE TABLE `galleon_forums` (
  `id` varchar(35) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  `readonly` tinyint(1) NOT NULL default '0',
  `active` tinyint(1) NOT NULL default '0',
  `attachments` tinyint(1) NOT NULL default '0',
  `conferenceidfk` varchar(35) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `galleon_forums_conferenceidfk` (`conferenceidfk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_groups`;
CREATE TABLE `galleon_groups` (
  `Id` varchar(35) NOT NULL default '',
  `group` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_messages`;
CREATE TABLE `galleon_messages` (
  `Id` varchar(35) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `body` text NOT NULL,
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  `useridfk` varchar(35) NOT NULL default '',
  `threadidfk` varchar(35) NOT NULL default '',
  `attachment` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`Id`),
  KEY `galleon_messages_useridfk` (`useridfk`),
  KEY `galleon_messages_threadidfk` (`threadidfk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `galleon_ranks`;
CREATE TABLE `galleon_ranks` (
  `Id` varchar(35) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `minposts` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_search_log`;
CREATE TABLE `galleon_search_log` (
  `searchterms` varchar(255) NOT NULL default '',
  `datesearched` datetime NOT NULL default '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_subscriptions`;
CREATE TABLE `galleon_subscriptions` (
  `Id` varchar(35) NOT NULL default '',
  `useridfk` varchar(35) default NULL,
  `threadidfk` varchar(35) default NULL,
  `forumidfk` varchar(35) default NULL,
  `conferenceidfk` varchar(35) default NULL,
  PRIMARY KEY  (`Id`),
  KEY `galleon_subscriptions_useridfk` (`useridfk`),
  KEY `galleon_subscriptions_threadidfk` (`threadidfk`),
  KEY `galleon_subscriptions_forumidfk` (`forumidfk`),
  KEY `galleon_subscriptions_conferenceidfk` (`conferenceidfk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `galleon_threads`;
CREATE TABLE `galleon_threads` (
  `Id` varchar(35) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `active` tinyint(1) NOT NULL default '0',
  `readonly` tinyint(1) NOT NULL default '0',
  `useridfk` varchar(35) NOT NULL default '',
  `forumidfk` varchar(35) NOT NULL default '',
  `datecreated` datetime NOT NULL default '0000-00-00 00:00:00',
  `sticky` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`Id`),
  KEY `galleon_threads_useridfk` (`useridfk`),
  KEY `galleon_threads_forumidfk` (`forumidfk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `galleon_users`;
CREATE TABLE `galleon_users` (
  `Id` varchar(35) NOT NULL default '',
  `username` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `emailaddress` varchar(255) NOT NULL default '',
  `signature` text NOT NULL,
  `datecreated` datetime NOT NULL default '0000-00-00 00:00:00',
  `confirmed` tinyint(1) NOT NULL default '0',
  `name` varchar(50) default NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `galleon_users_groups`;
CREATE TABLE `galleon_users_groups` (
  `useridfk` varchar(35) NOT NULL default '',
  `groupidfk` varchar(35) NOT NULL default ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `tblblogcategories`;
CREATE TABLE `tblblogcategories` (
  `categoryid` varchar(35) character set latin1 NOT NULL default '',
  `categoryname` varchar(50) character set latin1 NOT NULL default '',
  `categoryalias` varchar(50) default NULL,
  `blog` varchar(50) character set latin1 NOT NULL default '',
  PRIMARY KEY  (`categoryid`),
  KEY `blogCategories_blog` (`blog`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `tblblogcomments`;
CREATE TABLE `tblblogcomments` (
  `id` varchar(35) character set latin1 NOT NULL default '',
  `entryidfk` varchar(35) character set latin1 default NULL,
  `name` varchar(50) character set latin1 default NULL,
  `email` varchar(50) character set latin1 default NULL,
  `comment` text character set latin1,
  `posted` datetime default NULL,
  `subscribe` tinyint(1) default NULL,
  `website` varchar(255) default NULL,
  `moderated` tinyint(1) default NULL,
  `killcomment` varchar(35) default NULL,
  `subscribeonly` tinyint(4) default NULL,
  PRIMARY KEY  (`id`),
  KEY `blogComments_entryid` (`entryidfk`),
  KEY `blogComments_posted` (`posted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogentries`;
CREATE TABLE `tblblogentries` (
  `id` varchar(35) character set latin1 NOT NULL default '',
  `title` varchar(100) character set latin1 NOT NULL default '',
  `body` text character set latin1 NOT NULL,
  `posted` datetime NOT NULL default '0000-00-00 00:00:00',
  `morebody` text character set latin1,
  `alias` varchar(100) character set latin1 default NULL,
  `username` varchar(50) character set latin1 default NULL,
  `blog` varchar(50) character set latin1 NOT NULL default '',
  `allowcomments` tinyint(1) NOT NULL default '0',
  `enclosure` varchar(255) character set latin1 default NULL,
  `filesize` int(11) default NULL,
  `mimetype` varchar(255) character set latin1 default NULL,
  `views` int(11) default NULL,
  `released` tinyint(1) default '0',
  `mailed` tinyint(1) default '0',
  `summary` varchar(255) default NULL,
  `subtitle` varchar(100) default NULL,
  `keywords` varchar(100) default NULL,
  `duration` varchar(10) default NULL,
  PRIMARY KEY  (`id`),
  KEY `blogEntries_blog` (`blog`),
  KEY `blogEntries_released` (`released`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `tblblogentriescategories`;
CREATE TABLE `tblblogentriescategories` (
  `categoryidfk` varchar(35) character set latin1 default NULL,
  `entryidfk` varchar(35) character set latin1 default NULL,
  KEY `blogEntriesCategories_entryid` (`entryidfk`,`categoryidfk`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogentriesrelated`;
CREATE TABLE `tblblogentriesrelated` (
  `id` int(11) default NULL,
  `entryid` varchar(35) NOT NULL default '',
  `relatedid` varchar(35) default '',
  KEY `blogEntriesRelated_entryid` (`entryid`,`relatedid`),
  KEY `blogEntriesRelated_relatedid` (`relatedid`,`entryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogpages`;
CREATE TABLE `tblblogpages` (
  `id` varchar(35) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `alias` varchar(100) NOT NULL default '',
  `body` text NOT NULL,
  `blog` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogsearchstats`;
CREATE TABLE `tblblogsearchstats` (
  `searchterm` varchar(255) character set latin1 NOT NULL default '',
  `searched` datetime NOT NULL default '0000-00-00 00:00:00',
  `blog` varchar(50) character set latin1 NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogsubscribers`;
CREATE TABLE `tblblogsubscribers` (
  `email` varchar(50) character set latin1 NOT NULL default '',
  `token` varchar(35) character set latin1 NOT NULL default '',
  `blog` varchar(50) character set latin1 default NULL,
  `verified` tinyint(1) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `tblblogtextblocks`;
CREATE TABLE `tblblogtextblocks` (
  `id` varchar(35) NOT NULL default '',
  `label` varchar(255) NOT NULL default '',
  `body` text NOT NULL,
  `blog` varchar(50) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblblogtrackbacks`;
CREATE TABLE `tblblogtrackbacks` (
  `Id` varchar(35) character set latin1 NOT NULL default '',
  `title` varchar(255) character set latin1 NOT NULL default '',
  `blogname` varchar(255) character set latin1 NOT NULL default '',
  `posturl` varchar(255) character set latin1 NOT NULL default '',
  `excerpt` text character set latin1 NOT NULL,
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `entryid` varchar(35) character set latin1 NOT NULL default '',
  `blog` varchar(50) character set latin1 NOT NULL default '',
  PRIMARY KEY  (`Id`),
  KEY `blogTrackBacks_entryid` (`entryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `tblusers`;
CREATE TABLE `tblusers` (
  `username` varchar(50) character set latin1 default NULL,
  `password` varchar(50) character set latin1 default NULL,
  `name` varchar(50) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


