/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.service {

	import com.firemoss.modelglue.error.ModelGlueError;
	import mx.rpc.AbstractService;
	
	public class ServiceLocator {
	
		private static var instance:ServiceLocator;
	
		public static function getInstance():ServiceLocator {
			if (!ServiceLocator.instance) ServiceLocator.instance = new ServiceLocator();
			
			return ServiceLocator.instance;
		}
		
		public function ServiceLocator() {
			if (ServiceLocator.instance) throw new ModelGlueError(ModelGlueError.MODEL_GLUE_SINGLETON_EXCEPTION, "ServiceLocator singleton error!");
			
			ServiceLocator.instance = this;
		}
		
		public function getService(id:String):AbstractService {
			if (this[id] == null) throw new ModelGlueError(ModelGlueError.MODEL_GLUE_SERVICE_NOT_DEFINED, "No service with an ID of " + id + " is declared.");
			
			return this[id];
		}
	}
}
