/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.event {

	import flash.utils.Dictionary;
	import com.firemoss.modelglue.error.ModelGlueError;
	import com.firemoss.modelglue.Framework;
	import com.firemoss.modelglue.eventhandler.EventHandler;
	import com.firemoss.modelglue.eventhandler.MessageBroadcast;
	import com.firemoss.modelglue.tags.event.Result;
	import mx.controls.Alert;
	import com.firemoss.modelglue.tags.event.Handler;
	
	public class ModelGlueEvent {

		private var modelGlue:Framework = Framework.getInstance();
		private var broadcast:MessageBroadcast;
		private var eventHandlerQueue:Array;

		private var _stopped:Boolean = false;
		public function get stopped():Boolean {
			return this._stopped;
		}
		public function set stopped(value:Boolean):void {
			if (value) {
				this.eventHandlerQueue = new Array();
				this.currentEventHandler = null;
				this.data = new Dictionary();
			}
			
			this._stopped = value;
		}
		
		public var name:String;
		public var currentEventHandler:EventHandler;
		public var data:Dictionary;

		public function ModelGlueEvent(name:String, values:Object=null) {
			this.eventHandlerQueue = new Array();
			this.addEventHandlerForEventNamed(name);
			this.name = name;
			this.data = new Dictionary();
			
			if (values) addValues(values);
		}
		
		public function dispatch():void {
			this.modelGlue.handleEvent(this);
		}
		
		public function addValues(values:Object):void {
			var i:*;
			
			for (i in values) {
				setValue(i, values[i]);
			}
		}
		
		public function getValue(name:String, defaultValue:*=null):* {
			var value:*;
			
			if (!this.exists(name)) {
				if (defaultValue == null) 
					throw new ModelGlueError(ModelGlueError.MODEL_GLUE_VALUE_NOT_DEFINED, "The value '" + name + "' is not defined, and no default was specified!");
				else
					setValue(name, defaultValue);
			}
			
			value = this.data[name];
			
			return value;
		}
		
		public function setValue(name:String, value:*):void {
			this.data[name] = value;
		}
		
		public function exists(name:String):Boolean {
			return (this.data.hasOwnProperty(name));
		}
		
		public function addResult(name:String):void {
			var i:int;
			var handler:EventHandler = this.currentEventHandler;
			var results:Array = handler.getExplicitResults(name);
			var result:Result;
			
			for (i=0;i<results.length;i++) {
				result = results[i] as Result;

				if (result.stop) {
					this._stopped = true;
				} else {
					if (result.eventHandler is String) {
						this.addEventHandlerForEventNamed(result.eventHandler as String);
					} else if (result.eventHandler is Handler) {
						this.addEventHandlerForEventNamed(result.eventHandler.name);
					}
				}
			}
		}
		
		public function addEventHandlerForEventNamed(name:String):void {
			var eventHandler:EventHandler = this.modelGlue.getEventHandlerForEventNamed(name);
			this.eventHandlerQueue.push(eventHandler);
		}
			
		public function hasNextEventHandler():Boolean {
			return (this.eventHandlerQueue.length > 0);
		}
		
		public function nextEventHandler():EventHandler {
			if (!this.hasNextEventHandler()) throw new ModelGlueError(ModelGlueError.MODEL_GLUE_EVENT_HANDLER_QUEUE_EMPTY, "nextEventHandler() was called when queue was empty.");
			this.currentEventHandler = this.eventHandlerQueue.shift();
			return this.currentEventHandler;
		}
		
		public function setCurrentMessageBroadcast(mb:MessageBroadcast):void {
			this.broadcast = mb;
		}
		
		public function getArgument(name:String, defaultValue:*=null):* {
			var arguments:Dictionary = this.broadcast.arguments;
			
			if (arguments[name] != null) {
				return arguments[name];
			} else {
				if (defaultValue != null) {
					return defaultValue;
				} else {
					throw new ModelGlueError(ModelGlueError.MODEL_GLUE_ARGUMENT_NOT_DEFINED, "The argument '" + name + "' is not defined in the message broadcast.");
				}
			}
		}
		
	}
}