/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.flex.examples.todolists.control
{
	import com.firemoss.modelglue.controller.ModelGlueController;
	import com.firemoss.modelglue.flex.examples.todolists.model.ModelLocator;
	import com.firemoss.modelglue.flex.examples.todolists.data.TodoListDAO;
	import com.firemoss.modelglue.flex.examples.todolists.model.Todo;
	import com.firemoss.modelglue.event.ModelGlueEvent;

	public class TodoController extends ModelGlueController
	{
		private var model:ModelLocator = ModelLocator.getInstance();
		private var dao:TodoListDAO = new TodoListDAO();
		
		public function loadTodos(e:ModelGlueEvent):void {
			model.todos = dao.load();	
		}

		public function saveTodo(e:TodoEvent):void {
			//var todo:Todo = e.getValue("todo") as Todo;
			var todo:Todo = e.todo;
			
			var existing:Todo = model.todos.find(todo);
			
			if (existing == null) {
				if (!model.todos.contains(todo)) model.todos.addItem(todo);
				
				dao.save(model.todos);
			} else if (existing != todo) {
				e.setValue("message", "A to-do already exists for \"" + todo.name + "!\"");
				e.setValue("title", "Whoops!");
				e.addResult(Results.duplicateTodo);
			}
		}

		public function deleteTodo(e:TodoEvent):void {
			var todo:Todo = e.getValue("todo") as Todo;
			
		
			if (model.todos.contains(todo)) {
				model.todos.removeItemAt(model.todos.getItemIndex(todo));
			}
			
			dao.save(model.todos);
		}
		
	}
}