/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.examples.contactmanager.business
{
	import mx.rpc.AbstractService;
	import com.firemoss.modelglue.service.ServiceLocator;
	import com.firemoss.modelglue.service.AsynchronousOperationHelper;
	import com.firemoss.modelglue.service.BusinessDelegate;
	import com.firemoss.modelglue.examples.contactmanager.model.ContactTO;
	import mx.rpc.events.ResultEvent;
	import com.firemoss.modelglue.event.ModelGlueEvent;
	import mx.rpc.AsyncToken;
	
	public class ColdFusionContactBusinessDelegate implements IContactBusinessDelegate
	{

		private var service:AbstractService = ServiceLocator.getInstance().getService("contactService");
		
		public function list(resultCallbackFunction:Function):void {
			var helper:AsynchronousOperationHelper = new AsynchronousOperationHelper(service.list(), resultCallbackFunction);
		}
		
		public function destroy(contact:ContactTO, resultCallbackFunction:Function):void {
			var helper:AsynchronousOperationHelper = new AsynchronousOperationHelper(service.destroy(contact), resultCallbackFunction);
		}

		/* 
			Save is special:  because we need to work with its result before sending it back 
			into the controller tier, we'll deal with the operation manually and use the token
			to store the arguments to the operation for access in its result handler.
			
			We tell the helper to send the ResultEvent (instead of ResultEvent.result) to 
			the callback function (contactSaved) by passing "true" for the handleResultManually
			argument.
		*/
		public function save(contact:ContactTO):void {
			var token:AsyncToken = service.save(contact);
			token.contact = contact;

			var helper:AsynchronousOperationHelper = new AsynchronousOperationHelper(token, contactSaved, null, true);
		}
		
		private function contactSaved(e:ResultEvent):void {
			var contact:ContactTO = e.result as ContactTO;
			var originalContact:ContactTO = e.token.contact;
			
			// Merge state updates from the service back onto the client-side model.
			originalContact.contactId = contact.contactId;
			
			
			/*
				Instead of using callbacks, we set up a M-G event to handle contacts
				coming from the server side:  this makes things like implementing FDS
				in an optional manner a snap!
			*/
			new ModelGlueEvent("contact.received", {contact:contact}).dispatch();
		}
		
	}
}