/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.firemoss.modelglue.error
{
	public class ModelGlueError extends Error
	{
		public static var MODEL_GLUE_SINGLETON_EXCEPTION:String = "Singleton exception: instance already exists!";
		public static var MODEL_GLUE_VALUE_NOT_DEFINED:String = "Value not defined in event context!";
		public static var MODEL_GLUE_EVENT_HANDLER_NOT_DEFINED:String = "Event handler not defined!";
		public static var MODEL_GLUE_EVENT_HANDLER_QUEUE_EMPTY:String = "The event has no more handlers to invoke!";
		public static var MODEL_GLUE_ARGUMENT_NOT_DEFINED:String = "Argument not defined in message!";
		public static var MODEL_GLUE_SERVICE_NOT_DEFINED:String = "Service is not registered with service locator.";
		public static var MODEL_GLUE_DELEGATE_CONSTRUCTOR_BAD:String = "Either a name of a registered service (in the ServiceLocator singleton) or an instance of AbstractService must is required to construct a BusinessDelegate!";
		public static var MODEL_GLUE_CONTROLLER_NOT_FOUND:String = "No controller by that id exists!";
		
		public function ModelGlueError(outerMessage:String, innerMessage:String) {
			super(outerMessage + " (" + innerMessage + ")");
		}
		
	}
}