/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.collections
{
	import mx.collections.ArrayCollection;
	import mx.events.CollectionEvent;

	public class SubscribableArrayCollection extends ArrayCollection
	{
		private var _subscribers:Array;
		
		public function SubscribableArrayCollection(source:Array=null) {
			super(source);
			
			this._subscribers = new Array();
			
			this.addEventListener(CollectionEvent.COLLECTION_CHANGE, updateSubscribers);
		}
		
		public function addSubscriber(subscriber:ArrayCollection):void {
			if (!this.containsSubscriber(subscriber)) {
				this._subscribers.push(subscriber);
			}
		}
		
		public function containsSubscriber(subscriber:ArrayCollection):Boolean {
			var i:int;
			
			for (i=0;i<this._subscribers.length;i++) {
				if (this._subscribers[i] == subscriber) return true;
			}
			
			return false;
		}
		
		private function updateSubscribers(e:CollectionEvent):void {
			var i:int;
			
			for (i=0;i<this._subscribers.length;i++) {
				this._subscribers[i].source = this.source;
			}
			
			
		}
		
	}
}