/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.examples.contactmanager.control
{
	import com.firemoss.modelglue.event.ModelGlueEvent;
	import com.firemoss.modelglue.examples.contactmanager.model.ContactTO;
	import mx.controls.Alert;
	import com.firemoss.modelglue.examples.contactmanager.control.event.ContactEvent;
	import com.firemoss.modelglue.service.ServiceProxy;
	import com.firemoss.modelglue.controller.ModelGlueController;
	import com.firemoss.modelglue.examples.contactmanager.model.UIMessages;
	import mx.rpc.events.ResultEvent;
	import mx.collections.ArrayCollection;
	import com.firemoss.modelglue.examples.contactmanager.business.IContactBusinessDelegate;
	import com.firemoss.modelglue.examples.contactmanager.business.ColdFusionContactBusinessDelegate;
	import com.firemoss.modelglue.examples.contactmanager.business.MockContactBusinessDelegate;

	public class ContactController extends ModelGlueController
	{
		private var contactDelegate:ServiceProxy = getService("contactService");
		//private var contactBusinessDelegate:IContactBusinessDelegate = new ColdFusionContactBusinessDelegate();
		private var contactBusinessDelegate:IContactBusinessDelegate = new MockContactBusinessDelegate();
		
		[Bindable]
		public var contacts:ArrayCollection = new ArrayCollection();
		[Bindable]
		public var currentContact:ContactTO;
		[Bindable]
		public var applicationStatus:String;
		
		public function listContacts(event:ModelGlueEvent):void {
			this.applicationStatus = UIMessages.CONTACTS_LOADING;
			contactBusinessDelegate.list(newContactList);
		}
		
		public function newContactList(contacts:Array):void {
			if (this.applicationStatus == UIMessages.CONTACTS_LOADING) this.applicationStatus = UIMessages.NOTHING;					
			this.contacts.source = contacts;
		}
		
		public function selectContact(event:ModelGlueEvent):void {
			this.currentContact = event.getValue("contact");
		}
		
		public function saveContact(event:ModelGlueEvent):void {
			var contact:ContactTO = event.getValue("contact");
			
			
			this.applicationStatus = UIMessages.CONTACT_SAVING;			
				
			if (contact.contactId == 0) this.contacts.addItem(contact);

			contactBusinessDelegate.save(contact);
		}

		public function mergeContact(event:ModelGlueEvent):void {
			this.applicationStatus = UIMessages.NOTHING;					
		}		

		public function deleteContact(event:ModelGlueEvent):void {
			var contact:ContactTO = event.getValue("contact");
			
			contactDelegate.destroy(contact);
			
			this.contacts.removeItemAt(this.contacts.getItemIndex(contact));
			
			if (this.currentContact == contact) this.currentContact = null;

		}
		
	}
}