/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.firemoss.modelglue.examples.contactmanager.business
{
	import com.firemoss.modelglue.examples.contactmanager.model.ContactTO;
	import com.firemoss.modelglue.event.ModelGlueEvent;
	
	public class MockContactBusinessDelegate implements IContactBusinessDelegate
	{
		private var contacts:Array = new Array();
		private var currentContactId:int = 10000;
		
		private function nextContactId():int {
			this.currentContactId++;
			return this.currentContactId;
		}
		
		public function MockContactBusinessDelegate():void {
			var contact:ContactTO;
		
			contact = new ContactTO();
			contact.contactId = this.nextContactId();
			contact.firstname = "Fake";
			contact.lastname  = "Contact 1";
			contact.phone = "(555)123-4567";
			contact.emailAddress = "fakeContact1@test.tst";
			contacts.push(contact);
			
			contact = new ContactTO();
			contact.contactId = this.nextContactId()
			contact.firstname = "Fake";
			contact.lastname  = "Contact 2";
			contact.phone = "(555)123-4567";
			contact.emailAddress = "fakeContact2@test.tst";
			contacts.push(contact);
		}

		public function list(resultCallbackFunction:Function):void {
			resultCallbackFunction.apply(null, [contacts]);
		}
		
		public function destroy(contact:ContactTO, resultCallbackFunction:Function):void {
			var i:int;
			
			for (i=0;i<this.contacts.length;i++) {
				if (this.contacts[i].contactId == contact.contactId) {
					this.contacts.splice(i, 1);
					break;
				}
			}

			resultCallbackFunction.apply(null);
		}

		/* 
			Save is special:  because we need to work with its result before sending it back 
			into the controller tier, we'll deal with the operation manually and use the token
			to store the arguments to the operation for access in its result handler.
			
			We tell the helper to send the ResultEvent (instead of ResultEvent.result) to 
			the callback function (contactSaved) by passing "true" for the handleResultManually
			argument.
		*/
		public function save(contact:ContactTO):void {
			if (contact.contactId == 0) {
				contact.contactId = this.nextContactId();
			};
			
			new ModelGlueEvent("contact.received", {contact:contact}).dispatch();
		}
		
	}
}