/*
   Copyright 2007, Firemoss, LLC

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package com.adobe.ac
{   
	public class ObserveValue extends Observer
	{
		private var isValueInitialized : Boolean = false;
		private var _handler : Function;
		private var _source : Object;
		private var _value : Object;
 		
		override public function get handler() : Function
		{
			return _handler;
		}
 	
		public function set handler( value : Function ) : void
		{
			_handler = value;
			if( value != null )
			{
				isHandlerInitialized = true;
				if( isHandlerInitialized && isSourceInitialized && isValueInitialized )
				{
					callHandler();
				}
			}
		}
  
		override public function get source() : Object
		{
			return _source;
		}
 	
		public function set source( value : Object ) : void
		{
			_source = value; 
			isSourceInitialized = true;    	
			if( isHandlerInitialized && isSourceInitialized && isValueInitialized )
			{
				callHandler();
			}
		}
  
		public function get value() : Object
		{
			return _value;
		}
 	
		public function set value( _value : Object ) : void
		{			
			this._value = _value;
			isValueInitialized = true;
			if( isHandlerInitialized && isSourceInitialized && isValueInitialized )
			{
				callHandler();
			}	
		} 
		
		override protected function callHandler() : void
		{
			if( source != value ) return;
			
			try
			{
				handler.call();
			}
			catch( e : Error )
			{
				delay( e );
			}
		}		
	}
}