<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.89).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent output="false" hint="I am a Model-Glue controller.  I contain ""listener functions"" that are executed in response to messages broadcast by EventHandlers, subscribed by addEventListener().">

<cffunction name="init" output="false" hint="Constructor.">
	<cfargument name="modelglue" required="false" hint="Instance of ModelGlue itself.  Not necessary for construction, and primarily included for reverse compatibility." />
	
	<cfif structKeyExists(arguments, "modelglue")>
		<cfset setModelGlue(arguments.modelglue) />
	</cfif>
	
	<cfreturn this />
</cffunction>

<cffunction name="setModelGlue" output="false" hint="I set the core ModelGlue instance this controller is concerned with.">
	<cfargument name="modelGlue" hint="The instance of Model-Glue in question." />
	<cfset variables._modelGlue = arguments.modelGlue />
</cffunction>
<cffunction name="getModelGlue" output="false" hint="I get the core ModelGlue instance this controller is concerned with.">
	<cfreturn variables._modelGlue />
</cffunction>

<cffunction name="setHelpers" output="false" hint="Sets the ""helpers"" scope into this controller.">
	<cfargument name="helpers" />
	<cfset variables.helpers = arguments.helpers />
</cffunction>


</cfcomponent>