<!---
LICENSE INFORMATION:

Copyright 2008, Joe Rinehart
 
Licensed under the Apache License, Version 2.0 (the "License"); you may not 
use this file except in compliance with the License. 

You may obtain a copy of the License at 

	http://www.apache.org/licenses/LICENSE-2.0 
	
Unless required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
CONDITIONS OF ANY KIND, either express or implied. See the License for the 
specific language governing permissions and limitations under the License.

VERSION INFORMATION:

This file is part of Model-Glue Model-Glue (Gesture) Alpha 1 (3.0.77).

The version number in parenthesis is in the format versionNumber.subversion.revisionNumber.
--->


<cfcomponent extends="mxunit.framework.TestCase" output="false">

<cffunction name="testSimpleTimedCache" access="public" returntype="void">
	<cfset var cache = createObject("component", "ModelGlue.gesture.externaladapters.contentcaching.SimpleTimedCache").init(5, 2) />
	<cfset var item = "" />
	
	<cfset item = cache.get("key") />
	<cfset assertFalse(item.success, "Item didn't initially fail to retrieve!") />
	
	<cfset item = cache.put("key", "content") />
	<cfset item = cache.get("key") />
	<cfset assertTrue(item.success, "Item didn't initially retrieve!") />

	<!--- Wait and sweep: should be gone based on default. --->
	<cfset item = cache.get("key") />
	<cfset assertTrue(item.success, "Item didn't retrieve before default sweep test!") />
	<cfset sleep(1000) />
	<cfset item = cache.get("key") />
	<cfset assertTrue(item.success, "Item didn't retrieve within acceptable pause in default sweep test!") />
	<cfset sleep(2000) />
	<cfset cache.sweep() />
	<cfset item = cache.get("key") />
	<cfset assertFalse(item.success, "Item retrieved after default sweep!") />
	
	<cfset item = cache.put("key", "content", 4) />
	<!--- Wait and sweep: should be gone based on explicit. --->
	<cfset item = cache.get("key") />
	<cfset assertTrue(item.success, "Item didn't retrieve before explicit sweep test!") />
	<cfset sleep(2000) />
	<cfset item = cache.get("key") />
	<cfset assertTrue(item.success, "Item didn't retrieve within acceptable pause in explicit sweep test!") />
	<cfset sleep(3000) />
	<cfset cache.sweep() />
	<cfset item = cache.get("key") />
	<cfset assertFalse(item.success, "Item retrieved after explicit sweep!") />
	
</cffunction>

</cfcomponent>